/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.easy.excel.processor;

import com.wu.framework.easy.excel.CellCoordinate;
import com.wu.framework.easy.excel.endpoint.EasyExcelFiledPoint;
import com.wu.framework.easy.excel.endpoint.EasyExcelPoint;
import com.wu.framework.easy.excel.processor.AbstractNormalBeanEasyExcelProcessor;
import com.wu.framework.easy.excel.processor.EasyExcelProcessor;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.util.ObjectUtils;

public abstract class AbstractNormalMapEasyExcelProcessor
extends AbstractNormalBeanEasyExcelProcessor
implements EasyExcelProcessor {
    @Override
    public boolean support(Object excelBean) {
        return excelBean != null && Map.class.isAssignableFrom(excelBean.getClass());
    }

    @Override
    public <T> List<T> importExcel(Object excel) {
        return null;
    }

    @Override
    public List<EasyExcelFiledPoint> createRowTitle(Workbook workbook, Sheet hssfSheet, EasyExcelPoint easyExcelPoint, List<?> beanLis, int columnIndex) throws InstantiationException, IllegalAccessException {
        return super.createRowTitle(workbook, hssfSheet, easyExcelPoint, beanLis, columnIndex);
    }

    public List<EasyExcelFiledPoint> dynamicCreateRowTitle(Sheet hssfSheet, int columnIndex, Object columnName) {
        Row row = hssfSheet.getRow(this.TITLE_COLUMN);
        if (row == null) {
            row = hssfSheet.createRow(this.TITLE_COLUMN);
        }
        Cell cell = row.createCell(columnIndex);
        AbstractNormalMapEasyExcelProcessor.setRowColumnContent(cell, columnName);
        return null;
    }

    public CellCoordinate handlerPadOneMapRowData(Sheet hssfSheet, EasyExcelPoint easyExcelPoint, List<EasyExcelFiledPoint> excelFiledPointList, Object rowData, CellCoordinate cellCoordinate, Boolean isDeepMerge) {
        int startRowIndex = cellCoordinate.getEndRowIndex();
        int lastCellStartRowIndex = cellCoordinate.getStartRowIndex();
        int lastCellEndRowIndex = cellCoordinate.getEndRowIndex();
        int lastCellStartColumnIndex = cellCoordinate.getStartColumnIndex();
        int lastCellEndColumnIndex = cellCoordinate.getEndColumnIndex();
        try {
            Row row = hssfSheet.getRow(startRowIndex);
            if (row == null) {
                row = hssfSheet.createRow(startRowIndex);
            }
            for (EasyExcelFiledPoint easyExcelFiledPoint : excelFiledPointList) {
                Integer currentColumnIndex = easyExcelFiledPoint.getCurrentColumnIndex();
                if (Map.class.isAssignableFrom(rowData.getClass())) {
                    String fieldName = easyExcelFiledPoint.getFieldName();
                    Object fieldValue = ((Map)rowData).get(fieldName);
                    if (easyExcelFiledPoint.isBeanFiled()) {
                        if (null == fieldValue) {
                            cellCoordinate.setEndColumnIndex(currentColumnIndex + easyExcelFiledPoint.getExcelBeanFiledPointList().size());
                            continue;
                        }
                        cellCoordinate.setEndColumnIndex(currentColumnIndex);
                        cellCoordinate = this.handlerPadOneMapRowData(hssfSheet, easyExcelPoint, easyExcelFiledPoint.getExcelBeanFiledPointList(), fieldValue, cellCoordinate, isDeepMerge);
                        cellCoordinate.setEndRowIndex(cellCoordinate.getEndRowIndex() - 1);
                        continue;
                    }
                    if (easyExcelFiledPoint.isCollectionFiled()) {
                        List fieldValueList = (List)fieldValue;
                        if (ObjectUtils.isEmpty((Object)fieldValueList)) {
                            cellCoordinate.setEndColumnIndex(cellCoordinate.getEndColumnIndex() + 1);
                            continue;
                        }
                        cellCoordinate.setEndColumnIndex(currentColumnIndex);
                        cellCoordinate.setStartRowIndex(startRowIndex);
                        cellCoordinate = this.handlerPadRowMapData(hssfSheet, easyExcelPoint, easyExcelFiledPoint.getExcelBeanFiledPointList(), fieldValueList, cellCoordinate, true);
                        cellCoordinate.setEndRowIndex(cellCoordinate.getEndRowIndex() - 1);
                        Integer endColumnIndex = currentColumnIndex - 1;
                        CellCoordinate mergeCellCoordinate = new CellCoordinate();
                        mergeCellCoordinate.setStartRowIndex(isDeepMerge != false ? cellCoordinate.getStartRowIndex() : startRowIndex);
                        mergeCellCoordinate.setEndRowIndex(cellCoordinate.getEndRowIndex());
                        EasyExcelFiledPoint miniColumnEasyExcelFiledPoint = excelFiledPointList.stream().min(Comparator.comparing(EasyExcelFiledPoint::getCurrentColumnIndex)).get();
                        mergeCellCoordinate.setStartColumnIndex(miniColumnEasyExcelFiledPoint.getCurrentColumnIndex());
                        mergeCellCoordinate.setEndColumnIndex(endColumnIndex);
                        this.mergeColumn(mergeCellCoordinate, hssfSheet, 1);
                        continue;
                    }
                    Cell hssfCell = row.createCell(currentColumnIndex.intValue());
                    hssfCell.setCellStyle(easyExcelFiledPoint.getCellStyle());
                    AbstractNormalMapEasyExcelProcessor.setRowColumnContent(hssfCell, fieldValue);
                    cellCoordinate.setEndColumnIndex(currentColumnIndex);
                    continue;
                }
                if (!AbstractNormalMapEasyExcelProcessor.isWrapClass(rowData.getClass())) continue;
                Cell hssfCell = row.createCell(currentColumnIndex.intValue());
                hssfCell.setCellStyle(easyExcelFiledPoint.getCellStyle());
                AbstractNormalMapEasyExcelProcessor.setRowColumnContent(hssfCell, rowData);
                cellCoordinate.setEndColumnIndex(currentColumnIndex);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (isDeepMerge.booleanValue()) {
            CellCoordinate mergeCellCoordinate = new CellCoordinate();
            mergeCellCoordinate.setStartRowIndex(lastCellStartRowIndex);
            mergeCellCoordinate.setEndRowIndex(cellCoordinate.getEndRowIndex());
            EasyExcelFiledPoint miniColumnEasyExcelFiledPoint = excelFiledPointList.stream().min(Comparator.comparing(EasyExcelFiledPoint::getCurrentColumnIndex)).get();
            EasyExcelFiledPoint maxColumnEasyExcelFiledPoint = excelFiledPointList.stream().max(Comparator.comparing(EasyExcelFiledPoint::getCurrentColumnIndex)).get();
            mergeCellCoordinate.setStartColumnIndex(miniColumnEasyExcelFiledPoint.getCurrentColumnIndex());
            mergeCellCoordinate.setEndColumnIndex(maxColumnEasyExcelFiledPoint.getCurrentColumnIndex() - 1);
            this.mergeColumn(mergeCellCoordinate, hssfSheet, 1);
        }
        cellCoordinate.setEndRowIndex(cellCoordinate.getEndRowIndex() + 1);
        return cellCoordinate;
    }

    public CellCoordinate handlerPadRowMapData(Sheet hssfSheet, EasyExcelPoint easyExcelPoint, List<EasyExcelFiledPoint> excelFiledPointList, List rowData, CellCoordinate cellCoordinate, Boolean isDeepMerge) {
        int columnIndex = cellCoordinate.getStartColumnIndex();
        for (Object rowDatum : rowData) {
            cellCoordinate = this.handlerPadOneMapRowData(hssfSheet, easyExcelPoint, excelFiledPointList, rowDatum, cellCoordinate, isDeepMerge);
            cellCoordinate.setStartColumnIndex(columnIndex);
            cellCoordinate.setStartRowIndex(cellCoordinate.getEndRowIndex());
        }
        return cellCoordinate;
    }

    @Override
    public void padMapRowData(Sheet hssfSheet, EasyExcelPoint easyExcelPoint, List<Map<?, ?>> rowData, int rowIndex, int columnIndex) {
        List<EasyExcelFiledPoint> excelFiledPointList = easyExcelPoint.getExcelFiledPointList();
        CellCoordinate cellCoordinate = new CellCoordinate();
        cellCoordinate.setStartRowIndex(rowIndex);
        cellCoordinate.setEndRowIndex(rowIndex);
        cellCoordinate.setStartColumnIndex(columnIndex);
        cellCoordinate.setEndColumnIndex(columnIndex);
        this.handlerPadRowMapData(hssfSheet, easyExcelPoint, excelFiledPointList, rowData, cellCoordinate, false);
    }
}

