/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.easy.excel.service;

import com.wu.framework.easy.excel.CellRangeAddressMerge;
import com.wu.framework.easy.excel.endpoint.EasyExcelFiledPoint;
import com.wu.framework.easy.excel.endpoint.EasyExcelPoint;
import com.wu.framework.easy.excel.endpoint.convert.EasyExcelFiledPointConvert;
import com.wu.framework.easy.excel.endpoint.convert.EasyExcelPointConvert;
import com.wu.framework.easy.excel.service.ExcelExcelService;
import com.wu.framework.easy.excel.service.style.Style;
import com.wu.framework.easy.excel.service.style.StyleParam;
import com.wu.framework.easy.excel.stereotype.EasyExcelFiled;
import com.wu.framework.easy.excel.toolkit.DynamicEasyExcelContextHolder;
import com.wu.framework.easy.excel.util.ISheetShowContextMethod;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;

public class NormalExcelExportService
implements ExcelExcelService {
    public static EasyExcelPointConvert defaultPointConvert = new EasyExcelPointConvert();
    private static EasyExcelFiledPointConvert easyExcelFiledPointConvert = new EasyExcelFiledPointConvert();

    public static byte[] exportExcel(EasyExcelPoint easyExcelPoint, Collection collection) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HSSFWorkbook workbook = new HSSFWorkbook();
        if (easyExcelPoint.isMultipleSheet()) {
            List<List> splitList = ExcelExcelService.splitList(new ArrayList(collection), easyExcelPoint.getLimit());
            ISheetShowContextMethod iSheetShowContextMethod = easyExcelPoint.getSheetShowContext().getISheetShowContextMethod().newInstance();
            List<String> sheetContextList = iSheetShowContextMethod.sheetContext(collection.size(), easyExcelPoint.getLimit());
            for (int i = 0; i < splitList.size(); ++i) {
                easyExcelPoint.setSheetName(sheetContextList.get(i));
                NormalExcelExportService.normalSingleSheet(workbook, easyExcelPoint, splitList.get(i));
            }
        } else {
            NormalExcelExportService.normalSingleSheet(workbook, easyExcelPoint, collection);
        }
        workbook.write((OutputStream)out);
        return out.toByteArray();
    }

    public static void normalSingleSheet(HSSFWorkbook workbook, EasyExcelPoint easyExcel, Collection collection) {
        try {
            Iterator iterator = collection.iterator();
            if (!iterator.hasNext()) {
                throw new Exception("\u6570\u636e\u9519\u8bef");
            }
            Object ts = iterator.next();
            if (Collection.class.isAssignableFrom(ts.getClass())) {
                for (Object o2 : collection) {
                    easyExcel.setSheetName(easyExcel.getSheetName() + "-1");
                    NormalExcelExportService.normalSingleSheet(workbook, easyExcel, (Collection)o2);
                }
                return;
            }
            HSSFSheet sheet = workbook.createSheet(easyExcel.getSheetName());
            sheet.setDefaultColumnWidth(20);
            HSSFCellStyle style = workbook.createCellStyle();
            List<String> peek = DynamicEasyExcelContextHolder.peek();
            List excelFiledPointList = easyExcel.isUseAnnotation() ? Arrays.stream(ts.getClass().getDeclaredFields()).filter(field -> null != field.getAnnotation(easyExcel.getFieldColumnAnnotation())).peek(field -> field.setAccessible(true)).map(field -> {
                EasyExcelFiled easyExcelFiled = (EasyExcelFiled)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, EasyExcelFiled.class);
                assert (easyExcelFiled != null);
                EasyExcelFiledPoint converter = easyExcelFiledPointConvert.converter(easyExcelFiled);
                converter.setField((Field)field);
                converter.setEasyExcelFiled(easyExcelFiled);
                return converter;
            }).sorted(Comparator.comparing(EasyExcelFiledPoint::getSerialNumber).reversed()).collect(Collectors.toList()) : Arrays.stream(ts.getClass().getDeclaredFields()).peek(field -> field.setAccessible(true)).map(field -> {
                EasyExcelFiledPoint easyExcelFiledPoint = new EasyExcelFiledPoint();
                easyExcelFiledPoint.setField((Field)field);
                return easyExcelFiledPoint;
            }).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(peek)) {
                excelFiledPointList = excelFiledPointList.stream().filter(easyExcelFiledPoint -> !peek.contains(easyExcelFiledPoint.getField().getName())).collect(Collectors.toList());
            }
            iterator = collection.iterator();
            Object next = iterator.next();
            Class<?> dataEntityType = next.getClass();
            HSSFRow row = sheet.createRow(0);
            if (Map.class.isAssignableFrom(dataEntityType)) {
                Set keySet = ((Map)next).keySet();
                int i = 0;
                for (String key : keySet) {
                    HSSFCell hssfCell = row.createCell(i);
                    hssfCell.setCellStyle(style);
                    text = new HSSFRichTextString(key);
                    ExcelExcelService.setRowColumnContent(hssfCell, text);
                    ++i;
                }
            } else {
                if (easyExcel.isTitleFixedHead()) {
                    sheet.createFreezePane(excelFiledPointList.size(), 1);
                }
                for (int i = 0; i < excelFiledPointList.size(); ++i) {
                    String headerName;
                    HSSFCell hssfCell = row.createCell(i);
                    hssfCell.setCellStyle(style);
                    EasyExcelFiledPoint easyExcelFiledPoint2 = (EasyExcelFiledPoint)excelFiledPointList.get(i);
                    Field field2 = easyExcelFiledPoint2.getField();
                    if (easyExcel.isUseAnnotation()) {
                        Object[] dropdownOptions;
                        Annotation filedAnnotation = field2.getAnnotation(easyExcel.getFieldColumnAnnotation());
                        if (null == filedAnnotation) {
                            return;
                        }
                        Class<? extends Style> styleClass = easyExcel.getStyle();
                        Style newInstance = styleClass.newInstance();
                        CellStyle tempStyle = newInstance.titleStyle(new StyleParam((Workbook)workbook, (Sheet)sheet, filedAnnotation, i));
                        hssfCell.setCellStyle(tempStyle);
                        Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)filedAnnotation);
                        headerName = String.valueOf(annotationAttributes.getOrDefault(easyExcel.getFieldColumnAnnotationAttribute(), field2.getName()));
                        EasyExcelFiled easyExcelFiled = easyExcelFiledPoint2.getEasyExcelFiled();
                        if (!ObjectUtils.isEmpty((Object)easyExcelFiled) && !ObjectUtils.isEmpty((Object[])(dropdownOptions = easyExcelFiled.dropdownOptions()))) {
                            DataValidationHelper helper = sheet.getDataValidationHelper();
                            CellRangeAddressList addressList = new CellRangeAddressList(1, 9999, i, i);
                            DataValidationConstraint constraint = helper.createExplicitListConstraint((String[])dropdownOptions);
                            DataValidation dataValidation = helper.createValidation(constraint, addressList);
                            if (dataValidation instanceof XSSFDataValidation) {
                                dataValidation.setSuppressDropDownArrow(true);
                                dataValidation.setShowErrorBox(true);
                            } else {
                                dataValidation.setSuppressDropDownArrow(false);
                            }
                            sheet.addValidationData(dataValidation);
                        }
                    } else {
                        headerName = field2.getName();
                    }
                    text = new HSSFRichTextString(headerName);
                    ExcelExcelService.setRowColumnContent(hssfCell, text);
                }
            }
            Map<Field, CellRangeAddressMerge> mergeLevelFieldMap = excelFiledPointList.stream().filter(easyExcelFiledPoint -> {
                EasyExcelFiled mergedAnnotation = easyExcelFiledPoint.getEasyExcelFiled();
                return mergedAnnotation != null && EasyExcelFiled.EasyExcelFieldMerge.LEVEL == mergedAnnotation.fieldMerge();
            }).collect(Collectors.toMap(EasyExcelFiledPoint::getField, o -> new CellRangeAddressMerge()));
            Map<Field, CellRangeAddressMerge> mergeVerticalFieldMap = excelFiledPointList.stream().filter(easyExcelFiledPoint -> {
                EasyExcelFiled mergedAnnotation = easyExcelFiledPoint.getEasyExcelFiled();
                return mergedAnnotation != null && EasyExcelFiled.EasyExcelFieldMerge.VERTICAL == mergedAnnotation.fieldMerge();
            }).collect(Collectors.toMap(EasyExcelFiledPoint::getField, o -> new CellRangeAddressMerge()));
            int size = collection.size();
            int index = 0;
            iterator = collection.iterator();
            LinkedList<CellStyle> columnStyleList = new LinkedList<CellStyle>();
            while (iterator.hasNext()) {
                row = sheet.createRow(++index);
                Object t = iterator.next();
                if (t instanceof Map) {
                    Collection values = ((Map)t).values();
                    Iterator mapIterator = values.iterator();
                    int k = 0;
                    while (mapIterator.hasNext()) {
                        HSSFCell cell = row.createCell(k);
                        Object value = mapIterator.next();
                        cell.setCellValue(null == value ? null : String.valueOf(value));
                        ++k;
                    }
                    continue;
                }
                for (int i = 0; i < excelFiledPointList.size(); ++i) {
                    Annotation filedAnnotation;
                    Field field3 = ((EasyExcelFiledPoint)excelFiledPointList.get(i)).getField();
                    Object fieldValue = field3.get(t);
                    if (mergeVerticalFieldMap.containsKey(field3)) {
                        CellRangeAddressMerge rangeAddressMerge = mergeVerticalFieldMap.get(field3);
                        if (ObjectUtils.isEmpty((Object)rangeAddressMerge.getFirstValue())) {
                            CellRangeAddressMerge cellRangeAddressMerge = new CellRangeAddressMerge();
                            cellRangeAddressMerge.setFirstValue(fieldValue);
                            cellRangeAddressMerge.setFirstRow(index);
                            cellRangeAddressMerge.setFirstCol(i);
                            mergeVerticalFieldMap.put(field3, cellRangeAddressMerge);
                        } else if (rangeAddressMerge.getFirstValue().equals(fieldValue)) {
                            rangeAddressMerge.setLastRow(index);
                            rangeAddressMerge.setLastCol(i);
                            rangeAddressMerge.setLastValue(fieldValue);
                            mergeVerticalFieldMap.put(field3, rangeAddressMerge);
                            if (index == size) {
                                region = new CellRangeAddress(rangeAddressMerge.getFirstRow(), rangeAddressMerge.getLastRow(), rangeAddressMerge.getFirstCol(), rangeAddressMerge.getLastCol());
                                sheet.addMergedRegionUnsafe(region);
                            }
                        } else if (!ObjectUtils.isEmpty((Object)rangeAddressMerge.getLastValue()) && !rangeAddressMerge.getLastValue().equals(fieldValue)) {
                            region = new CellRangeAddress(rangeAddressMerge.getFirstRow(), rangeAddressMerge.getLastRow(), rangeAddressMerge.getFirstCol(), rangeAddressMerge.getLastCol());
                            sheet.addMergedRegionUnsafe(region);
                        }
                    }
                    if (mergeLevelFieldMap.containsKey(field3)) {
                        // empty if block
                    }
                    HSSFCell hssfCell = row.createCell(i);
                    if (easyExcel.isUseAnnotation() && null != (filedAnnotation = field3.getAnnotation(easyExcel.getFieldColumnAnnotation()))) {
                        CellStyle tempStyle;
                        Class<? extends Style> styleClass = easyExcel.getStyle();
                        Style newInstance = styleClass.newInstance();
                        if (columnStyleList.size() != excelFiledPointList.size()) {
                            tempStyle = newInstance.columnStyle(new StyleParam((Workbook)workbook, (Sheet)sheet, filedAnnotation, i));
                            columnStyleList.add(tempStyle);
                        } else {
                            tempStyle = (CellStyle)columnStyleList.get(i);
                        }
                        hssfCell.setCellStyle(tempStyle);
                    }
                    ExcelExcelService.setRowColumnContent(hssfCell, fieldValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] exportExcelMultipleSheet(EasyExcelPoint easyExcel, List<String> titlist, List<List> dataSet) {
        if (titlist.size() == 0 || !dataSet.iterator().hasNext()) {
            throw new RuntimeException("\u4f20\u5165\u7684\u6570\u636e\u4e0d\u5bf9\uff01");
        }
        byte[] bytes = new byte[]{};
        for (int o = 0; o < dataSet.size(); ++o) {
            NormalExcelExportService.exportExcel(easyExcel, dataSet.get(0));
        }
        return bytes;
    }
}

