/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.easy.excel.toolkit;

import com.wu.framework.easy.excel.endpoint.EasyExcelPoint;
import java.util.ArrayDeque;
import java.util.Deque;

public final class DynamicEasyExcelPointContextHolder {
    private static final ThreadLocal<Deque<EasyExcelPoint>> EXCEL_POINT = ThreadLocal.withInitial(ArrayDeque::new);

    public static EasyExcelPoint peek() {
        return EXCEL_POINT.get().peek();
    }

    public static void push(EasyExcelPoint easyExcelPoint) {
        EXCEL_POINT.get().push(easyExcelPoint);
    }

    public static void poll() {
        Deque<EasyExcelPoint> deque = EXCEL_POINT.get();
        deque.poll();
        if (deque.isEmpty()) {
            EXCEL_POINT.remove();
        }
    }

    public static void clear() {
        EXCEL_POINT.remove();
    }
}

