/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.easy.excel.util;

import java.util.ArrayList;
import java.util.Collections;

public class ArabicNumeralsToChineseNumerals {
    public static int UNIT_STEP = 4;
    public static String[] CN_UNITS = new String[]{"\u4e2a", "\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767e", "\u5343", "\u4ebf", "\u5341", "\u767e", "\u5343", "\u4e07"};
    public static String[] CN_CHARS = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};

    public static String cvt(long num) {
        return ArabicNumeralsToChineseNumerals.cvt(num, false);
    }

    public static String cvt(String prefix, String suffix, long num, boolean isColloquial) {
        String[] result = ArabicNumeralsToChineseNumerals.convert(num, isColloquial);
        StringBuffer strs = new StringBuffer(32);
        strs.append(prefix);
        for (String str : result) {
            strs.append(str);
        }
        strs.append(suffix);
        return strs.toString();
    }

    public static String cvt(long num, boolean isColloquial) {
        String[] result = ArabicNumeralsToChineseNumerals.convert(num, isColloquial);
        StringBuffer strs = new StringBuffer(32);
        for (String str : result) {
            strs.append(str);
        }
        return strs.toString();
    }

    public static String[] convert(long num, boolean isColloquial) {
        if (num < 10L) {
            return new String[]{CN_CHARS[(int)num]};
        }
        char[] chars = String.valueOf(num).toCharArray();
        if (chars.length > CN_UNITS.length) {
            return new String[0];
        }
        boolean isLastUnitStep = false;
        ArrayList<String> cnchars = new ArrayList<String>(chars.length * 2);
        for (int pos = chars.length - 1; pos >= 0; --pos) {
            boolean isUnitStep;
            char ch = chars[pos];
            String cnChar = CN_CHARS[ch - 48];
            int unitPos = chars.length - pos - 1;
            String cnUnit = CN_UNITS[unitPos];
            boolean isZero = ch == '0';
            boolean isZeroLow = pos + 1 < chars.length && chars[pos + 1] == '0';
            boolean bl = isUnitStep = unitPos >= UNIT_STEP && unitPos % UNIT_STEP == 0;
            if (isUnitStep && isLastUnitStep) {
                int size = cnchars.size();
                cnchars.remove(size - 1);
                if (!CN_CHARS[0].equals(cnchars.get(size - 2))) {
                    cnchars.add(CN_CHARS[0]);
                }
            }
            if (isUnitStep || !isZero) {
                cnchars.add(cnUnit);
                isLastUnitStep = isUnitStep;
            }
            if (isZero && (isZeroLow || isUnitStep)) continue;
            cnchars.add(cnChar);
            isLastUnitStep = false;
        }
        Collections.reverse(cnchars);
        int chSize = cnchars.size();
        String chEnd = (String)cnchars.get(chSize - 1);
        if (CN_CHARS[0].equals(chEnd) || CN_UNITS[0].equals(chEnd)) {
            cnchars.remove(chSize - 1);
        }
        if (isColloquial) {
            String chFirst = (String)cnchars.get(0);
            String chSecond = (String)cnchars.get(1);
            if (chFirst.equals(CN_CHARS[1]) && chSecond.startsWith(CN_UNITS[1])) {
                cnchars.remove(0);
            }
        }
        return cnchars.toArray(new String[0]);
    }
}

