/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.easy.excel.web;

import com.wu.framework.easy.excel.endpoint.EasyFilePoint;
import com.wu.framework.easy.excel.endpoint.convert.EasyFilePointConvert;
import com.wu.framework.easy.excel.stereotype.EasyFile;
import com.wu.framework.easy.excel.toolkit.DynamicEasyFileContextHolder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AnnotatedElement;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class EasyFileResponseHandler
implements ResponseBodyAdvice<Object> {
    protected EasyFilePointConvert filePointConvert = new EasyFilePointConvert();

    public static byte[] concat(byte[] first, byte[] second) {
        byte[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> aClass) {
        return AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)methodParameter.getMethod(), EasyFile.class) != null || AnnotatedElementUtils.getMergedAnnotation(methodParameter.getMethod().getDeclaringClass(), EasyFile.class) != null;
    }

    public Object beforeBodyWrite(Object o, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        EasyFile easyExcel = (EasyFile)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)Objects.requireNonNull(methodParameter.getMethod()), EasyFile.class);
        EasyFilePoint easyFilePoint = this.filePointConvert.converter(easyExcel);
        EasyFilePoint peek = DynamicEasyFileContextHolder.peek();
        easyFilePoint = peek == null ? easyFilePoint : peek;
        String fileName = easyFilePoint.getFileName();
        String suffix = easyFilePoint.getSuffix();
        EasyFile.FileType fileType = easyFilePoint.getFileType();
        InputStream inputStream = null;
        if (EasyFile.FileType.STRING_TYPE.equals((Object)fileType)) {
            if (o.getClass().isAssignableFrom(Collection.class)) {
                bytes = new byte[]{};
                for (Object item : (Collection)o) {
                    byte[] itemBytes = item.toString().getBytes(StandardCharsets.UTF_8);
                    bytes = EasyFileResponseHandler.concat(bytes, itemBytes);
                }
                inputStream = new ByteArrayInputStream(bytes);
            } else {
                bytes = ((String)o).getBytes(StandardCharsets.UTF_8);
                inputStream = new ByteArrayInputStream(bytes);
            }
        } else if (EasyFile.FileType.FILE_TYPE.equals((Object)fileType)) {
            if (o.getClass().isAssignableFrom(File.class)) {
                File file = (File)o;
                if (ObjectUtils.isEmpty((Object)fileName)) {
                    fileName = file.getName();
                }
                try {
                    inputStream = new BufferedInputStream(new FileInputStream(file));
                }
                catch (Exception ex) {
                    throw new RuntimeException("transform file into bin Array \u51fa\u9519", ex);
                }
            }
        } else if (EasyFile.FileType.BYTE_TYPE.equals((Object)fileType)) {
            try {
                inputStream = new ByteArrayInputStream((byte[])o);
            }
            catch (Exception ex) {
                throw new RuntimeException("transform file into bin Array \u51fa\u9519", ex);
            }
        }
        DynamicEasyFileContextHolder.clear();
        HttpHeaders headers = serverHttpResponse.getHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        String encodedFileName = null;
        try {
            encodedFileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s.%s\"; filename*=utf-8''%s.%s", encodedFileName, suffix, encodedFileName, suffix));
        headers.add("File-Name", encodedFileName + "." + suffix);
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");
        headers.add("Content-Type", "application/octet-stream");
        try {
            BufferedOutputStream outputStream = new BufferedOutputStream(serverHttpResponse.getBody());
            byte[] buffer = new byte[1024];
            int i = -1;
            while ((i = inputStream.read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, i);
            }
            inputStream.close();
            ((OutputStream)outputStream).flush();
            ((OutputStream)outputStream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return o;
    }
}

