/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.easy.excel.web;

import com.wu.framework.easy.excel.adapter.ExcelExcelServiceAdapter;
import com.wu.framework.easy.excel.endpoint.EasyExcelPoint;
import com.wu.framework.easy.excel.endpoint.convert.EasyExcelPointConvert;
import com.wu.framework.easy.excel.stereotype.EasyExcel;
import com.wu.framework.easy.excel.toolkit.DynamicEasyExcelContextHolder;
import com.wu.framework.easy.excel.toolkit.DynamicEasyExcelPointContextHolder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AnnotatedElement;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class ExcelResponseHandler
implements ResponseBodyAdvice<Object> {
    private final ExcelExcelServiceAdapter excelExcelServiceAdapter;
    protected EasyExcelPointConvert excelPointConvert = new EasyExcelPointConvert();

    public ExcelResponseHandler(ExcelExcelServiceAdapter excelExcelServiceAdapter) {
        this.excelExcelServiceAdapter = excelExcelServiceAdapter;
    }

    public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> aClass) {
        return AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)methodParameter.getMethod(), EasyExcel.class) != null || AnnotatedElementUtils.getMergedAnnotation(methodParameter.getMethod().getDeclaringClass(), EasyExcel.class) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object beforeBodyWrite(Object o, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        EasyExcel easyExcel = (EasyExcel)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)Objects.requireNonNull(methodParameter.getMethod()), EasyExcel.class);
        EasyExcelPoint easyExcelPoint = this.excelPointConvert.converter(easyExcel);
        EasyExcelPoint peek = DynamicEasyExcelPointContextHolder.peek();
        easyExcelPoint = ObjectUtils.isEmpty((Object)peek) ? easyExcelPoint : peek;
        String fileName = easyExcelPoint.getFileName();
        String suffix = easyExcelPoint.getSuffix();
        DynamicEasyExcelPointContextHolder.clear();
        List<Object> collection = o instanceof Collection ? (List<Object>)o : Arrays.asList(o);
        HttpHeaders headers = serverHttpResponse.getHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        String encodedFileName = null;
        try {
            encodedFileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s.%s\"; filename*=utf-8''%s.%s", encodedFileName, suffix, encodedFileName, suffix));
        headers.add("File-Name", encodedFileName + "." + suffix);
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");
        headers.add("Content-Type", "application/octet-stream");
        byte[] bytes = this.excelExcelServiceAdapter.exportExcel(collection, easyExcelPoint);
        try {
            OutputStream body = serverHttpResponse.getBody();
            body.write(bytes);
            body.flush();
            body.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            DynamicEasyExcelContextHolder.clearALL();
        }
        return o;
    }
}

