/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.cache;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.springframework.lang.NonNull;
import top.xiajibagao.crane.core.cache.ConfigurationCache;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public class CacheConfigurationParserWrapper
implements OperateConfigurationParser {
    private final ConfigurationCache configurationCache;
    private final OperateConfigurationParser configurationParser;

    protected String getNamespace() {
        return this.configurationParser.getClass().getName();
    }

    @Override
    @Nonnull
    public OperationConfiguration parse(@NonNull Class<?> targetClass) {
        Objects.requireNonNull(targetClass);
        return this.configurationCache.getOrCached(this.getNamespace(), targetClass, this.configurationParser::parse);
    }

    public CacheConfigurationParserWrapper(ConfigurationCache configurationCache, OperateConfigurationParser configurationParser) {
        this.configurationCache = configurationCache;
        this.configurationParser = configurationParser;
    }
}

