/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.cache;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import top.xiajibagao.crane.core.cache.ConfigurationCache;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public class OperationConfigurationCache
implements ConfigurationCache {
    private final ConcurrentMap<String, ConcurrentMap<Class<?>, OperationConfiguration>> configurationCache = new ConcurrentHashMap(4);

    @Override
    public void setConfigurationCache(String cacheName, Class<?> targetType, OperationConfiguration configuration) {
        ConcurrentMap cacheMap = this.configurationCache.computeIfAbsent(cacheName, ns -> new ConcurrentHashMap(32));
        cacheMap.put(targetType, configuration);
    }

    @Override
    public OperationConfiguration getCachedConfiguration(String cacheName, Class<?> targetType) {
        return Optional.ofNullable(this.configurationCache.get(cacheName)).map(cache -> (OperationConfiguration)cache.get(targetType)).orElse(null);
    }

    @Override
    public OperationConfiguration getOrCached(String cacheName, Class<?> targetType, Function<Class<?>, OperationConfiguration> configurationFactory) {
        ConcurrentMap cacheMap = this.configurationCache.computeIfAbsent(cacheName, ns -> new ConcurrentHashMap(32));
        return cacheMap.computeIfAbsent(targetType, configurationFactory);
    }
}

