/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.container;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.util.CollectionUtils;
import top.xiajibagao.crane.core.container.BaseNamespaceContainer;
import top.xiajibagao.crane.core.container.Container;
import top.xiajibagao.crane.core.helper.ObjectUtils;

public class KeyValueContainer
extends BaseNamespaceContainer<String, Object>
implements Container {
    public final Table<String, String, Object> cache = HashBasedTable.create();

    public void unregister(String namespace, Object key) {
        this.cache.remove((Object)namespace, key);
    }

    public void unregister(String namespace) {
        this.cache.rowMap().remove(namespace);
    }

    public void register(String namespace, Map<?, ?> values) {
        if (CollectionUtils.isEmpty(values)) {
            return;
        }
        values.forEach((k, v) -> ObjectUtils.acceptIfNotNull(this.parseKey(k), keyStr -> this.cache.put((Object)namespace, keyStr, v)));
    }

    public <T> T get(String namespace, String key) {
        return (T)this.cache.get((Object)namespace, (Object)key);
    }

    @Override
    @Nonnull
    protected Map<String, Map<String, Object>> getSources(@Nonnull Multimap<String, String> namespaceAndKeys) {
        return this.cache.rowMap();
    }

    @Override
    protected String parseKey(@Nullable Object key) {
        return Objects.toString(key);
    }
}

