/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class PairEntry<K, V>
implements Map.Entry<K, V> {
    private K key;
    private V value;
    private final PairEntry<K, V> self;

    public PairEntry(K key, V value) {
        this.key = key;
        this.value = value;
        this.self = this;
    }

    @Override
    public V setValue(V value) {
        V old = this.value;
        this.value = value;
        return old;
    }

    public boolean nonKey() {
        return Objects.isNull(this.key);
    }

    public boolean hasKey() {
        return !this.nonKey();
    }

    public boolean nonValue() {
        return Objects.isNull(this.value);
    }

    public boolean hasValue() {
        return !this.nonValue();
    }

    public <N> PairEntry<K, N> mapValue(Function<V, N> valueMapper) {
        return new PairEntry<K, N>(this.key, valueMapper.apply(this.value));
    }

    public <N> PairEntry<N, V> mapKey(Function<K, N> keyMapper) {
        return new PairEntry<N, V>(keyMapper.apply(this.key), this.value);
    }

    public void peekValue(Consumer<V> consumer) {
        consumer.accept(this.value);
    }

    public void peekKey(Consumer<K> consumer) {
        consumer.accept(this.key);
    }

    public static <K, V> PairEntry<K, V> of(K key, V val) {
        return new PairEntry<K, V>(key, val);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    public PairEntry<K, V> getSelf() {
        return this.self;
    }

    public void setKey(K key) {
        this.key = key;
    }
}

