/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.parser;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import top.xiajibagao.crane.core.annotation.Assemble;
import top.xiajibagao.crane.core.annotation.Disassemble;
import top.xiajibagao.crane.core.annotation.Operations;
import top.xiajibagao.crane.core.helper.BeanFactoryUtils;
import top.xiajibagao.crane.core.helper.CollUtils;
import top.xiajibagao.crane.core.helper.Orderly;
import top.xiajibagao.crane.core.helper.reflex.ReflexUtils;
import top.xiajibagao.crane.core.parser.AbstractAnnotationConfigurationParser;
import top.xiajibagao.crane.core.parser.BeanOperationConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.DisassembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.GlobalConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public class ClassAnnotationConfigurationParser
extends AbstractAnnotationConfigurationParser
implements OperateConfigurationParser {
    private static final Logger log = LoggerFactory.getLogger(ClassAnnotationConfigurationParser.class);

    public ClassAnnotationConfigurationParser(GlobalConfiguration globalConfiguration, BeanFactory beanFactory) {
        super(globalConfiguration, beanFactory);
    }

    @Override
    @Nonnull
    protected BeanOperationConfiguration parse(Class<?> targetClass, AbstractAnnotationConfigurationParser.ParseContext parseContext) {
        BeanOperationConfiguration configuration = this.createConfiguration(targetClass);
        parseContext.looking(targetClass, configuration);
        if (parseContext.isExcluded(targetClass)) {
            return configuration;
        }
        ArrayList<AssembleOperation> assembleOperations = new ArrayList<AssembleOperation>();
        ArrayList<DisassembleOperation> disassembleOperations = new ArrayList<DisassembleOperation>();
        Operations annotation = (Operations)AnnotatedElementUtils.findMergedAnnotation(targetClass, Operations.class);
        if (Objects.isNull(annotation)) {
            return configuration;
        }
        if (annotation.enableExtend()) {
            ReflexUtils.forEachClass(targetClass, Predicates.not(parseContext::isExcluded), t -> this.parseAnnotation(parseContext, (Class<?>)t, configuration, (List<AssembleOperation>)assembleOperations, (List<DisassembleOperation>)disassembleOperations));
        } else {
            this.parseAnnotation(parseContext, configuration.getTargetClass(), configuration, assembleOperations, disassembleOperations);
        }
        configuration.getAssembleOperations().addAll(CollUtil.sort(assembleOperations, Orderly::compareTo));
        configuration.getDisassembleOperations().addAll(CollUtil.sort(disassembleOperations, Orderly::compareTo));
        return configuration;
    }

    private void parseAnnotation(AbstractAnnotationConfigurationParser.ParseContext parseContext, Class<?> targetClass, BeanOperationConfiguration configuration, List<AssembleOperation> assembleOperations, List<DisassembleOperation> disassembleOperations) {
        Operations annotation = (Operations)AnnotatedElementUtils.findMergedAnnotation(targetClass, Operations.class);
        if (Objects.isNull(annotation)) {
            return;
        }
        assembleOperations.addAll(this.parseAssembleAnnotations(configuration, annotation));
        disassembleOperations.addAll(this.parseDisassembleAnnotations(configuration, annotation, parseContext));
        parseContext.exclude(annotation.extendExcludes());
    }

    @Nonnull
    protected BeanOperationConfiguration createConfiguration(Class<?> targetClass) {
        return new BeanOperationConfiguration(this.globalConfiguration, targetClass, new ArrayList<AssembleOperation>(), new ArrayList<DisassembleOperation>());
    }

    protected List<AssembleOperation> parseAssembleAnnotations(OperationConfiguration configuration, Operations operations) {
        ArrayListMultimap assembleKeys = ArrayListMultimap.create();
        for (Assemble annotation : operations.assembles()) {
            assembleKeys.put((Object)annotation.key(), (Object)annotation);
        }
        ArrayList<AssembleOperation> results = new ArrayList<AssembleOperation>();
        Class<?> targetClass = configuration.getTargetClass();
        assembleKeys.asMap().forEach((keyName, annotations) -> {
            Field key = ReflexUtils.findField(targetClass, keyName, false);
            boolean keyExists = Objects.nonNull(key);
            annotations.stream().peek(a -> Assert.isTrue((keyExists || ArrayUtil.isNotEmpty((Object[])a.aliases()) ? 1 : 0) != 0, (String)"\u7c7b[{}]\u4e0d\u5b58\u5728key[{}], \u4e14\u672a\u6307\u5b9a\u4efb\u4f55\u522b\u540d", (Object[])new Object[]{targetClass, keyName})).map(a -> this.createAssembleOperation(keyExists ? key : ReflexUtils.findAnyMatchField(targetClass, true, a.aliases()), (Assemble)a, configuration)).forEach(results::add);
        });
        return results;
    }

    protected List<DisassembleOperation> parseDisassembleAnnotations(OperationConfiguration configuration, Operations operations, AbstractAnnotationConfigurationParser.ParseContext parseContext) {
        Map disassembleKeys = CollUtils.toList(operations.disassembles()).stream().collect(Collectors.toMap(Disassemble::key, Function.identity(), (k1, k2) -> k1));
        ArrayList<DisassembleOperation> results = new ArrayList<DisassembleOperation>();
        disassembleKeys.forEach((keyName, annotation) -> {
            Field key = ReflexUtils.findAnyMatchField(configuration.getTargetClass(), true, (String[])ArrayUtil.insert((Object[])annotation.aliases(), (int)0, (Object[])new String[]{annotation.key()}));
            Class<?> disassembleType = annotation.targetClass();
            OperationConfiguration disassembleConfiguration = parseContext.isInLooking(disassembleType) ? parseContext.get(disassembleType) : (annotation.useCurrParser() ? this.parse((Class)disassembleType, parseContext) : BeanFactoryUtils.getBean(this.beanFactory, annotation.parser(), annotation.parserName()).parse(disassembleType));
            DisassembleOperation disassembleOperation = this.createDisassembleOperation(key, (Disassemble)annotation, configuration, disassembleConfiguration);
            results.add(disassembleOperation);
        });
        return results;
    }
}

