package top.xtcoder.clove.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtil {
	public static String readToStr(String path) {
		File file = new File(path);
		return readToStr(file, "UTF-8");
	}
	
	public static String readToStr(String path, String charset) {
		File file = new File(path);
		return readToStr(file, charset);
	}
	
	public static String readToStr(File file) {
		return readToStr(file, "UTF-8");
	}
	
	public static String readToStr(File file, String charset) {
		BufferedReader br = null;
		StringBuilder sb = new StringBuilder();
		try {
			br = new BufferedReader(new InputStreamReader(new FileInputStream(file), charset));
			String line = null;
			while (null != (line=br.readLine())) {
				sb.append(line);
			}
		}catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (null != br) {
				try {
					br.close();
				}catch(Exception e) {
					e.printStackTrace();
				}
			}
		}
		return sb.toString();
	}
	
	/**
     * 获取文件路径中的文件后缀
     * 比如：path=/usr/local/test.txt, 则返回txt
     * @param path
     * @return
     */
    public static String getFileSuffix(String path) {
        String name = getFileName(path);
        int index = name.lastIndexOf(".");
        if(index == -1) {
            return "";
        }
        return name.substring(name.lastIndexOf('.') + 1);
    }

    /**
     * 获取文件的文件后缀
     * 比如：path=/usr/local/test.txt, 则返回txt
     * @param file
     * @return
     */
    public static String getFileSuffix(File file) {
        return getFileSuffix(file.getAbsolutePath());
    }

    /**
     * 获取文件路径中的文件简称，去除后缀的
     * 比如：path=/usr/local/test.txt, 则返回test
     * @param path
     * @return
     */
    public static String getSimpleName(String path) {
        String name = getFileName(path);
        int index = name.lastIndexOf('.');
        if(index == -1) {
            return name;
        }
        return name.substring(0, name.lastIndexOf('.'));
    }

    /**
     * 获取文件文件简称，去除后缀的
     * 比如：path=/usr/local/test.txt, 则返回test
     * @param file
     * @return
     */
    public static String getSimpleName(File file) {
        return getSimpleName(file.getAbsolutePath());
    }

    /**
     * 获取文件路径中的文件名字
     * 比如：path=/usr/local/test.txt, 则返回test.txt
     * @param file
     * @return
     */
    public static String getFileName(File file) {
        return getFileName(file.getAbsoluteFile());
    }

    /**
     * 获取文件的文件名字
     * 比如：path=/usr/local/test.txt, 则返回test.txt
     * @param path
     * @return
     */
    public static String getFileName(String path) {
        int index = path.lastIndexOf('/');
        if(index == -1) {
            return path;
        }
        if(index + 1 >= path.length()) {
            return path;
        }
        String name = path.substring(index + 1);
        return name;
    }

    public static long calcDirectorySize(File directory) {
        if(!directory.isDirectory()) {
            return -1;
        }
        long size = 0;
        File[] files = directory.listFiles();
        for(File f : files) {
            if(f.isDirectory()) {
                size += calcDirectorySize(f);
            }else {
                size += f.length();
            }
        }
        return size;
    }
}
