package top.xtcoder.clove.common.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import top.xtcoder.clove.common.exception.NewTObjectException;

public class ObjUtil {

    /**
     * 设置target中的field名字字段为src中的名字字段 <br>
     *     如果在当前类找不到，则往继承的类中找，一直找到为止
     *  比如 src{name: 'xiangtao'}, field为name字段, target有一个name字段，则将target中的name字段设置为'xiangtao'
     * @param src 源对象
     * @param field 源对象中的字段
     * @param target 目标对象
     * @param <ClassSrc>
     * @param <ClassTar>
     */
    public static <ClassSrc, ClassTar> void setTargetValue(ClassSrc src, Field field, ClassTar target) {
        field.setAccessible(true);
        try {
            Field targetField = getField(target.getClass(), field.getName());
            targetField.setAccessible(true);
            targetField.set(target, field.get(src));
        }catch(Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * 从clz中获取name的Field
     * @param clz
     * @param name
     * @param <T>
     * @return
     */
    public static <T> Field getField(Class<T> clz, String name) {
        List<Field> srcFields = getFields(clz);
        for(Field f : srcFields) {
            if(f.getName().equals(name)) {
                return f;
            }
        }
        return null;
    }

    /**
     * 获取对象obj中的所有字段，包括从父类继承下来的
     * @param clzT
     * @param <T>
     * @return
     */
    public static <T> List<Field> getFields(Class<T> clzT) {
        List<Field> srcFields = new ArrayList<>();

        Class clz = clzT;
        do {
            Field[] fs = clz.getDeclaredFields();
            if(fs != null && fs.length > 0) {
                srcFields.addAll(ArrayUtil.asList(fs));
            }
            clz = clz.getSuperclass();
        }while (clz != null);

        return srcFields;
    }

    public static <T> T newT(Class<T> clz) throws NewTObjectException {
        try {
            T t = clz.newInstance();
            return t;
        }catch (InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
            NewTObjectException ex = new NewTObjectException(e.getMessage());
            throw ex;
        }
    }

    /**
     * 从一个对象复制得到另外一个对象
     * @param src 源对象
     * @param clzTar 目标对象class
     * @param <ClassSrc>
     * @param <ClassTar>
     * @return
     */
    public static <ClassSrc, ClassTar> ClassTar copyField(ClassSrc src, Class<ClassTar> clzTar) {
        if(src == null) {
            return null;
        }
        ClassTar target = newT(clzTar);

        List<Field> srcFields = getFields(src.getClass());
        if(srcFields.size() <= 0) {
            return target;
        }

        for(int i = 0; i < srcFields.size(); i ++) {
            Field field = srcFields.get(i);
            if(StrUtil.notIn(field.getName(), "shadow$_klass_", "shadow$_monitor_")) {
                setTargetValue(src, field, target);
            }
        }

        return target;
    }

    /**
     * 从一个List复制得到另外一个类型的List
     * @param srcs 需要复制的源list
     * @param clzTar 目标泛型
     * @param <ClassSrc>
     * @param <ClassTar>
     * @return List<ClassTar>
     */
    public static  <ClassSrc, ClassTar> List<ClassTar> copyListField(List<ClassSrc> srcs, Class<ClassTar> clzTar) {
        if(srcs == null || srcs.size() <= 0) {
            return null;
        }
        List<ClassTar> targets = new ArrayList<ClassTar>();
        for(Object src : srcs) {
            try {
                ClassTar target = copyField(src, clzTar);
                targets.add(target);
            }catch(Exception e) {
                e.printStackTrace();
            }
        }

        return targets;
    }

    /**
     * 如果对象obj为空，则new一个空对象
     * @param obj
     * @param <T>
     */
    public static <T> T ifNullNew(T obj, Class<T> clz) {
        if(obj == null) {
            obj = newT(clz);
        }
        return obj;
    }
}
