/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.base.common;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.convert.NumberChineseFormatter;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.json.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.annotation.Column;
import org.nutz.dao.entity.annotation.Table;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlCallback;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.util.NutMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import top.xtcoder.jdcbase.base.anno.FunsSqlIngore;
import top.xtcoder.jdcbase.base.common.PrimaryKeyCreater;
import top.xtcoder.jdcbase.base.config.FileUploadConf;
import top.xtcoder.jdcbase.base.core.Resp;
import top.xtcoder.jdcbase.base.entity.BaseEntity;

public class Funs {
    private static final Logger log = LoggerFactory.getLogger(Funs.class);
    public static final double EARTH_RADIUS = 6378.137;

    public static void main(String[] args) {
        System.out.println(Funs.int2chineseNum(14));
    }

    public static String dateAddDate(String d, int data) throws ParseException {
        Date date = DateUtil.parse((CharSequence)d).toJdkDate();
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, data);
        LocalDateTime ldt = LocalDateTimeUtil.of((Date)c.getTime());
        return ldt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public static String getSaLoginId(int type, String userid) {
        return type + "-" + userid;
    }

    public static String getLoginId() {
        Object[] ids = StpUtil.getLoginIdAsString().split("-");
        log.info("getLoginId=" + Arrays.toString(ids));
        if (ids != null && ids.length >= 2) {
            return ids[1];
        }
        return "";
    }

    public static int getLoginType() {
        Object[] ids = StpUtil.getLoginIdAsString().split("-");
        log.info("getLoginType=" + Arrays.toString(ids));
        if (ids != null && ids.length >= 1) {
            return Integer.parseInt((String)ids[0]);
        }
        return -1;
    }

    public static String fmDecimal(BigDecimal decimal) {
        System.out.println(decimal);
        BigDecimal setScale = decimal.setScale(2, 1);
        return setScale.toString();
    }

    public static Map<String, String> uploadFileInit(FileUploadConf fileUploadConf, String fileSuffix) throws Exception {
        String dir = fileUploadConf.getSavePath();
        String ymd = Funs.getNowLocalDate();
        File fileBaseDir = new File(dir);
        if (!fileBaseDir.canWrite()) {
            throw new Exception("\u4e0a\u4f20\u76ee\u5f55\u6ca1\u6709\u5199\u6743\u9650\u3002");
        }
        File fileDir = new File(dir + File.separator + ymd);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
            File f = new File(dir + File.separator + ymd + File.separator + "index.html");
            f.createNewFile();
        }
        String fileName = Funs.getFileNameBySm3() + fileSuffix;
        String saveFilePath = fileDir + File.separator + fileName;
        String url = fileUploadConf.getBaseUrl() + "/" + ymd + "/" + fileName;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("saveFilePath", saveFilePath);
        map.put("url", url);
        return map;
    }

    public static String int2chineseNum(int src) {
        String s = NumberChineseFormatter.format((double)src, (boolean)false);
        if (src >= 10 && src <= 19) {
            s = s.substring(1);
        }
        return s;
    }

    public static Integer executeDDL(Dao dao, String sqlStr) {
        Sql sql = Sqls.create((String)sqlStr);
        sql.setCallback(new SqlCallback(){

            public Integer invoke(Connection conn, ResultSet rs, Sql sql) throws SQLException {
                return 1;
            }
        });
        dao.execute(sql);
        return sql.getInt();
    }

    public static Date getNextBZ(Date d) throws ParseException {
        int t = d.getMinutes();
        if (t < 30) {
            d.setMinutes(30);
        } else {
            d.setHours(d.getHours() + 1);
            d.setMinutes(0);
        }
        return d;
    }

    public static List<Date> getSETimeBZ(Date s, Date e) throws ParseException {
        LinkedList<Date> dates = new LinkedList<Date>();
        if (s.getTime() >= e.getTime()) {
            return dates;
        }
        if (s.getMinutes() == 30 || s.getMinutes() == 0) {
            dates.add((Date)s.clone());
        }
        while (s.getTime() <= e.getTime()) {
            if ((s = Funs.getNextBZ(s)).getTime() > e.getTime()) continue;
            dates.add((Date)s.clone());
        }
        return dates;
    }

    public static Date dateAddSecond(Date d, int s) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.add(13, s);
        return c.getTime();
    }

    public static Date dateAddSecond(Date d, long s) {
        return Funs.dateAddSecond(d, (int)s);
    }

    public static String surplusTimerCalc(long allSeconds) {
        long min = allSeconds / 60L;
        long seconds = allSeconds % 60L;
        long hource = min / 60L;
        min %= 60L;
        StringBuffer sb = new StringBuffer();
        if (hource > 0L) {
            sb.append(hource + "\u5c0f\u65f6");
        }
        if (min > 0L) {
            sb.append(min + "\u5206\u949f");
        }
        sb.append(seconds + "\u79d2");
        return sb.toString();
    }

    public static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static boolean checkPhone(String phone) {
        String CM_NUM = "^1(3[0-9]|4[57]|5[0-9]|66|7[135678]|8[0-9]|9[89])[0-9]{8}$";
        Pattern P_CM_NUM = Pattern.compile(CM_NUM);
        Matcher M_CM_NUM = P_CM_NUM.matcher(phone);
        return M_CM_NUM.matches();
    }

    public static String sm3(String str) {
        str = str == null ? "" : str;
        byte[] pmdata = Funs.string2byte(str);
        SM3Digest sm3 = new SM3Digest();
        sm3.update(pmdata, 0, pmdata.length);
        byte[] hash = new byte[sm3.getDigestSize()];
        sm3.doFinal(hash, 0);
        String rsSM3 = ByteUtils.toHexString((byte[])hash);
        return rsSM3;
    }

    public static String sm3_hmac(String key, String str) {
        key = key == null ? "" : key;
        str = str == null ? "" : str;
        KeyParameter kp = new KeyParameter(Funs.string2byte(key));
        byte[] pmdata = Funs.string2byte(str);
        SM3Digest sm3 = new SM3Digest();
        HMac hmac = new HMac((Digest)sm3);
        hmac.init((CipherParameters)kp);
        hmac.update(pmdata, 0, pmdata.length);
        byte[] hash = new byte[hmac.getMacSize()];
        hmac.doFinal(hash, 0);
        String rsSM3 = ByteUtils.toHexString((byte[])hash);
        return rsSM3;
    }

    public static String sha3(String str) {
        if (str == null) {
            str = "";
        }
        byte[] pmdata = Funs.string2byte(str);
        SHA3Digest sha3 = new SHA3Digest();
        sha3.update(pmdata, 0, pmdata.length);
        byte[] hash = new byte[sha3.getDigestSize()];
        sha3.doFinal(hash, 0);
        String resultSha3 = ByteUtils.toHexString((byte[])hash);
        return resultSha3;
    }

    public static byte[] string2byte(String s) {
        byte[] pmdata = null;
        try {
            pmdata = s.getBytes("utf-8");
            return pmdata;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return pmdata;
        }
    }

    public static String pwdEncry(String sourcePwd, String salt) {
        return Funs.sm3_hmac(salt, sourcePwd);
    }

    public static String getRandom(int length) {
        Random random = new Random();
        StringBuilder rs = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            rs.append(random.nextInt(10));
        }
        return rs.toString();
    }

    public static String getId() {
        long millis = System.currentTimeMillis();
        Random random = new Random();
        int end2 = random.nextInt(99);
        String string = millis + String.format("%02d", end2);
        return string;
    }

    public static String filterEmoji(String source) {
        if (source == null) {
            return source;
        }
        Pattern emoji = Pattern.compile("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]", 66);
        Matcher emojiMatcher = emoji.matcher(source);
        if (emojiMatcher.find()) {
            source = emojiMatcher.replaceAll("*");
            return source;
        }
        return source;
    }

    public static String genId() {
        return Times.format((String)"yy", (Date)new Date()) + "0" + Funs.longuuid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeResp(HttpServletResponse response, Resp resp) {
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Type", "application/json");
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Max-Age", "3600");
        response.setStatus(200);
        response.setContentType("application/json;charset=UTF-8");
        try (PrintWriter writer = null;){
            writer = response.getWriter();
            writer.write(Json.toJson((Object)resp));
            writer.flush();
        }
    }

    public static String[] split(String s, String token) {
        if (s == null) {
            return null;
        }
        if (token == null || s.length() == 0) {
            return new String[]{s};
        }
        int size = 0;
        String[] result = new String[4];
        while (s.length() > 0) {
            int index = s.indexOf(token);
            String splitOne = s;
            if (index > -1) {
                splitOne = s.substring(0, index);
                s = s.substring(index + token.length());
            } else {
                s = "";
            }
            if (size >= result.length) {
                String[] tmp = new String[result.length * 2];
                System.arraycopy(result, 0, tmp, 0, result.length);
                result = tmp;
            }
            if (splitOne.length() <= 0) continue;
            result[size++] = splitOne;
        }
        String[] tmp = result;
        result = new String[size];
        System.arraycopy(tmp, 0, result, 0, size);
        return result;
    }

    public static String UUID() {
        String s = UUID.randomUUID().toString();
        return s.replaceAll("-", "");
    }

    public static String UUID36() {
        String s = UUID.randomUUID().toString();
        return s;
    }

    public static String createAccount() {
        String account = Times.format((String)"yy", (Date)new Date()) + "0" + Funs.longuuid();
        return account;
    }

    public static String now() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static String nowNumber() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
    }

    public static String getYMD() {
        return Times.format((String)"yyyy-MM-dd", (Date)new Date());
    }

    public static long longuuid() {
        return PrimaryKeyCreater.generateShortUuid();
    }

    public static long longuuid(String uuid) {
        return PrimaryKeyCreater.generateShortUuid(uuid);
    }

    public static String encodePassword(String password, String salt) {
        return Lang.md5((CharSequence)(Lang.md5((CharSequence)password) + salt));
    }

    public static Integer[] getLevelArr(String level) {
        String[] str = level.split("");
        Integer[] is = new Integer[str.length];
        for (int i = 0; i < str.length; ++i) {
            is[i] = Integer.parseInt(str[i]);
        }
        return is;
    }

    public static String gbEncoding(String gbString) {
        char[] utfBytes = gbString.toCharArray();
        String unicodeBytes = "";
        for (int i = 0; i < utfBytes.length; ++i) {
            String hexB = Integer.toHexString(utfBytes[i]);
            if (hexB.length() <= 2) {
                hexB = "00" + hexB;
            }
            unicodeBytes = unicodeBytes + "\\u" + hexB;
        }
        return unicodeBytes;
    }

    public static String decodeUnicode(String dataStr) {
        int start = 0;
        int end = 0;
        StringBuffer buffer = new StringBuffer();
        while (start > -1) {
            end = dataStr.indexOf("\\u", start + 2);
            String charStr = "";
            charStr = end == -1 ? dataStr.substring(start + 2, dataStr.length()) : dataStr.substring(start + 2, end);
            char letter = (char)Integer.parseInt(charStr, 16);
            buffer.append(new Character(letter).toString());
            start = end;
        }
        return buffer.toString();
    }

    public static final String getNowFullTimeNum() {
        LocalDateTime ldt = LocalDateTime.now();
        return ldt.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
    }

    public static final String getNowFullTimeByXAfter(int min) {
        if (min == 0) {
            min = 60;
        }
        long time = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String rzDate = df.format(time += (long)(min * 1000 * 60));
        return rzDate;
    }

    public static final String getNowFullTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String rzDate = df.format(new Date());
        return rzDate;
    }

    public static long dec2Value(BigDecimal bd1) {
        BigDecimal bd2 = bd1.multiply(new BigDecimal(100));
        long total_fee = bd2.longValue();
        return total_fee;
    }

    public static String delHTMLTag(String htmlStr) {
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String regEx_html = "<[^>]+>";
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        return htmlStr.replaceAll("\\s*|\t|\r|\n", "").trim();
    }

    public static List<String> getImgByHtml(String html) {
        ArrayList<String> srcList = new ArrayList<String>();
        Pattern p = Pattern.compile("<(img|IMG)(.*?)(>|></img>|/>)");
        Matcher matcher = p.matcher(html);
        boolean hasPic = matcher.find();
        if (hasPic) {
            while (hasPic) {
                String group = matcher.group(2);
                Pattern srcText = Pattern.compile("(src|SRC)=(\"|')(.*?)(\"|')");
                Matcher matcher2 = srcText.matcher(group);
                if (matcher2.find()) {
                    srcList.add(matcher2.group(3));
                }
                hasPic = matcher.find();
            }
        }
        return srcList;
    }

    public static String getPrintSize(long size) {
        if (size < 1024L) {
            return String.valueOf(size) + " B";
        }
        if ((size /= 1024L) < 1024L) {
            return String.valueOf(size) + " KB";
        }
        if ((size /= 1024L) < 1024L) {
            return String.valueOf((size *= 100L) / 100L) + "." + String.valueOf(size % 100L) + " MB";
        }
        size = size * 100L / 1024L;
        return String.valueOf(size / 100L) + "." + String.valueOf(size % 100L) + " GB";
    }

    public static String getText(String text, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static int string2int(String s) {
        if (s == null) {
            return 0;
        }
        if ("".equals(s = Funs.getText(s, "(\\d+)")) || s == null) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public static Long string2Long(String s) {
        if (s == null) {
            return 0L;
        }
        if ("".equals(s = Funs.getText(s, "(\\d+)")) || s == null) {
            return 0L;
        }
        return Long.parseLong(s);
    }

    public static Long obj2Long(Object obj) {
        if (obj == null) {
            return 0L;
        }
        String s = obj.toString();
        if ("".equals(s = Funs.getText(s, "(\\d+)")) || s == null) {
            return 0L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            System.out.println("error=" + e.getMessage());
            return 0L;
        }
    }

    public static int obj2int(Object obj) {
        if (obj == null) {
            return 0;
        }
        try {
            String s = obj.toString();
            s = Funs.getText(s, "(\\d+)");
            if ("".equals(s) || s == null) {
                return 0;
            }
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            System.out.println("error=");
            return 0;
        }
    }

    public static int obj2int(Object obj, int defaultVal) {
        if (obj == null) {
            return defaultVal;
        }
        try {
            String s = obj.toString();
            s = Funs.getText(s, "(\\d+)");
            if ("".equals(s) || s == null) {
                return defaultVal;
            }
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            System.out.println("error=");
            return defaultVal;
        }
    }

    public static final String getNowDate4yyyyMM() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
        String rzDate = df.format(new Date());
        return rzDate;
    }

    public static boolean isIPv4Address(String input) {
        Pattern IPv4Pattern = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
        return IPv4Pattern.matcher(input).matches();
    }

    public static boolean isIPv6StdAddress(String input) {
        Pattern IPv6StdPattern = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
        return IPv6StdPattern.matcher(input).matches();
    }

    public static boolean isIPv6HexCompressedAddress(String input) {
        Pattern IPV6HexCompressedPattrern = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
        return IPV6HexCompressedPattrern.matcher(input).matches();
    }

    public static boolean isIPv6Address(String input) {
        return Funs.isIPv6StdAddress(input) || Funs.isIPv6HexCompressedAddress(input);
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip;
        block13: {
            block12: {
                if (request == null) {
                    return "0.0.0.0";
                }
                ip = request.getHeader("X-Forwarded-For");
                if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip)) break block12;
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("Proxy-Client-IP");
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("WL-Proxy-Client-IP");
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("X-Real-IP");
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_CLIENT_IP");
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_X_FORWARDED_FOR");
                }
                if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip) || !(ip = request.getRemoteAddr()).equals("127.0.0.1") && !ip.equals("0:0:0:0:0:0:0:1")) break block13;
                InetAddress inet = null;
                try {
                    inet = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                ip = inet.getHostAddress();
                break block13;
            }
            if (ip.length() > 15) {
                String[] ips = ip.split(",");
                for (int index = 0; index < ips.length; ++index) {
                    String strIp = ips[index];
                    if ("unknown".equalsIgnoreCase(strIp)) continue;
                    ip = strIp;
                    break;
                }
            }
        }
        if (Strings.isBlank((CharSequence)ip)) {
            return "0.0.0.0";
        }
        if (Funs.isIPv4Address(ip) || Funs.isIPv6Address(ip)) {
            return ip;
        }
        return "0.0.0.0";
    }

    public static Map<String, Object> getIpInfo(String real_ip) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String api = "http://ip.taobao.com/service/getIpInfo.php";
        String connect_symbol = "?";
        String front_name = "ip=";
        StringBuffer sb = new StringBuffer();
        try {
            URL url = new URL(api + connect_symbol + front_name + real_ip);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            BufferedReader bf = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
            String line = "";
            while (null != (line = bf.readLine())) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject dataObject = new JSONObject((Object)sb.toString());
        JSONObject jsonObject = dataObject.getJSONObject((Object)"data");
        map.put("region", jsonObject.get((Object)"region"));
        map.put("city", jsonObject.get((Object)"city"));
        map.put("area", jsonObject.get((Object)"area"));
        return map;
    }

    public static final String getFileNameByFullTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String rzDate = df.format(new Date());
        return rzDate + "_" + new Random().nextInt(10000);
    }

    public static final String getFileContentType(String filePath) {
        try {
            Path path = new File(filePath).toPath();
            String contentType = Files.probeContentType(path);
            return contentType;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final String getFileType(String filePath) {
        try {
            Path path = new File(filePath).toPath();
            String contentType = Files.probeContentType(path);
            return contentType.split("/")[1];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final String getFileSuffix(String filePath) {
        return "." + Funs.getFileType(filePath);
    }

    public static final String getFileNameBySm3() {
        String fileName = Funs.sm3(new Date().getTime() + (long)new Random().nextInt(10000) + Funs.UUID());
        return fileName;
    }

    public static double similarity(ArrayList va, ArrayList vb) {
        int i;
        int temp;
        if (va.size() > vb.size()) {
            temp = va.size() - vb.size();
            for (i = 0; i < temp; ++i) {
                vb.add(0);
            }
        } else if (va.size() < vb.size()) {
            temp = vb.size() - va.size();
            for (i = 0; i < temp; ++i) {
                va.add(0);
            }
        }
        int size = va.size();
        double simVal = 0.0;
        double num = 0.0;
        double den = 1.0;
        double powa_sum = 0.0;
        double powb_sum = 0.0;
        for (int i2 = 0; i2 < size; ++i2) {
            double a = Double.parseDouble(va.get(i2).toString());
            double b = Double.parseDouble(vb.get(i2).toString());
            num += a * b;
            powa_sum += Math.pow(a, 2.0);
            powb_sum += Math.pow(b, 2.0);
        }
        double sqrta = Math.sqrt(powa_sum);
        double sqrtb = Math.sqrt(powb_sum);
        den = sqrta * sqrtb;
        simVal = num / den;
        return simVal;
    }

    public static final String getNowDate4yyyyMMDD() {
        LocalDate ld = LocalDate.now();
        return ld.format(DateTimeFormatter.BASIC_ISO_DATE);
    }

    public static boolean BigDecimalIsEmpty(BigDecimal bd) {
        if (bd == null) {
            return true;
        }
        return bd.compareTo(BigDecimal.ZERO) == 0;
    }

    public static boolean BigDecimalIsNotEmpty(BigDecimal bd) {
        return !Funs.BigDecimalIsEmpty(bd);
    }

    public static boolean setDownloadHeader(HttpServletRequest request, HttpServletResponse response, String fileName) {
        try {
            response.setContentType("application/octet-stream");
            response.setHeader("content-type", "application/octet-stream");
            String browser = request.getHeader("User-Agent");
            if (-1 < browser.indexOf("MSIE 6.0") || -1 < browser.indexOf("MSIE 7.0")) {
                response.addHeader("content-disposition", "attachment;filename=" + new String(fileName.getBytes(), "ISO8859-1"));
            } else if (-1 < browser.indexOf("MSIE 8.0")) {
                response.addHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            } else if (-1 < browser.indexOf("MSIE 9.0")) {
                response.addHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            } else if (-1 < browser.indexOf("Chrome")) {
                response.addHeader("content-disposition", "attachment;filename*=UTF-8''" + URLEncoder.encode(fileName, "UTF-8"));
            } else if (-1 < browser.indexOf("Safari")) {
                response.addHeader("content-disposition", "attachment;filename=" + new String(fileName.getBytes(), "ISO8859-1"));
            } else {
                response.addHeader("content-disposition", "attachment;filename*=UTF-8''" + URLEncoder.encode(fileName, "UTF-8"));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getJobState(int state) {
        String js = "";
        switch (state) {
            case 1: {
                js = "\u79bb\u804c";
                break;
            }
            case 2: {
                js = "\u5728\u804c\uff0c\u53ef\u4e00\u4e2a\u6708\u5230\u5c97";
                break;
            }
            case 3: {
                js = "\u5728\u804c\uff0c\u8003\u8651\u6362\u5de5\u4f5c";
                break;
            }
            case 4: {
                js = "\u5728\u804c\uff0c\u5e94\u5c4a\u6bd5\u4e1a\u751f";
                break;
            }
        }
        return js;
    }

    public static String getSalary(long min, long max) {
        if (min == -1L && max == -1L) {
            return "\u9762\u8bae";
        }
        if (min == -1L) {
            String maxsalary = max + "";
            if (max > 1000L) {
                maxsalary = max / 1000L + "K";
            }
            return maxsalary + "\u4ee5\u4e0b";
        }
        if (max == -1L) {
            String minsalary = min + "";
            if (min > 1000L) {
                minsalary = min / 1000L + "K";
            }
            return minsalary + "\u4ee5\u4e0a";
        }
        String minsalary = min + "";
        String maxsalary = max + "";
        if (max > 1000L) {
            maxsalary = max / 1000L + "K";
        }
        if (min > 1000L) {
            minsalary = min / 1000L + "K";
        }
        return minsalary + "-" + maxsalary;
    }

    public static String getWorkExpSalary(BigDecimal min, BigDecimal max) {
        if (min == null) {
            min = new BigDecimal("0");
        }
        if (max == null) {
            max = new BigDecimal("0");
        }
        if (min.compareTo(new BigDecimal("-1")) == 0) {
            String maxsalary = max + "";
            if (max.compareTo(new BigDecimal("1000")) == 1) {
                maxsalary = max.divide(new BigDecimal("1000"), 0, 4) + "K";
            }
            return maxsalary + "\u4ee5\u4e0b";
        }
        if (max.compareTo(new BigDecimal("-1")) == 0) {
            String minsalary = min + "";
            if (min.compareTo(new BigDecimal("1000")) == 1) {
                minsalary = min.divide(new BigDecimal("1000"), 0, 4) + "K";
            }
            return minsalary + "\u4ee5\u4e0a";
        }
        String minsalary = min + "";
        String maxsalary = max + "";
        if (max.compareTo(new BigDecimal("1000")) == 1) {
            maxsalary = max.divide(new BigDecimal("1000"), 0, 4) + "K";
        }
        if (min.compareTo(new BigDecimal("1000")) == 1) {
            minsalary = min.divide(new BigDecimal("1000"), 0, 4) + "K";
        }
        return minsalary + "-" + maxsalary;
    }

    public static String getEducation(int edu) {
        String edutxt = "\u65e0";
        if (edu == 0) {
            return "\u65e0";
        }
        String[] eduarr = new String[]{"\u65e0", "\u5c0f\u5b66", "\u4e2d\u5b66", "\u521d\u4e2d", "\u9ad8\u4e2d", "\u4e13\u79d1", "\u4e2d\u4e13", "\u5927\u4e13", "\u672c\u79d1", "\u7855\u58eb", "\u535a\u58eb", "\u535a\u58eb\u540e"};
        String[] edumode = new String[]{"", "\u4ee5\u4e0b", "\u4ee5\u4e0a"};
        int a = edu % 10;
        int b = edu / 10;
        edutxt = eduarr[b] + edumode[a];
        return edutxt;
    }

    public static String cHasInP(List<String> c, List<String> p) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < c.size(); ++i) {
            boolean find = false;
            for (int j = 0; j < p.size(); ++j) {
                if (!Strings.equals((String)c.get(i), (String)p.get(j))) continue;
                find = true;
                break;
            }
            if (find) continue;
            sb.append(c.get(i) + " ");
        }
        return sb.toString();
    }

    public static boolean allFieldIsNULL(Object o) {
        if (o == null) {
            return true;
        }
        try {
            for (Field field : o.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(o);
                if (!(value instanceof CharSequence ? !ObjectUtils.isEmpty((Object)value) : null != value)) continue;
                return false;
            }
        }
        catch (Exception e) {
            System.out.println("\u5224\u65ad\u5bf9\u8c61\u5c5e\u6027\u4e3a\u7a7a\u5f02\u5e38" + e);
        }
        return true;
    }

    public static <T> T setFieldIsEmptyToNull(T obj) {
        if (obj == null) {
            return obj;
        }
        try {
            for (Field field : obj.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(obj);
                if (!(value instanceof CharSequence) || !ObjectUtils.isEmpty((Object)value)) continue;
                field.set(obj, null);
            }
            return obj;
        }
        catch (Exception e) {
            System.out.println("\u5224\u65ad\u5bf9\u8c61\u5c5e\u6027\u4e3a\u7a7a\u5f02\u5e38" + e);
            return obj;
        }
    }

    public static String vo2mysqlField(Class<?> cls, String prex, String fieldPrex) {
        ArrayList<Field> fs = new ArrayList<Field>();
        Field[] cfs = cls.getDeclaredFields();
        fs.addAll(Arrays.asList(cfs));
        Field[] pfs = new Field[]{};
        if (cls.getSuperclass().getName() == BaseEntity.class.getName()) {
            pfs = cls.getSuperclass().getDeclaredFields();
        }
        fs.addAll(Arrays.asList(pfs));
        if (fs.size() <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (int i = 0; i < fs.size(); ++i) {
            Column cd;
            JsonIgnore jsonIgnore = ((Field)fs.get(i)).getAnnotation(JsonIgnore.class);
            if (jsonIgnore != null || (cd = ((Field)fs.get(i)).getDeclaredAnnotation(Column.class)) == null || !Strings.isNotBlank((CharSequence)cd.value())) continue;
            if (index > 0) {
                sb.append(",");
            }
            sb.append(prex + "." + cd.value() + " as " + fieldPrex + ((Field)fs.get(i)).getName());
            ++index;
        }
        return sb.toString();
    }

    public static String vo2PgsqlField(Class<?> cls, String prex, String fieldPrex, boolean isExtends) {
        Field[] pfs;
        prex = Funs.isBlank(prex) ? "" : prex + ".";
        fieldPrex = Funs.isBlank(fieldPrex) ? "" : fieldPrex;
        ArrayList<Field> fs = new ArrayList<Field>();
        if (isExtends) {
            do {
                pfs = cls.getDeclaredFields();
                fs.addAll(Arrays.asList(pfs));
            } while (!Strings.equals((String)(cls = cls.getSuperclass()).getName(), (String)Object.class.getName()));
        } else {
            pfs = cls.getDeclaredFields();
            fs.addAll(Arrays.asList(pfs));
        }
        if (fs.size() <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (int i = 0; i < fs.size(); ++i) {
            FunsSqlIngore fsi;
            JsonIgnore jsonIgnore = ((Field)fs.get(i)).getAnnotation(JsonIgnore.class);
            if (jsonIgnore != null || (fsi = ((Field)fs.get(i)).getAnnotation(FunsSqlIngore.class)) != null) continue;
            Column cd = ((Field)fs.get(i)).getDeclaredAnnotation(Column.class);
            String fieldType = ((Field)fs.get(i)).getType().toString();
            if (cd == null || !Funs.isNotBlank(cd.value())) continue;
            if (index > 0) {
                sb.append(",");
            }
            if (fieldType.endsWith("Date")) {
                sb.append("to_char(" + prex + cd.value() + ",'yyyy-MM-DD HH24:MI:SS') as " + fieldPrex + ((Field)fs.get(i)).getName());
            } else {
                sb.append(prex + cd.value() + " as \"" + fieldPrex + ((Field)fs.get(i)).getName() + "\"");
            }
            ++index;
        }
        System.out.println("SB2=" + sb.toString());
        return sb.toString();
    }

    public static String vo2PgsqlField(Class<?> cls, String alias, String fieldPrex, String filterField, String allowField, boolean isExtends) {
        return Funs.vo2PgsqlField(cls, alias, fieldPrex, filterField, allowField, isExtends, true);
    }

    public static String vo2PgsqlField(Class<?> cls, String alias, String fieldPrex, String filterField, String allowField, boolean isExtends, boolean toEntityField) {
        Field[] dfs;
        alias = Funs.isBlank(alias) ? "" : alias + ".";
        fieldPrex = Funs.isBlank(fieldPrex) ? "" : fieldPrex;
        ArrayList<Field> fs = new ArrayList<Field>();
        if (isExtends) {
            do {
                dfs = cls.getDeclaredFields();
                fs.addAll(Arrays.asList(dfs));
            } while (!Funs.equals((cls = cls.getSuperclass()).getName(), Object.class.getName()));
        } else {
            dfs = cls.getDeclaredFields();
            fs.addAll(Arrays.asList(dfs));
        }
        if (fs.size() <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (int i = 0; i < fs.size(); ++i) {
            String columns;
            FunsSqlIngore fsi;
            String[] allowFields;
            String[] filterFields;
            JsonIgnore jsonIgnore = ((Field)fs.get(i)).getAnnotation(JsonIgnore.class);
            if (jsonIgnore != null || Funs.isNotBlank(filterField) && Arrays.asList(filterFields = filterField.split("\\|")).contains(((Field)fs.get(i)).getName()) || Funs.isNotBlank(allowField) && !Arrays.asList(allowFields = allowField.split("\\|")).contains(((Field)fs.get(i)).getName()) || (fsi = ((Field)fs.get(i)).getAnnotation(FunsSqlIngore.class)) != null) continue;
            Column cd = ((Field)fs.get(i)).getDeclaredAnnotation(Column.class);
            String fieldType = ((Field)fs.get(i)).getType().toString();
            if (cd == null || !Funs.isNotBlank(cd.value())) continue;
            if (index > 0) {
                sb.append(",");
            }
            String string = columns = toEntityField ? fieldPrex + ((Field)fs.get(i)).getName() : fieldPrex + cd.value();
            if (fieldType.endsWith("Date")) {
                sb.append("to_char(" + alias + cd.value() + ",'yyyy-MM-DD HH24:MI:SS') as " + columns);
            } else {
                sb.append(alias + cd.value() + " as \"" + columns + "\"");
            }
            ++index;
        }
        System.out.println("SB: " + sb.toString());
        return sb.toString();
    }

    public <T> T map2obj(Class<T> cls, NutMap map) {
        Field[] fields;
        Object object = null;
        try {
            object = cls.newInstance();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (map == null || map.isEmpty()) {
            return null;
        }
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                String type = field.getType().getSimpleName();
                if ("int".equals(type)) {
                    field.setInt(object, map.getInt(field.getName()));
                    continue;
                }
                if ("double".equals(type)) {
                    field.setDouble(object, map.getDouble(field.getName()));
                    continue;
                }
                if ("float".equals(type)) {
                    field.setFloat(object, map.getFloat(field.getName()));
                    continue;
                }
                field.set(object, map.get((Object)field.getName()));
            }
            catch (Exception e) {
                System.out.println("map->obj:" + e.getMessage());
            }
        }
        return (T)object;
    }

    public static String firstUpperCase(String s) {
        if (Strings.isBlank((CharSequence)s)) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static <T> Map list2map(List<T> list, String key) {
        if (list == null || list.size() <= 0 || Strings.isBlank((CharSequence)key)) {
            System.out.println("Funs.list2map -> \u6240\u4f20\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        T t = list.get(0);
        try {
            Field field = t.getClass().getDeclaredField(key);
            if (field == null) {
                System.out.println("Funs.list2map -> \u6240\u4f20key\u4e0d\u662flist\u9879\u4e2d\u7684\u5b57\u6bb5");
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        HashMap<String, T> map = new HashMap<String, T>();
        for (T item : list) {
            try {
                Field field = t.getClass().getDeclaredField(key);
                field.setAccessible(true);
                Method me = item.getClass().getMethod("get" + Strings.upperFirst((CharSequence)key), new Class[0]);
                map.put((String)me.invoke(item, new Object[0]), item);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static Date timeParse(String time) {
        if (Strings.isBlank((CharSequence)time)) {
            return null;
        }
        time = time.replaceAll("/", "-").trim();
        ArrayList<SimpleDateFormat> dateFormats = new ArrayList<SimpleDateFormat>();
        dateFormats.add(new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss"));
        dateFormats.add(new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm"));
        dateFormats.add(new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH"));
        dateFormats.add(new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5"));
        dateFormats.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        dateFormats.add(new SimpleDateFormat("yyyy-MM-dd HH:mm"));
        dateFormats.add(new SimpleDateFormat("yyyy-MM-dd HH"));
        dateFormats.add(new SimpleDateFormat("yyyy-MM-dd"));
        for (SimpleDateFormat format : dateFormats) {
            try {
                format.setLenient(false);
                Date date = format.parse(time);
                return date;
            }
            catch (Exception exception) {
            }
        }
        System.out.println("\u65f6\u95f4[" + time + "]\u89e3\u6790\u4e0d\u4e86\u4e86");
        return null;
    }

    public static Date string2Date(String date) {
        try {
            String fmt = "yyyy-MM-dd";
            if (date.contains(".")) {
                fmt = "yyyy-MM-dd";
                date = date.replace(".", "-");
            } else {
                fmt = date.contains("/") ? "yyyy/MM/dd" : (date.contains("-") ? "yyyy-MM-dd" : "yyyyMMdd");
            }
            SimpleDateFormat myFormatter = new SimpleDateFormat(fmt);
            Date mydate = myFormatter.parse(date);
            return mydate;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static long getShijinacuo(String date) {
        return Funs.formatCan(date).getTime();
    }

    public static Date formatCan(String date) {
        String[] format = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH", "yyyy-MM-dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM/dd HH", "yyyy/MM/dd", "MM/dd HH:mm:ss", "MM/dd HH:mm", "MM/dd HH", "MM/dd", "MM-dd HH:mm:ss", "MM-dd HH:mm", "MM-dd HH", "MM-dd"};
        for (int i = 0; i < format.length; ++i) {
            try {
                Date d = Times.parse((String)format[i], (String)date);
                return d;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return new Date();
    }

    public static String getTableName(Class<?> cls) {
        Table table = cls.getAnnotation(Table.class);
        return table.prefix() + table.value() + table.suffix();
    }

    public static String getTableName(Class<?> cls, String alias) {
        Table table = cls.getAnnotation(Table.class);
        return table.prefix() + table.value() + table.suffix() + " " + alias;
    }

    public static int getAge(Date birthDay) {
        int age = 0;
        Calendar born = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        if (birthDay != null) {
            int bornDayOfYear;
            now.setTime(new Date());
            born.setTime(birthDay);
            if (born.after(now)) {
                throw new IllegalArgumentException("\u5e74\u9f84\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u65e5\u671f");
            }
            age = now.get(1) - born.get(1);
            int nowDayOfYear = now.get(6);
            if (nowDayOfYear < (bornDayOfYear = born.get(6))) {
                --age;
            }
        }
        return age;
    }

    public static int getAge(String birthDay) {
        int age = 0;
        Calendar born = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        if (Funs.isNotBlank(birthDay)) {
            int bornDayOfYear;
            now.setTime(new Date());
            born.setTime(Funs.string2Date(birthDay));
            if (born.after(now)) {
                throw new IllegalArgumentException("\u5e74\u9f84\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u65e5\u671f");
            }
            age = now.get(1) - born.get(1);
            int nowDayOfYear = now.get(6);
            if (nowDayOfYear < (bornDayOfYear = born.get(6))) {
                --age;
            }
        }
        return age;
    }

    public static boolean isBlank(CharSequence cs) {
        if (null == cs) {
            return true;
        }
        int length = cs.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !Funs.isBlank(cs);
    }

    public static boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public static long minTime() {
        return Times.parseq((String)"yyyy-MM-dd", (String)"1994-01-11").getTime();
    }

    public static long maxTime() {
        return Times.parseq((String)"yyyy-MM-dd", (String)"3021-01-11").getTime();
    }

    public static boolean testURLConn(String url) {
        int status = 404;
        try {
            URL conn = new URL(url);
            HttpURLConnection openConn = (HttpURLConnection)conn.openConnection();
            openConn.setUseCaches(false);
            openConn.setConnectTimeout(3000);
            status = openConn.getResponseCode();
            if (200 == status) {
                return true;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return false;
    }

    public static int daysBetween(Date smdate, Date bdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        smdate = sdf.parse(sdf.format(smdate));
        bdate = sdf.parse(sdf.format(bdate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static int daysBetween(String smdate, String bdate) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(Funs.string2Date(smdate));
            long time1 = cal.getTimeInMillis();
            cal.setTime(Funs.string2Date(bdate));
            long time2 = cal.getTimeInMillis();
            long between_days = (time2 - time1) / 86400000L;
            return Integer.parseInt(String.valueOf(between_days));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String daysFormat(String fromDate, String toDate) {
        toDate = Funs.equals(toDate, "-1") ? Funs.getYMD() : toDate;
        Calendar cal = Calendar.getInstance();
        cal.setTime(Funs.string2Date(fromDate));
        long time1 = cal.getTimeInMillis();
        cal.setTime(Funs.string2Date(toDate));
        long time2 = cal.getTimeInMillis();
        Long between_days = (time2 - time1) / 86400000L;
        int betweenDay = between_days.intValue();
        StringBuffer result = new StringBuffer();
        if (betweenDay > 365) {
            int year = betweenDay / 365;
            int mod = betweenDay % 365;
            result.append(year + "\u5e74");
            if (mod > 30) {
                int month = mod / 30;
                int day = mod % 30;
                result.append(month + "\u4e2a\u6708");
                if (day > 0) {
                    result.append(day + "\u5929");
                }
            } else if (mod > 0) {
                result.append(mod + "\u5929");
            }
        } else if (betweenDay > 30) {
            int month = betweenDay / 30;
            int day = betweenDay % 30;
            result.append(month + "\u4e2a\u6708");
            if (day > 0) {
                result.append(day + "\u5929");
            }
        } else if (betweenDay > 0) {
            result.append(betweenDay + "\u5929");
        }
        return result.toString();
    }

    public static String daysFormat(String fromDate, String toDate, boolean rsMonth, boolean rsDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(Funs.string2Date(fromDate));
        long time1 = cal.getTimeInMillis();
        cal.setTime(Funs.string2Date(toDate));
        long time2 = cal.getTimeInMillis();
        Long between_days = (time2 - time1) / 86400000L;
        int betweenDay = between_days.intValue();
        StringBuffer result = new StringBuffer();
        if (betweenDay > 365) {
            int year = betweenDay / 365;
            int mod = betweenDay % 365;
            result.append(year + "\u5e74");
            if (mod > 30) {
                if (mod <= 120) {
                    int month = mod / 30;
                    int day = mod % 30;
                    if (rsMonth) {
                        result.append(month + "\u4e2a\u6708");
                    }
                    if (rsDay && day > 0) {
                        result.append(day + "\u5929");
                    }
                } else if (mod > 120) {
                    int mods = mod - 120;
                    int month = 4;
                    month += mods / 31;
                    int day = mods % 31;
                    if (rsMonth) {
                        result.append(month + "\u4e2a\u6708");
                    }
                    if (rsDay && day > 0) {
                        result.append(day + "\u5929");
                    }
                }
            } else if (rsDay && mod > 0) {
                result.append(mod + "\u5929");
            }
        } else if (betweenDay > 30) {
            int month = betweenDay / 30;
            int day = betweenDay % 30;
            if (rsMonth) {
                result.append(month + "\u4e2a\u6708");
            }
            if (rsDay && day > 0) {
                result.append(day + "\u5929");
            }
        } else if (rsDay && betweenDay > 0) {
            result.append(betweenDay + "\u5929");
        }
        return result.toString();
    }

    public static boolean checkDateFormat(String[] fmtArr, String date) {
        if (fmtArr == null || fmtArr.length <= 0) {
            return false;
        }
        if (Strings.isBlank((CharSequence)date)) {
            return false;
        }
        for (int i = 0; i < fmtArr.length; ++i) {
            try {
                Date d = Times.parse((String)fmtArr[i], (String)date);
                if (d == null) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String daysFormat(int days, boolean rsMonth, boolean rsDay) {
        int betweenDay = days;
        StringBuffer result = new StringBuffer();
        if (betweenDay > 365) {
            int year = betweenDay / 365;
            int mod = betweenDay % 365;
            result.append(year + "\u5e74");
            if (mod > 30) {
                if (mod <= 120) {
                    int month = mod / 30;
                    int day = mod % 30;
                    if (rsMonth) {
                        result.append(month + "\u4e2a\u6708");
                    }
                    if (rsDay && day > 0) {
                        result.append(day + "\u5929");
                    }
                } else if (mod > 120) {
                    int mods = mod - 120;
                    int month = 4;
                    month += mods / 31;
                    int day = mods % 31;
                    if (rsMonth) {
                        result.append(month + "\u4e2a\u6708");
                    }
                    if (rsDay && day > 0) {
                        result.append(day + "\u5929");
                    }
                }
            } else if (rsDay && mod > 0) {
                result.append(mod + "\u5929");
            }
        } else if (betweenDay > 30) {
            int month = betweenDay / 30;
            int day = betweenDay % 30;
            if (rsMonth) {
                result.append(month + "\u4e2a\u6708");
            }
            if (rsDay && day > 0) {
                result.append(day + "\u5929");
            }
        } else if (rsDay && betweenDay > 0) {
            result.append(betweenDay + "\u5929");
        }
        return result.toString();
    }

    public static String getLastDayOfMonth(String yearMonth) {
        yearMonth = yearMonth.replace(".", "-").replace("/", "-");
        int year = Integer.parseInt(yearMonth.split("-")[0]);
        int month = Integer.parseInt(yearMonth.split("-")[1]);
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        int lastDay = cal.getMinimum(5);
        cal.set(5, lastDay - 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(cal.getTime());
    }

    public static int compareVersion(String v1, String v2) {
        if (v1 == null || v2 == null || "".equals(v1) || "".equals(v2)) {
            return 0;
        }
        if (v1.equals(v2)) {
            return 0;
        }
        String[] version1Array = v1.split("[._]");
        String[] version2Array = v2.split("[._]");
        int minLen = Math.min(version1Array.length, version2Array.length);
        long diff = 0L;
        for (int index = 0; index < minLen && (diff = Long.parseLong(version1Array[index]) - Long.parseLong(version2Array[index])) == 0L; ++index) {
        }
        if (diff == 0L) {
            int i;
            for (i = index; i < version1Array.length; ++i) {
                if (Long.parseLong(version1Array[i]) <= 0L) continue;
                return 1;
            }
            for (i = index; i < version2Array.length; ++i) {
                if (Long.parseLong(version2Array[i]) <= 0L) continue;
                return -1;
            }
            return 0;
        }
        return diff > 0L ? 1 : -1;
    }

    public static List<String> getLastMonths(int size, boolean asc) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            c.setTime(new Date());
            c.add(2, -i);
            Date m = c.getTime();
            list.add(sdf.format(m));
        }
        if (asc) {
            Collections.reverse(list);
        }
        return list;
    }

    public static final String getNowLocalDate() {
        LocalDate ld = LocalDate.now();
        return ld.format(DateTimeFormatter.BASIC_ISO_DATE);
    }

    public static final String getNowLocalIsoDate() {
        LocalDate ld = LocalDate.now();
        return ld.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static final int getNowLocalYear() {
        LocalDate ld = LocalDate.now();
        return ld.getYear();
    }

    public static final int getNowLocalMonth() {
        LocalDate ld = LocalDate.now();
        return ld.getMonthValue();
    }

    public static String parseGrade(int grade) {
        if (grade <= 0 && grade > 12) {
            return "";
        }
        String[] g = new String[]{"", "\u4e00\u5e74\u7ea7", "\u4e8c\u5e74\u7ea7", "\u4e09\u5e74\u7ea7", "\u56db\u5e74\u7ea7", "\u4e94\u5e74\u7ea7", "\u516d\u5e74\u7ea7", "\u4e03\u5e74\u7ea7", "\u516b\u5e74\u7ea7", "\u4e5d\u5e74\u7ea7", "\u9ad8\u4e00", "\u9ad8\u4e8c", "\u9ad8\u4e09"};
        return g[grade];
    }

    public static String parseSemester(int semester) {
        if (semester <= 0) {
            return "";
        }
        String[] s = new String[]{"", "\u7b2c\u4e00\u5b66\u671f", "\u7b2c\u4e8c\u5b66\u671f", "\u7b2c\u4e09\u5b66\u671f"};
        return s[semester];
    }

    public static boolean matcher(String text, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        return matcher.matches();
    }

    public static String parseDate(String dateStr, DateTimeFormatter dtf) {
        try {
            if (dateStr == null || "".equals(dateStr)) {
                return "";
            }
            LocalDate date = LocalDate.parse(dateStr, dtf);
            return date.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String percentage(int total, int sub) {
        if (total == 0) {
            return "0%";
        }
        BigDecimal bdtotal = new BigDecimal(total + "");
        BigDecimal bdsub = new BigDecimal(sub + "");
        BigDecimal div = bdsub.divide(bdtotal, 4, 4);
        BigDecimal rs = div.multiply(new BigDecimal("100"));
        return rs.stripTrailingZeros().toPlainString() + "%";
    }

    public static List<String> getImgSrc(String content) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern p_img = Pattern.compile("<(img|IMG)(.*?)(/>|></img>|>)");
        Matcher m_img = p_img.matcher(content);
        boolean result_img = m_img.find();
        if (result_img) {
            while (result_img) {
                String str_img = m_img.group(2);
                Pattern p_src = Pattern.compile("(src|SRC)=(\"|')(.*?)(\"|')");
                Matcher m_src = p_src.matcher(str_img);
                if (m_src.find()) {
                    String str_src = m_src.group(3);
                    list.add(str_src);
                }
                result_img = m_img.find();
            }
        }
        return list;
    }

    public static String strHtmlFilter(String str, String fs) {
        if (Strings.isBlank((CharSequence)str)) {
            return str;
        }
        str = str.replaceAll("&nbsp;", " ");
        if (Strings.isBlank((CharSequence)fs)) {
            return str;
        }
        String regEx = "(?!<(" + fs + ").*?>)<.*?>";
        Pattern p_html = Pattern.compile(regEx, 2);
        Matcher m_html = p_html.matcher(str);
        str = m_html.replaceAll("");
        return str.trim();
    }

    public static String toPlainString(BigDecimal bd) {
        if (bd == null) {
            return "0";
        }
        return bd.stripTrailingZeros().toPlainString();
    }

    public static String toPlainString(BigDecimal bd, int scale) {
        if (bd == null) {
            return "0";
        }
        bd = bd.setScale(scale, 4);
        return bd.stripTrailingZeros().toPlainString();
    }

    public static List<Integer> parseGradeScale(String scale) {
        ArrayList<Integer> gradeArr = new ArrayList<Integer>();
        switch (scale) {
            case "100": {
                for (int i = 1; i <= 6; ++i) {
                    gradeArr.add(i);
                }
                break;
            }
            case "110": {
                for (int i = 1; i <= 9; ++i) {
                    gradeArr.add(i);
                }
                break;
            }
            case "111": {
                for (int i = 1; i <= 12; ++i) {
                    gradeArr.add(i);
                }
                break;
            }
            case "010": {
                for (int i = 7; i <= 9; ++i) {
                    gradeArr.add(i);
                }
                break;
            }
            case "011": {
                for (int i = 7; i <= 12; ++i) {
                    gradeArr.add(i);
                }
                break;
            }
            case "001": {
                for (int i = 10; i <= 12; ++i) {
                    gradeArr.add(i);
                }
                break;
            }
            case "101": {
                int i;
                for (i = 1; i <= 6; ++i) {
                    gradeArr.add(i);
                }
                for (i = 10; i <= 12; ++i) {
                    gradeArr.add(i);
                }
                break;
            }
        }
        return gradeArr;
    }

    public static List<Map> parseGradeScaleToListMap(String scale) {
        ArrayList<Map> gradeArr = new ArrayList<Map>();
        Funs.getNowLocalDate();
        switch (scale) {
            case "100": {
                for (int i = 1; i <= 6; ++i) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("gradeName", Funs.parseGrade(i));
                    data.put("gradeValue", i);
                    gradeArr.add(data);
                }
                break;
            }
            case "110": {
                for (int i = 1; i <= 9; ++i) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("gradeName", Funs.parseGrade(i));
                    data.put("gradeValue", i);
                    gradeArr.add(data);
                }
                break;
            }
            case "111": {
                for (int i = 1; i <= 12; ++i) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("gradeName", Funs.parseGrade(i));
                    data.put("gradeValue", i);
                    gradeArr.add(data);
                }
                break;
            }
            case "010": {
                for (int i = 7; i <= 9; ++i) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("gradeName", Funs.parseGrade(i));
                    data.put("gradeValue", i);
                    gradeArr.add(data);
                }
                break;
            }
            case "011": {
                for (int i = 7; i <= 12; ++i) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("gradeName", Funs.parseGrade(i));
                    data.put("gradeValue", i);
                    gradeArr.add(data);
                }
                break;
            }
            case "001": {
                for (int i = 10; i <= 12; ++i) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("gradeName", Funs.parseGrade(i));
                    data.put("gradeValue", i);
                    gradeArr.add(data);
                }
                break;
            }
            case "101": {
                HashMap<String, Object> data;
                int i;
                for (i = 1; i <= 6; ++i) {
                    data = new HashMap<String, Object>();
                    data.put("gradeName", Funs.parseGrade(i));
                    data.put("gradeValue", i);
                    gradeArr.add(data);
                }
                for (i = 10; i <= 12; ++i) {
                    data = new HashMap();
                    data.put("gradeName", Funs.parseGrade(i));
                    data.put("gradeValue", i);
                    gradeArr.add(data);
                }
                break;
            }
        }
        return gradeArr;
    }

    public static List<Map> parseGradeScaleToListMapV2(String scale, int semester) {
        ArrayList<Map> gradeArr = new ArrayList<Map>();
        int year = Funs.getNowLocalYear();
        int month = Funs.getNowLocalMonth();
        boolean secondSemester = false;
        secondSemester = semester == 1 ? true : (semester == 1 ? false : month > 7);
        int gradeYear = secondSemester ? year : year - 1;
        switch (scale) {
            case "100": {
                for (int i = gradeYear; i > gradeYear - 6; --i) {
                    int diff = year - i;
                    diff = secondSemester ? diff + 1 : diff;
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("gradeName", Funs.parseGrade(diff));
                    data.put("gradeValue", i);
                    data.put("gradeType", 1);
                    gradeArr.add(data);
                }
                break;
            }
            case "110": {
                HashMap<String, Object> data;
                int diff;
                int i;
                for (i = gradeYear; i > gradeYear - 6; --i) {
                    diff = year - i;
                    diff = secondSemester ? diff + 1 : diff;
                    data = new HashMap<String, Object>();
                    data.put("gradeName", Funs.parseGrade(diff));
                    data.put("gradeValue", i);
                    data.put("gradeType", 1);
                    gradeArr.add(data);
                }
                for (i = gradeYear; i > gradeYear - 3; --i) {
                    diff = year - i;
                    diff = secondSemester ? diff + 1 : diff;
                    data = new HashMap();
                    data.put("gradeName", Funs.parseGrade(diff += 6));
                    data.put("gradeValue", i);
                    data.put("gradeType", 2);
                    gradeArr.add(data);
                }
                break;
            }
            case "111": {
                HashMap<String, Object> data;
                int diff;
                int i;
                for (i = gradeYear; i > gradeYear - 6; --i) {
                    diff = year - i;
                    diff = secondSemester ? diff + 1 : diff;
                    data = new HashMap<String, Object>();
                    data.put("gradeName", Funs.parseGrade(diff));
                    data.put("gradeValue", i);
                    data.put("gradeType", 1);
                    gradeArr.add(data);
                }
                for (i = gradeYear; i > gradeYear - 3; --i) {
                    diff = year - i;
                    diff = secondSemester ? diff + 1 : diff;
                    data = new HashMap();
                    data.put("gradeName", Funs.parseGrade(diff += 6));
                    data.put("gradeValue", i);
                    data.put("gradeType", 2);
                    gradeArr.add(data);
                }
                for (i = gradeYear; i > gradeYear - 3; --i) {
                    diff = year - i;
                    diff = secondSemester ? diff + 1 : diff;
                    data = new HashMap();
                    data.put("gradeName", Funs.parseGrade(diff += 9));
                    data.put("gradeValue", i);
                    data.put("gradeType", 3);
                    gradeArr.add(data);
                }
                break;
            }
            case "010": {
                for (int i = gradeYear; i > gradeYear - 3; --i) {
                    int diff = year - i;
                    diff = secondSemester ? diff + 1 : diff;
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("gradeName", Funs.parseGrade(diff += 6));
                    data.put("gradeValue", i);
                    data.put("gradeType", 2);
                    gradeArr.add(data);
                }
                break;
            }
            case "011": {
                HashMap<String, Object> data;
                int diff;
                int i;
                for (i = gradeYear; i > gradeYear - 3; --i) {
                    diff = year - i;
                    diff = secondSemester ? diff + 1 : diff;
                    data = new HashMap<String, Object>();
                    data.put("gradeName", Funs.parseGrade(diff += 6));
                    data.put("gradeValue", i);
                    data.put("gradeType", 2);
                    gradeArr.add(data);
                }
                for (i = gradeYear; i > gradeYear - 3; --i) {
                    diff = year - i;
                    diff = secondSemester ? diff + 1 : diff;
                    data = new HashMap();
                    data.put("gradeName", Funs.parseGrade(diff += 9));
                    data.put("gradeValue", i);
                    data.put("gradeType", 3);
                    gradeArr.add(data);
                }
                break;
            }
            case "001": {
                for (int i = gradeYear; i > gradeYear - 3; --i) {
                    int diff = year - i;
                    diff = secondSemester ? diff + 1 : diff;
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("gradeName", Funs.parseGrade(diff += 9));
                    data.put("gradeValue", i);
                    data.put("gradeType", 3);
                    gradeArr.add(data);
                }
                break;
            }
            case "101": {
                HashMap<String, Object> data;
                int diff;
                int i;
                for (i = gradeYear; i > gradeYear - 6; --i) {
                    diff = year - i;
                    diff = secondSemester ? diff + 1 : diff;
                    data = new HashMap<String, Object>();
                    data.put("gradeName", Funs.parseGrade(diff));
                    data.put("gradeValue", i);
                    data.put("gradeType", 1);
                    gradeArr.add(data);
                }
                for (i = gradeYear; i > gradeYear - 3; --i) {
                    diff = year - i;
                    diff = secondSemester ? diff + 1 : diff;
                    data = new HashMap();
                    data.put("gradeName", Funs.parseGrade(diff += 9));
                    data.put("gradeValue", i);
                    data.put("gradeType", 3);
                    gradeArr.add(data);
                }
                break;
            }
        }
        return gradeArr;
    }

    public static boolean isIdentityCode(String code) {
        int IDENTITYCODE_OLD = 15;
        int IDENTITYCODE_NEW = 18;
        int[] coeff = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        char[] end = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        if (Strings.isEmpty((CharSequence)code)) {
            return false;
        }
        String birthDay = "";
        if ((code = code.trim().toUpperCase()).length() != IDENTITYCODE_OLD && code.length() != IDENTITYCODE_NEW) {
            return false;
        }
        Pattern pt = Pattern.compile("(^\\d{15}$)|(\\d{17}(?:\\d|x|X)$)");
        Matcher mt = pt.matcher(code);
        if (!mt.find()) {
            return false;
        }
        birthDay = code.length() == IDENTITYCODE_OLD ? "19" + code.substring(6, 12) : code.substring(6, 14);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            Date date = sdf.parse(birthDay);
            if (date == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        if (code.length() == IDENTITYCODE_NEW) {
            String tempId = code.substring(0, IDENTITYCODE_NEW - 1);
            int sum = 0;
            for (int i = 0; i < tempId.length(); ++i) {
                int bye = tempId.charAt(i) - 48;
                sum += bye * coeff[i];
            }
            if (end[sum %= 11] != code.substring(IDENTITYCODE_NEW - 1, IDENTITYCODE_NEW).charAt(0)) {
                return false;
            }
        }
        return true;
    }
}

