/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.base.common;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jacksons {
    protected static final Logger log = LoggerFactory.getLogger(Jacksons.class);
    private static ObjectMapper mapper = new ObjectMapper();

    public static String toJSONString(Object object) {
        return Jacksons.toJSONString(object, false);
    }

    public static String toJSONString(Object object, boolean pretty) {
        try {
            if (pretty) {
                mapper.writerWithDefaultPrettyPrinter();
            }
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static <T> T toJavaObject(String json, Class<T> clazz) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (JsonMappingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static JavaType getCollectionType(ObjectMapper mapper, Class<?> collectionClass, Class<?> ... elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static <T> List<T> toList(String json, Class<T> clazz) {
        try {
            return (List)mapper.readValue(json, Jacksons.getCollectionType(mapper, List.class, clazz));
        }
        catch (JsonMappingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ArrayList();
    }

    public static <T> List<T> toList(String json) {
        try {
            return (List)mapper.readValue(json, new TypeReference<List<T>>(){});
        }
        catch (JsonMappingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ArrayList();
    }

    public static JsonNode toJsonObject(String jsonString) {
        try {
            return mapper.readTree(jsonString);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static JsonNode toJsonObject(Object object) {
        try {
            return mapper.readTree(mapper.writeValueAsString(object));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static ArrayNode arrayNode() {
        return mapper.createArrayNode();
    }

    public static ObjectNode objectNode() {
        return mapper.createObjectNode();
    }

    static {
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }
}

