/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.base.controller;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.io.FileUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.nutz.dao.Dao;
import org.nutz.filepool.FilePool;
import org.nutz.lang.Files;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import top.xtcoder.jdcbase.base.core.Resp;
import top.xtcoder.jdcbase.base.entity.system.FileInfo;

@Api(tags={"\u6587\u4ef6\u6c60\u6a21\u5757"})
@RestController
@RequestMapping(value={"/jdcbase/prbase/file/pool"})
public class PrBaseFilePoolController {
    @Autowired
    private FilePool pool;
    @Autowired
    private Dao dao;

    @Order(value=0)
    @ApiOperation(value="\u5355\u6587\u4ef6\u4e0a\u4f20\u65b9\u6cd5-\u4e0d\u4fdd\u5b58\u5230\u6570\u636e\u5e93", consumes="multipart/form-data")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u6587\u4ef6\u6d41\u6570\u636e", required=true, paramType="form", dataType="__File")})
    @PostMapping(value={"/singleFiles"})
    public Resp<FileInfo> singleFiles(@RequestParam(value="file", required=true) MultipartFile file, HttpServletRequest request) {
        try {
            String fileName = file.getOriginalFilename();
            String contentType = file.getContentType();
            String suffix = "." + contentType.split("/")[1];
            File saveFile = this.pool.createFile(suffix);
            file.transferTo(saveFile);
            long id = this.pool.getFileId(saveFile);
            String url = "/jdcbase/prbase/file/pool/getFile/" + id + "/" + fileName;
            FileInfo data = new FileInfo();
            data.init();
            data.setName(fileName);
            data.setTitle(fileName);
            data.setPath(saveFile.getAbsolutePath());
            data.setFileMd5(DigestUtils.md5Hex((InputStream)new FileInputStream(data.getPath())));
            data.setUrl(url);
            data.setSuffix(suffix);
            data.setContentType(contentType);
            data.setSize(saveFile.length());
            String userid = "DEFAULT";
            String usertype = "DEFAULT";
            try {
                userid = StpUtil.getLoginId().toString().substring(1);
                usertype = StpUtil.getLoginId().toString().substring(0, 1);
            }
            catch (Exception e) {
                System.err.println("\u672a\u767b\u5f55\u7528\u6237\u4e0a\u4f20\uff0c\u91c7\u7528\u9ed8\u8ba4userid=DEFAULT");
            }
            data.setUserid(userid);
            return Resp.OK("\u4e0a\u4f20\u6210\u529f", data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Resp.ERROR("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @Order(value=1)
    @ApiOperation(value="\u6279\u91cf\u6587\u4ef6\u4e0a\u4f20\u65b9\u6cd5-\u4e0d\u4fdd\u5b58\u5230\u6570\u636e\u5e93", consumes="multipart/form-data")
    @ApiImplicitParam(name="files", value="\u6587\u4ef6\u6d41\u6570\u636e", required=true, dataType="__File", allowMultiple=true)
    @PostMapping(value={"/batchFiles"})
    public Resp<List<FileInfo>> batchFiles(MultipartFile[] files, HttpServletRequest request) {
        if (files == null || files.length <= 0) {
            return new Resp().error("\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a");
        }
        try {
            ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
            for (MultipartFile file : files) {
                String fileName = file.getOriginalFilename();
                String contentType = file.getContentType();
                String suffix = "." + contentType.split("/")[1];
                File saveFile = this.pool.createFile(suffix);
                file.transferTo(saveFile);
                long id = this.pool.getFileId(saveFile);
                String url = "/jdcbase/prbase/file/pool/getFile/" + id + "/" + fileName;
                FileInfo data = new FileInfo();
                data.init();
                data.setName(fileName);
                data.setTitle(fileName);
                data.setPath(saveFile.getAbsolutePath());
                data.setFileMd5(DigestUtils.md5Hex((InputStream)new FileInputStream(data.getPath())));
                data.setUrl(url);
                data.setSuffix(suffix.replace(".", ""));
                data.setContentType(contentType);
                data.setSize(saveFile.length());
                String userid = "DEFAULT";
                String usertype = "DEFAULT";
                try {
                    userid = StpUtil.getLoginId().toString().substring(1);
                    usertype = StpUtil.getLoginId().toString().substring(0, 1);
                }
                catch (Exception e) {
                    System.err.println("\u672a\u767b\u5f55\u7528\u6237\u4e0a\u4f20\uff0c\u91c7\u7528\u9ed8\u8ba4userid=DEFAULT");
                }
                data.setUserid(userid);
                fileInfos.add(data);
            }
            return Resp.OK("\u4e0a\u4f20\u6210\u529f", fileInfos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Resp.ERROR(e.getMessage());
        }
    }

    @Order(value=0)
    @ApiOperation(value="\u5355\u6587\u4ef6\u4e0a\u4f20\u65b9\u6cd5-\u4fdd\u5b58\u5230\u6570\u636e\u5e93", consumes="multipart/form-data")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u6587\u4ef6\u6d41\u6570\u636e", required=true, paramType="form", dataType="__File")})
    @PostMapping(value={"/singleFilesSaveDB"})
    public Resp<FileInfo> singleFilesSaveDB(@RequestParam(value="file", required=true) MultipartFile file, HttpServletRequest request) {
        try {
            Resp<FileInfo> resp = this.singleFiles(file, request);
            FileInfo data = (FileInfo)resp.getData().insertOrUpdate(this.dao);
            return Resp.OK("\u4e0a\u4f20\u6210\u529f", data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Resp.ERROR("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @Order(value=1)
    @ApiOperation(value="\u6279\u91cf\u6587\u4ef6\u4e0a\u4f20\u65b9\u6cd5-\u4fdd\u5b58\u5230\u6570\u636e\u5e93", consumes="multipart/form-data")
    @ApiImplicitParam(name="files", value="\u6587\u4ef6\u6d41\u6570\u636e", required=true, dataType="__File", allowMultiple=true)
    @PostMapping(value={"/batchFilesSaveDB"})
    public Resp<List<FileInfo>> batchFilesSaveDB(MultipartFile[] files, HttpServletRequest request) {
        if (files == null || files.length <= 0) {
            return new Resp().error("\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a");
        }
        try {
            Resp<List<FileInfo>> resp = this.batchFiles(files, request);
            List fileInfos = resp.getData();
            fileInfos = (List)this.dao.insert(fileInfos);
            return Resp.OK("\u4e0a\u4f20\u6210\u529f", fileInfos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Resp.ERROR(e.getMessage());
        }
    }

    @ApiOperation(value="\u6587\u4ef6\u83b7\u53d6")
    @GetMapping(value={"/getFile/{id}/{name}"})
    public void getFile(@ApiParam(name="id", required=true) @PathVariable(name="id", required=true) long id, @ApiParam(name="name", required=true) @PathVariable(name="name", required=true) String name, HttpServletRequest request, HttpServletResponse response) throws IllegalStateException, IOException {
        System.out.println("id=" + id + ", name=" + name);
        String suffix = Files.getSuffix((String)name);
        File file = this.pool.getFile(id, suffix);
        byte[] fileBdata = FileUtil.readBytes((File)file);
        ServletOutputStream os = response.getOutputStream();
        os.write(fileBdata);
        os.flush();
        os.close();
    }
}

