/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.base.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.lang.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import top.xtcoder.jdcbase.base.core.Resp;
import top.xtcoder.jdcbase.base.entity.base.MimeType;

@Api(tags={"MimeType\u6a21\u5757"})
@RestController
@RequestMapping(value={"/jdcbase/prbase/mime/type"})
public class PrBaseMimeTypeController {
    @Autowired
    private Dao dao;

    @ApiOperation(value="\u6dfb\u52a0/\u7f16\u8f91")
    @PostMapping(value={"/addOrUpdate"})
    @SaCheckPermission(value={"PrRbacAdminPerm"})
    public Resp addOrUpdate(@Valid @RequestBody MimeType at) {
        MimeType data;
        Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0).and("content_type", "=", (Object)at.getContentType());
        if (Strings.isNotBlank((CharSequence)at.getId())) {
            cnd.and("id", "!=", (Object)at.getId());
        }
        if ((data = (MimeType)this.dao.fetch(MimeType.class, (Condition)cnd)) != null) {
            return Resp.ERROR("ContentType\u5df2\u5b58\u5728").data(data);
        }
        at = (MimeType)at.insertOrUpdate(this.dao);
        return Resp.OBJ_O(at);
    }

    @ApiOperation(value="\u8f6f\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Resp delete(@RequestParam(value="id") String id, HttpServletRequest request) {
        if (Strings.isBlank((CharSequence)id)) {
            return new Resp().error("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MimeType tea = (MimeType)this.dao.fetch(MimeType.class, id);
        if (tea == null) {
            return new Resp().error("\u8be5\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664\u4e86");
        }
        int num = tea.deletedSoft(this.dao);
        return Resp.OBJ_O(num);
    }

    @ApiOperation(value="byid")
    @GetMapping(value={"/byid"})
    public Resp byid(@RequestParam(value="id") String id, HttpServletRequest request) {
        if (Strings.isBlank((CharSequence)id)) {
            return new Resp().error("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MimeType tea = (MimeType)this.dao.fetch(MimeType.class, id);
        return Resp.OBJ_Q(tea);
    }

    @ApiOperation(value="ContentType\u67e5\u8be2")
    @GetMapping(value={"/byContentType"})
    public Resp byContentType(@RequestParam(value="contentType") String contentType, HttpServletRequest request) {
        if (Strings.isBlank((CharSequence)contentType)) {
            return new Resp().error("contentType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0).and("content_type", "=", (Object)contentType);
        MimeType tea = (MimeType)this.dao.fetch(MimeType.class, (Condition)cnd);
        return Resp.OBJ_Q(tea);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @SaCheckPermission(value={"PrRbacAdminPerm"})
    public Resp<List<MimeType>> list() {
        Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0);
        List list = this.dao.query(MimeType.class, (Condition)cnd.asc("sort"));
        return Resp.LIST_Q(list);
    }

    @ApiOperation(value="\u751f\u6210\u521d\u59cb\u5316\u4ee3\u7801")
    @GetMapping(value={"/genInitCode"})
    public Resp<String> genInitCode() {
        Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0);
        List list = this.dao.query(MimeType.class, null);
        String code = "String[][] mimeTypeArr = {";
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                code = code + "\t\"" + ((MimeType)list.get(i)).getContentType() + "\", \"" + ((MimeType)list.get(i)).getSuffix() + "\"";
                if (i < list.size() - 2) {
                    code = code + ",";
                }
                code = code + "\n";
            }
        }
        code = code + "}";
        System.out.println(code);
        return Resp.OBJ_Q(code);
    }
}

