/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.base.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.lang.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import top.xtcoder.jdcbase.base.core.Resp;
import top.xtcoder.jdcbase.base.entity.base.NationInfo;

@Api(tags={"\u6c11\u65cf\u6a21\u5757"})
@RestController
@RequestMapping(value={"/jdcbase/prbase/nation"})
public class PrBaseNationController {
    @Autowired
    private Dao dao;

    @ApiOperation(value="\u6dfb\u52a0/\u7f16\u8f91")
    @PostMapping(value={"/addOrUpdate"})
    @SaCheckPermission(value={"PrRbacAdminPerm"})
    public Resp<NationInfo> addOrUpdate(@Valid @RequestBody NationInfo at) {
        at = (NationInfo)at.insertOrUpdate(this.dao);
        return Resp.OBJ_O(at);
    }

    @ApiOperation(value="\u8f6f\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Resp delete(@RequestParam(value="id") String id, HttpServletRequest request) {
        if (Strings.isBlank((CharSequence)id)) {
            return new Resp().error("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        NationInfo tea = (NationInfo)this.dao.fetch(NationInfo.class, id);
        if (tea == null) {
            return new Resp().error("\u8be5\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664\u4e86");
        }
        int num = tea.deletedSoft(this.dao);
        return Resp.OBJ_O(num);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @SaCheckPermission(value={"PrRbacAdminPerm"})
    public Resp<List<NationInfo>> list() {
        Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0);
        List list = this.dao.query(NationInfo.class, (Condition)cnd.asc("sort"));
        return Resp.LIST_Q(list);
    }
}

