/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.base.controller;

import cn.hutool.core.io.FileUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.dao.util.cri.SqlExpressionGroup;
import org.nutz.filepool.FilePool;
import org.nutz.lang.Files;
import org.nutz.lang.util.NutMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import top.xtcoder.jdcbase.base.common.Funs;
import top.xtcoder.jdcbase.base.config.FileUploadConf;
import top.xtcoder.jdcbase.base.core.Resp;
import top.xtcoder.jdcbase.base.entity.system.FileInfo;
import top.xtcoder.jdcbase.base.redis.RedisCache;
import top.xtcoder.jdcbase.base.service.UploadService;
import top.xtcoder.jdcbase.base.service.chunk.FileChunkDTO;
import top.xtcoder.jdcbase.base.service.chunk.FileChunkQP;
import top.xtcoder.jdcbase.base.service.chunk.FileChunkService;
import top.xtcoder.jdcbase.base.service.chunk.FileService;
import top.xtcoder.jdcbase.base.vo.auth.file.MergeInfo;

@Api(tags={"\u901a\u7528\u6587\u4ef6\u4e0a\u4f20\u6a21\u5757"})
@RestController
@RequestMapping(value={"/jdcbase/prbase/file/upload"})
public class PrBaseUploadFileController {
    private static final Logger log = LoggerFactory.getLogger(PrBaseUploadFileController.class);
    @Autowired
    private FileUploadConf fileUploadConf;
    @Autowired
    private UploadService uploadService;
    @Autowired
    private FileService fileService;
    @Autowired
    private FileChunkService fileChunkService;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private Dao dao;
    @Autowired
    private FilePool pool;

    @Order(value=0)
    @ApiOperation(value="\u5355\u6587\u4ef6\u4e0a\u4f20\u65b9\u6cd5-\u4e0d\u4fdd\u5b58\u5230\u6570\u636e\u5e93", consumes="multipart/form-data")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u6587\u4ef6\u6d41\u6570\u636e", required=true, paramType="form", dataType="__File")})
    @PostMapping(value={"/singleFiles"})
    public Resp<FileInfo> singleFiles(@RequestParam(value="file", required=true) MultipartFile file, HttpServletRequest request) {
        try {
            String contextType = file.getContentType();
            System.out.println("contextType==" + contextType);
            String fileName = file.getOriginalFilename();
            File tmpFile = this.pool.createFile(Files.getSuffix((String)fileName));
            file.transferTo(tmpFile);
            FileInfo fileInfo = this.uploadService.upload(tmpFile, file.getOriginalFilename(), file.getOriginalFilename(), file.getContentType());
            tmpFile.deleteOnExit();
            return Resp.OK("OK", fileInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Resp.ERROR(e.getMessage());
        }
    }

    @Order(value=1)
    @ApiOperation(value="\u6279\u91cf\u6587\u4ef6\u4e0a\u4f20\u65b9\u6cd5-\u4e0d\u4fdd\u5b58\u5230\u6570\u636e\u5e93", consumes="multipart/form-data")
    @ApiImplicitParam(name="files", value="\u6587\u4ef6\u6d41\u6570\u636e", required=true, dataType="__File", allowMultiple=true)
    @PostMapping(value={"/batchFiles"})
    public Resp<List<FileInfo>> batchFiles(MultipartFile[] files, HttpServletRequest request) {
        if (files == null || files.length <= 0) {
            return new Resp().error("\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a");
        }
        try {
            ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
            for (MultipartFile file : files) {
                String fileName = file.getOriginalFilename();
                File tmpFile = this.pool.createFile(Files.getSuffix((String)fileName));
                file.transferTo(tmpFile);
                FileInfo fileInfo = this.uploadService.upload(tmpFile, file.getOriginalFilename(), file.getOriginalFilename(), file.getContentType());
                fileInfos.add(fileInfo);
                tmpFile.deleteOnExit();
            }
            return Resp.OK("\u4e0a\u4f20\u6210\u529f", fileInfos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Resp.ERROR(e.getMessage());
        }
    }

    @Order(value=2)
    @ApiOperation(value="\u5355\u6587\u4ef6\u4e0a\u4f20\u65b9\u6cd5-\u4fdd\u5b58\u5230\u6570\u636e\u5e93", consumes="multipart/form-data")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u6587\u4ef6\u6d41\u6570\u636e", required=true, paramType="form", dataType="__File")})
    @PostMapping(value={"/singleFilesSaveDB"})
    public Resp<FileInfo> singleFilesSaveDB(@RequestParam(value="file", required=true) MultipartFile file, HttpServletRequest request) {
        try {
            String fileName = file.getOriginalFilename();
            File tmpFile = this.pool.createFile(Files.getSuffix((String)fileName));
            file.transferTo(tmpFile);
            FileInfo fileInfo = this.uploadService.uploadAndSaveDB(tmpFile, file.getOriginalFilename(), file.getOriginalFilename(), file.getContentType());
            tmpFile.deleteOnExit();
            return Resp.OK("OK", fileInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Resp.ERROR(e.getMessage());
        }
    }

    @Order(value=3)
    @ApiOperation(value="\u6279\u91cf\u6587\u4ef6\u4e0a\u4f20\u65b9\u6cd5-\u4fdd\u5b58\u5230\u6570\u636e\u5e93", consumes="multipart/form-data")
    @ApiImplicitParam(name="files", value="\u6587\u4ef6\u6d41\u6570\u636e", required=true, dataType="__File", allowMultiple=true)
    @PostMapping(value={"/batchFilesSaveDB"})
    public Resp<List<FileInfo>> batchFilesSaveDB(MultipartFile[] files, HttpServletRequest request) {
        if (files == null || files.length <= 0) {
            return new Resp().error("\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a");
        }
        try {
            ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
            for (MultipartFile file : files) {
                String fileName = file.getOriginalFilename();
                File tmpFile = this.pool.createFile(Files.getSuffix((String)fileName));
                file.transferTo(tmpFile);
                FileInfo fileInfo = this.uploadService.uploadAndSaveDB(tmpFile, file.getOriginalFilename(), file.getOriginalFilename(), file.getContentType());
                fileInfos.add(fileInfo);
                tmpFile.deleteOnExit();
            }
            return Resp.OK("\u4e0a\u4f20\u6210\u529f", fileInfos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Resp.ERROR(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u901a\u8fc7\u6587\u4ef6id\u4e0b\u8f7d\u6587\u4ef6")
    @GetMapping(value={"/filedown"})
    @Order(value=4)
    public String filedown(@ApiParam(value="\u4e0b\u8f7d\u6587\u4ef6\u540d \u4e3a\u7a7a\u9ed8\u8ba4\u4e3a\u4e0a\u4f20\u65f6\u5019\u7684\u6587\u4ef6\u540d\u79f0") @RequestParam(name="outFileName", defaultValue="") String outFileName, @ApiParam(value="fileid") @RequestParam String fileid, HttpServletRequest request, HttpServletResponse response) {
        File file;
        if (Funs.isBlank(fileid)) {
            response.reset();
            response.setContentType("text/html");
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            return "<script>alert('fileid');</script>";
        }
        Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0).and("id", "=", (Object)fileid);
        FileInfo f = (FileInfo)this.dao.fetch(FileInfo.class, (Condition)cnd);
        if (f == null) {
            response.reset();
            response.setContentType("text/html");
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            return "<script>alert('\u6ca1\u6709\u627e\u5230\u8be5\u8bb0\u5f55');</script>";
        }
        String saveFilePath = f.getPath();
        String docTitle = f.getName();
        if (Funs.isBlank(saveFilePath)) {
            response.reset();
            response.setContentType("text/html");
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            return "<script>alert('\u9274\u6743\u5931\u8d25\uff0ccode\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d');</script>";
        }
        if (Funs.isNotBlank(docTitle)) {
            outFileName = docTitle;
        }
        String fileSaveName = saveFilePath;
        if (!saveFilePath.startsWith(this.fileUploadConf.getSavePath())) {
            fileSaveName = this.fileUploadConf.getSavePath() + saveFilePath;
        }
        if (!(file = new File(fileSaveName)).exists()) {
            response.reset();
            response.setContentType("text/html");
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            return "<script>alert('\u4e0b\u8f7d\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\u3010\u6587\u4ef6\u4e0d\u5b58\u5728\u3011\uff0c\u8bf7\u91cd\u65b0\u5bfc\u51fa');</script>";
        }
        String ext = FileUtil.extName((String)saveFilePath);
        if (Funs.isBlank(outFileName)) {
            outFileName = "\u5bfc\u51fa-" + Funs.getNowFullTimeNum() + "." + ext;
        }
        Funs.setDownloadHeader(request, response, outFileName);
        byte[] buff = new byte[1024];
        BufferedInputStream bis = null;
        ServletOutputStream os = null;
        try {
            os = response.getOutputStream();
            bis = new BufferedInputStream(new FileInputStream(file));
            int i = bis.read(buff);
            while (i != -1) {
                os.write(buff, 0, buff.length);
                os.flush();
                i = bis.read(buff);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @ApiOperation(value="\u6587\u4ef6\u5217\u8868")
    @PostMapping(value={"/filelist"})
    @Order(value=5)
    public Resp<NutMap> filelist(@ApiParam(value="fileids \u6587\u4ef6ID") @RequestBody List<String> fileids, HttpServletRequest request, HttpServletResponse response) {
        Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0);
        SqlExpressionGroup e = Cnd.cri().where().andInStrList("id", fileids);
        cnd.and((SqlExpression)e);
        List list = this.dao.query(FileInfo.class, (Condition)cnd);
        NutMap item = NutMap.NEW();
        item.addv("list", (Object)list);
        return Resp.OK("successful", item);
    }

    @ApiOperation(value="\u5206\u7247\u4e0a\u4f20 - \u8ffd\u52a0\u6a21\u5f0f - \u68c0\u67e5\u662f\u5426\u79d2\u4f20", notes="\u82e5\u540c\u4e00\u4e2a\u6587\u4ef6(\u4ee5md5\u4e3a\u51c6)\u5df2\u7ecf\u4e0a\u4f20\u8fc7\u4e86\uff0c\u5219\u76f4\u63a5\u8fd4\u56de")
    @GetMapping(value={"/chunk/upload"})
    public Resp<Map<String, Object>> checkChunkUpload(@Valid FileChunkQP param) {
        log.info("\u6587\u4ef6MD5:" + param.getIdentifier());
        List<FileChunkDTO> list = this.fileChunkService.listByFileMd5(param.getIdentifier());
        HashMap<String, Object> data = new HashMap<String, Object>(1);
        if (list.size() == 0) {
            data.put("uploaded", false);
            return Resp.OK("\u64cd\u4f5c\u6210\u529f", data);
        }
        if (list.get(0).getTotalChunks() == 1) {
            data.put("uploaded", true);
            data.put("url", "");
            return Resp.OK("\u64cd\u4f5c\u6210\u529f", data);
        }
        int[] uploadedFiles = new int[list.size()];
        int index = 0;
        for (FileChunkDTO fileChunkItem : list) {
            uploadedFiles[index] = fileChunkItem.getChunkNumber();
            ++index;
        }
        data.put("uploadedChunks", uploadedFiles);
        return Resp.OK("\u64cd\u4f5c\u6210\u529f", data);
    }

    @ApiOperation(value="\u5206\u7247\u4e0a\u4f20 - \u8ffd\u52a0\u6a21\u5f0f", notes="\u540e\u53f0\u5904\u7406\u4e3a\u5f80\u4e00\u4e2a\u6587\u4ef6\u91cc\u5199\u5165\uff0c\u4e0d\u7528\u5408\u5e76")
    @PostMapping(value={"/chunk/upload"})
    public Resp<String> chunkUpload(@Valid FileChunkQP param) {
        boolean flag = this.fileService.uploadFile(param);
        if (!flag) {
            return Resp.ERROR("\u4e0a\u4f20\u5931\u8d25");
        }
        return Resp.OK("\u4e0a\u4f20\u6210\u529f");
    }

    @ApiOperation(value="\u5206\u7247\u4e0a\u4f20 - \u5206\u6bb5\u6a21\u5f0f - \u4e0a\u4f20\u5206\u7247\u7684\u63a5\u53e3", notes="\u5206\u6bb5\u4e0a\u4f20\uff0c\u4e0a\u4f20\u5b8c\u4e86\u540e\u9700\u8981\u8c03\u7528\u5408\u5e76\u5408\u5e76\u6587\u4ef6")
    @PostMapping(value={"/slice/upload"})
    public Resp<String> sliceUpload(@RequestParam(value="file") @ApiParam(value="\u6587\u4ef6\u4fe1\u606f") MultipartFile file, @RequestParam(value="hash") @ApiParam(value="\u6587\u4ef6\u54c8\u5e0c\u503c") String hash, @RequestParam(value="filename") @ApiParam(value="\u6587\u4ef6\u540d") String filename, @RequestParam(value="seq") @ApiParam(value="\u5206\u7247\u5e8f\u53f7") Integer seq, @RequestParam(value="type") @ApiParam(value="\u6587\u4ef6\u7c7b\u578b") String type) {
        try {
            return this.fileChunkService.uploadSlice(file.getBytes(), hash, filename, seq, type);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Resp.ERROR("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u5206\u7247\u4e0a\u4f20 - \u5206\u6bb5\u6a21\u5f0f - \u6587\u4ef6\u5408\u5e76\u63a5\u53e3")
    @PostMapping(value={"/slice/merge"})
    public Resp<String> sliceMerge(@RequestBody MergeInfo mergeInfo) {
        if (mergeInfo != null) {
            String filename = mergeInfo.getFilename();
            String type = mergeInfo.getType();
            String hash = mergeInfo.getHash();
            return this.fileChunkService.uploadMergeSlice(filename, type, hash);
        }
        return Resp.ERROR("\u6587\u4ef6\u5408\u5e76\u5931\u8d25");
    }

    @ApiOperation(value="\u5206\u7247\u4e0a\u4f20 - \u5206\u6bb5\u6a21\u5f0f - \u68c0\u67e5\u6781\u901f\u79d2\u4f20\u63a5\u53e3")
    @GetMapping(value={"/slice/check"})
    public Resp<String> sliceCheck(@RequestParam(value="hash") String hash) {
        return this.fileChunkService.fastUploadSlice(hash);
    }
}

