/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.base.service;

import cn.dev33.satoken.stp.StpUtil;
import javax.servlet.http.HttpServletRequest;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.entity.Record;
import org.nutz.dao.entity.annotation.Table;
import org.nutz.lang.Strings;
import org.nutz.lang.random.R;
import org.nutz.lang.util.NutMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import top.xtcoder.jdcbase.base.common.Funs;
import top.xtcoder.jdcbase.base.core.Resp;
import top.xtcoder.jdcbase.base.core.UserLoginOpType;
import top.xtcoder.jdcbase.base.entity.base.AccountInfo;
import top.xtcoder.jdcbase.base.redis.PrRedisKey;
import top.xtcoder.jdcbase.base.redis.RedisCache;
import top.xtcoder.jdcbase.base.vo.auth.LoginResult;
import top.xtcoder.jdcbase.base.vo.auth.PhoneVrcodeLoginVo;
import top.xtcoder.jdcbase.base.vo.auth.PwdLoginVo;

@Service
public class AccountService {
    @Autowired
    private Dao dao;
    @Autowired
    private RedisCache redisCache;

    public <T extends AccountInfo> LoginResult pwdLogin(int type, Class<T> table, HttpServletRequest request, PwdLoginVo dto) throws Exception {
        Cnd cnd;
        String account = dto.getAccount();
        String pwd = dto.getPassword();
        String tableName = table.getAnnotation(Table.class).value();
        Record record = this.dao.fetch(tableName, (Condition)(cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0).and("account", "=", (Object)account)));
        if (record == null) {
            throw new Exception("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        AccountInfo userInfo = (AccountInfo)record.toPojo(table);
        if (!Strings.equals((String)Funs.pwdEncry(pwd, userInfo.getSalt()), (String)userInfo.getPassword())) {
            throw new Exception("\u5bc6\u7801\u9519\u8bef");
        }
        if (userInfo.getState() == UserLoginOpType.LOCK.value()) {
            throw new Exception("\u5e10\u53f7\u9501\u5b9a, \u4e0d\u80fd\u767b\u9646");
        }
        StpUtil.login((Object)Funs.getSaLoginId(type, userInfo.getId()));
        LoginResult res = new LoginResult();
        res.setAccountInfo(userInfo);
        res.setTokenInfo(StpUtil.getTokenInfo());
        return res;
    }

    public <T extends AccountInfo> NutMap phoneVrcodeLogin(Class<T> table, HttpServletRequest request, PhoneVrcodeLoginVo dto) throws Exception {
        Cnd cnd;
        String storageVrcode;
        String account = dto.getAccount();
        String vrcode = dto.getVrcode();
        if (!Strings.equals((String)vrcode, (String)(storageVrcode = (String)this.redisCache.getCacheObject(PrRedisKey.PB_PHONE_VRCODE(dto.getAccount()))))) {
            throw new Exception("\u9a8c\u8bc1\u7801\u8f93\u5165\u9519\u8bef");
        }
        String tableName = table.getAnnotation(Table.class).value();
        Record record = this.dao.fetch(tableName, (Condition)(cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0).and("account", "=", (Object)account)));
        if (record == null) {
            throw new Exception("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        AccountInfo userInfo = (AccountInfo)record.toPojo(table);
        if (userInfo.getState() == UserLoginOpType.LOCK.value()) {
            throw new Exception("\u5e10\u53f7\u9501\u5b9a, \u4e0d\u80fd\u767b\u9646");
        }
        return NutMap.NEW().addv("userInfo", (Object)userInfo).addv("tokenInfo", (Object)StpUtil.getTokenInfo());
    }

    public <T extends AccountInfo> Resp setPwd(Class<T> t, String oldPwd, String newPwd, String id) {
        if (Strings.isBlank((CharSequence)id)) {
            return new Resp().error("\u53c2\u6570\u4e0d\u80fd\u7a7a");
        }
        if (Strings.isBlank((CharSequence)oldPwd)) {
            return new Resp().error("\u65e7\u5bc6\u7801\u4e0d\u80fd\u7a7a");
        }
        if (Strings.isBlank((CharSequence)newPwd)) {
            return new Resp().error("\u65b0\u5bc6\u7801\u4e0d\u80fd\u7a7a");
        }
        AccountInfo data = (AccountInfo)this.dao.fetch(t, id);
        if (!Strings.equals((String)Funs.pwdEncry(oldPwd, data.getSalt()), (String)data.getPassword())) {
            return new Resp().error("\u65e7\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        String salt = R.captchaChar((int)4);
        data.setSalt(salt);
        data.setPassword(Funs.pwdEncry(newPwd, salt));
        int n = this.dao.update((Object)data);
        return Resp.OBJ_O(n);
    }

    public <T extends AccountInfo> Resp<T> resetPwd(Class<T> t, String newPwd, String id) {
        if (Strings.isBlank((CharSequence)id)) {
            return new Resp().error("\u53c2\u6570\u4e0d\u80fd\u7a7a");
        }
        if (Strings.isBlank((CharSequence)newPwd)) {
            return new Resp().error("\u65b0\u5bc6\u7801\u4e0d\u80fd\u7a7a");
        }
        AccountInfo data = (AccountInfo)this.dao.fetch(t, id);
        String salt = R.captchaChar((int)4);
        data.setSalt(salt);
        data.setPassword(Funs.pwdEncry(newPwd, salt));
        int n = this.dao.update((Object)data);
        if (n > 0) {
            return new Resp<AccountInfo>().ok("\u4fdd\u5b58\u6210\u529f", data);
        }
        return new Resp().error("\u4fdd\u5b58\u5931\u8d25");
    }
}

