/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.base.service;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.codec.digest.DigestUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.lang.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import top.xtcoder.jdcbase.base.common.Funs;
import top.xtcoder.jdcbase.base.config.FileUploadConf;
import top.xtcoder.jdcbase.base.entity.base.MimeType;
import top.xtcoder.jdcbase.base.entity.system.FileInfo;

@Service
public class UploadService {
    @Autowired
    private FileUploadConf fileUploadConf;
    @Autowired
    private Dao dao;

    public FileInfo uploadAndSaveDB(File file, String originalFilename, String title, String contentType) throws Exception {
        FileInfo data = this.upload(file, originalFilename, title, contentType);
        data = (FileInfo)this.dao.insertOrUpdate((Object)data);
        return data;
    }

    private String getSuffix(String contentType, String filePath) {
        String suffix = "";
        if (Strings.isNotBlank((CharSequence)contentType)) {
            Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0);
            cnd.and("content_type", "=", (Object)contentType);
            MimeType type = (MimeType)this.dao.fetch(MimeType.class, (Condition)cnd);
            if (type != null) {
                suffix = type.getSuffix();
            }
        }
        if (Strings.isBlank((CharSequence)suffix)) {
            suffix = Funs.getFileSuffix(filePath);
        }
        return suffix;
    }

    public FileInfo upload(File file, String originalFilename, String title, String contentType) throws Exception {
        String dir = this.fileUploadConf.getSavePath();
        System.out.println("dir=" + dir);
        File fileBaseDir = new File(dir);
        if (!fileBaseDir.canWrite()) {
            throw new Exception("\u4e0a\u4f20\u76ee\u5f55\u6ca1\u6709\u5199\u6743\u9650\u3002");
        }
        String ymd = Funs.getNowLocalDate();
        String fileSuffix = this.getSuffix(contentType, file.getAbsolutePath());
        String fileName = Funs.getFileNameBySm3() + fileSuffix;
        String saveDirPath = File.separator + ymd;
        String saveFilePath = saveDirPath + File.separator + fileName;
        File saveDir = new File(dir, saveDirPath);
        if (!saveDir.exists()) {
            saveDir.mkdirs();
            File f = new File(saveDirPath, "index.html");
            f.createNewFile();
        }
        File saveFile = new File(dir, saveFilePath);
        FileUtil.copy((File)file, (File)saveFile, (boolean)true);
        String url = this.fileUploadConf.getBaseUrl() + saveFilePath.replace(File.separator, "/");
        FileInfo data = new FileInfo();
        data.init();
        data.setName(originalFilename);
        data.setTitle(title);
        data.setContentType(contentType);
        data.setPath(saveFile.getAbsolutePath());
        data.setFileMd5(DigestUtils.md5Hex((InputStream)new FileInputStream(saveFile)));
        data.setUrl(url);
        data.setSuffix(fileSuffix);
        data.setSize(saveFile.length());
        String userid = "DEFAULT";
        String usertype = "DEFAULT";
        try {
            userid = StpUtil.getLoginId().toString().substring(1);
            usertype = StpUtil.getLoginId().toString().substring(0, 1);
        }
        catch (Exception e) {
            System.err.println("\u672a\u767b\u5f55\u7528\u6237\u4e0a\u4f20\uff0c\u91c7\u7528\u9ed8\u8ba4userid=DEFAULT");
        }
        data.setUserid(userid);
        return data;
    }

    public void compress(File file, File saveFile, double scale) {
        try {
            Thumbnails.of((File[])new File[]{file}).scale(scale).toFile(saveFile.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void compress(InputStream is, File saveFile, double scale) {
        try {
            Thumbnails.of((InputStream[])new InputStream[]{is}).scale(scale).toFile(saveFile.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

