/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.base.service.chunk;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.lang.Lang;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import top.xtcoder.jdcbase.base.common.Funs;
import top.xtcoder.jdcbase.base.config.FileUploadConf;
import top.xtcoder.jdcbase.base.core.CreateOp;
import top.xtcoder.jdcbase.base.core.Resp;
import top.xtcoder.jdcbase.base.entity.system.FileChunk;
import top.xtcoder.jdcbase.base.entity.system.FileInfo;
import top.xtcoder.jdcbase.base.service.chunk.FileChunkDTO;
import top.xtcoder.jdcbase.base.service.chunk.FileChunkQP;
import top.xtcoder.jdcbase.base.utils.BeanUtil;

@Service
public class FileChunkService {
    @Autowired
    private Dao dao;
    @Autowired
    private FileUploadConf conf;

    public List<FileChunkDTO> listByFileMd5(String md5) {
        List fileChunks = this.dao.query(FileChunk.class, (Condition)Cnd.where((String)"isdelete", (String)"=", (Object)0).and("md5_identifier", "=", (Object)md5));
        if (fileChunks.size() == 0) {
            return Collections.emptyList();
        }
        return BeanUtil.doListToDtoList(fileChunks, FileChunkDTO.class);
    }

    public void saveFileChunk(FileChunkQP param) {
        int result;
        FileChunk fileChunkDo = null;
        if (!param.isNew() && null == (fileChunkDo = (FileChunk)this.dao.fetch(FileChunk.class, param.getId().longValue()))) {
            throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (null == fileChunkDo) {
            fileChunkDo = new FileChunk();
        } else {
            fileChunkDo.setUpdatetime(new Date());
        }
        BeanUtils.copyProperties((Object)param, (Object)fileChunkDo, (String[])new String[]{"id"});
        fileChunkDo.setFileName(param.getFilename());
        fileChunkDo.setMd5Identifier(param.getIdentifier());
        if (param.isNew()) {
            fileChunkDo.init();
            result = this.dao.insert((Object)fileChunkDo) != null ? 1 : 0;
        } else {
            result = this.dao.update((Object)fileChunkDo);
        }
        if (0 == result) {
            throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25");
        }
        BeanUtil.doToDto(fileChunkDo, FileChunkDTO.class);
    }

    public int deleteById(Long id) {
        int num = this.dao.delete(FileChunk.class, id.longValue());
        return num;
    }

    public int delete(FileChunk fileChunk) {
        return this.dao.delete((Object)fileChunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resp<String> uploadSlice(byte[] file, String hash, String filename, Integer seq, String type) {
        RandomAccessFile raf = null;
        String BASE_DIR = this.conf.getSavePath() + File.separator;
        try {
            File dir = new File(BASE_DIR + hash);
            if (!dir.exists()) {
                dir.mkdir();
            }
            raf = new RandomAccessFile(BASE_DIR + hash + File.separator + Lang.md5((CharSequence)filename) + "." + type + seq, "rw");
            raf.write(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            Resp<String> resp = Resp.ERROR("\u4e0a\u4f20\u5931\u8d25");
            return resp;
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException iOException) {}
        }
        return Resp.OK("\u4e0a\u4f20\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Resp uploadMergeSlice(String filename, String type, String hash) {
        Resp<FileInfo> resp;
        Throwable throwable;
        FileChannel in;
        AbstractInterruptibleChannel out;
        block32: {
            block30: {
                block31: {
                    String sliceName23332;
                    String md5Filename = Lang.md5((CharSequence)filename);
                    String BASE_DIR = this.conf.getSavePath() + File.separator;
                    File dir = new File(BASE_DIR + hash);
                    if (!dir.exists()) {
                        return Resp.ERROR("\u5408\u5e76\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    }
                    out = null;
                    String savePath = BASE_DIR + File.separator + hash;
                    String saveFileName = savePath + File.separator + md5Filename + '.' + type;
                    File file = new File(saveFileName);
                    in = new RandomAccessFile(file, "rw").getChannel();
                    throwable = null;
                    int index = 1;
                    long start = 0L;
                    while (new File(sliceName23332 = saveFileName + index).exists()) {
                        out = new RandomAccessFile(sliceName23332, "r").getChannel();
                        in.transferFrom((ReadableByteChannel)((Object)out), start, start + ((FileChannel)out).size());
                        start += ((FileChannel)out).size();
                        out.close();
                        out = null;
                        FileUtil.del((String)sliceName23332);
                        ++index;
                    }
                    in.close();
                    try {
                        filename = URLUtil.decode((String)filename);
                    }
                    catch (Exception sliceName23332) {
                        // empty catch block
                    }
                    FileInfo fileInfo = new FileInfo();
                    fileInfo.init();
                    fileInfo.setTitle(filename);
                    fileInfo.setName(filename + "." + type);
                    fileInfo.setPath(file.getAbsolutePath());
                    fileInfo.setContentType(Funs.getFileContentType(file.getAbsolutePath()));
                    fileInfo.setFileMd5(DigestUtils.md5Hex((InputStream)new FileInputStream(file)));
                    fileInfo.setSize(FileUtil.size((File)file));
                    fileInfo.setSuffix(type);
                    fileInfo.setUrl(this.conf.getBaseUrl() + "/" + hash + "/" + md5Filename + "." + type);
                    if (StpUtil.isLogin()) {
                        fileInfo.setUserid(Funs.getLoginId());
                    } else {
                        fileInfo.setUserid(CreateOp.Default.value());
                    }
                    fileInfo.insertNoInit(this.dao);
                    resp = Resp.OK("\u4e0a\u4f20\u6210\u529f").data(fileInfo);
                    if (in == null) break block30;
                    if (throwable == null) break block31;
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block30;
                }
                in.close();
            }
            if (out == null) break block32;
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resp;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (in != null) {
                                if (throwable != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    in.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                }
                catch (Throwable throwable6) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable6;
                }
            }
        }
        return Resp.ERROR("\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
    }

    public Resp fastUploadSlice(String hash) {
        FileInfo fileInfo = (FileInfo)this.dao.fetch(FileInfo.class, (Condition)Cnd.where((String)"file_md5", (String)"=", (Object)hash));
        if (fileInfo != null) {
            return Resp.OK("\u6781\u901f\u79d2\u4f20\u6210\u529f", fileInfo);
        }
        return Resp.ERROR("\u6781\u901f\u79d2\u4f20\u5931\u8d25");
    }
}

