/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.base.service.chunk;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import org.nutz.dao.Dao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import top.xtcoder.jdcbase.base.config.FileUploadConf;
import top.xtcoder.jdcbase.base.entity.system.FileInfo;
import top.xtcoder.jdcbase.base.redis.RedisCache;
import top.xtcoder.jdcbase.base.service.chunk.FileChunkQP;
import top.xtcoder.jdcbase.base.service.chunk.FileChunkService;

@Service
public class FileService {
    private static final Logger log = LoggerFactory.getLogger(FileService.class);
    public static final long DEFAULT_CHUNK_SIZE = 0x1400000L;
    @Autowired
    private FileUploadConf conf;
    @Autowired
    private Dao dao;
    @Autowired
    private FileChunkService fileChunkService;
    @Autowired
    private RedisCache redisCache;

    public FileInfo uploadEnd() {
        return null;
    }

    public boolean uploadFile(FileChunkQP param) {
        boolean flag;
        if (null == param.getFile()) {
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        File savePath = new File(this.conf.getSavePath());
        if (!savePath.exists() && !(flag = savePath.mkdirs())) {
            log.error("\u4fdd\u5b58\u76ee\u5f55\u521b\u5efa\u5931\u8d25");
            return false;
        }
        String fullFileName = savePath + File.separator + param.getFilename();
        if (param.getTotalChunks() == 1) {
            return this.uploadSingleFile(fullFileName, param);
        }
        boolean flag2 = this.uploadFileByRandomAccessFile(fullFileName, param);
        if (!flag2) {
            return false;
        }
        this.fileChunkService.saveFileChunk(param);
        return true;
    }

    private boolean uploadFileByRandomAccessFile(String resultFileName, FileChunkQP param) {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(resultFileName, "rw");){
            long chunkSize = param.getChunkSize().floatValue() == 0.0f ? 0x1400000L : param.getChunkSize().longValue();
            long offset = chunkSize * (long)(param.getChunkNumber() - 1);
            randomAccessFile.seek(offset);
            randomAccessFile.write(param.getFile().getBytes());
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e);
            return false;
        }
        return true;
    }

    private boolean uploadFileByMappedByteBuffer(String resultFileName, FileChunkQP param) {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(resultFileName, "rw");
             FileChannel fileChannel = randomAccessFile.getChannel();){
            long chunkSize = param.getChunkSize().floatValue() == 0.0f ? 0x1400000L : param.getChunkSize().longValue();
            long offset = chunkSize * (long)(param.getChunkNumber() - 1);
            byte[] fileBytes = param.getFile().getBytes();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, offset, fileBytes.length);
            mappedByteBuffer.put(fileBytes);
            FileService.unmap(mappedByteBuffer);
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e);
            return false;
        }
        return true;
    }

    private boolean uploadSingleFile(String resultFileName, FileChunkQP param) {
        File saveFile = new File(resultFileName);
        try {
            param.getFile().transferTo(saveFile);
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e);
            return false;
        }
        return true;
    }

    public static void unmap(MappedByteBuffer mappedByteBuffer) {
        try {
            if (mappedByteBuffer == null) {
                return;
            }
            mappedByteBuffer.force();
            AccessController.doPrivileged(() -> {
                try {
                    Method getCleanerMethod = mappedByteBuffer.getClass().getMethod("cleaner", new Class[0]);
                    getCleanerMethod.setAccessible(true);
                }
                catch (Exception e) {
                    log.error("MappedByteBuffer \u91ca\u653e\u5931\u8d25\uff1a" + e);
                }
                System.out.println("clean MappedByteBuffer completed");
                return null;
            });
        }
        catch (Exception e) {
            log.error("unmap error:" + e);
        }
    }
}

