/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.base.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AESUtils {
    private static final String CipherMode = "AES/ECB/PKCS5Padding";
    private static final String CipherModeForWX = "AES/CBC/PKCS7Padding";
    private static final int keysize = 128;
    public static boolean initialized = true;
    private static final Charset CHARSET = Charset.forName("utf-8");
    private static final int BLOCK_SIZE = 32;

    public static void main(String[] args) {
        String iv = "XXX6CREWJmxZcb91dU7bcw==";
        String d = "EsbDObN7Mi0PGeithOpdhIN9VnSA190HSu+8vJslUEYufp01+swVGKleyVocJoAzPOcrsjKXJErN7ClInm4JAlrqCb2nC2etAAOxlRydsapxij7vQwQesigFkVRxDfodHTMrD847hVmj3/WJo+QzLti4cYT6zyuMpRD3CvP86ivXAik9lZK9LdtPMyvB5Vm/e9MqM2+1jiV8fXkSLLF/gg==";
        String sk = "1LH3BvJY4Erz6EkxacPm7A==";
        String s = AESUtils.wxDecrypt(d, sk, iv);
        System.out.println("s=" + s);
    }

    public static boolean initialize() {
        if (!initialized) {
            return false;
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        initialized = true;
        return initialized;
    }

    public static SecretKeySpec generateKey() {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128, new SecureRandom());
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String generateKeyString() {
        return AESUtils.byte2hex(AESUtils.generateKey().getEncoded());
    }

    public static byte[] encrypt(byte[] content, byte[] key) {
        try {
            Cipher cipher = Cipher.getInstance(CipherMode);
            cipher.init(1, new SecretKeySpec(key, "AES"));
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encrypt(String content, byte[] key) {
        try {
            Cipher cipher = Cipher.getInstance(CipherMode);
            cipher.init(1, new SecretKeySpec(key, "AES"));
            byte[] data = cipher.doFinal(content.getBytes("UTF-8"));
            String result = AESUtils.byte2hex(data);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encrypt(String content, String key) {
        byte[] data = null;
        try {
            data = content.getBytes("UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        data = AESUtils.encrypt(data, new SecretKeySpec(AESUtils.hex2byte(key), "AES").getEncoded());
        String result = AESUtils.byte2hex(data);
        return result;
    }

    public static byte[] decrypt(byte[] content, byte[] key) {
        try {
            Cipher cipher = Cipher.getInstance(CipherMode);
            cipher.init(2, new SecretKeySpec(key, "AES"));
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static AlgorithmParameters generateIV(byte[] iv) throws Exception {
        AlgorithmParameters params = AlgorithmParameters.getInstance("AES");
        params.init(new IvParameterSpec(iv));
        return params;
    }

    public static String decrypt(String content, String key) {
        byte[] data = null;
        try {
            data = AESUtils.hex2byte(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        data = AESUtils.decrypt(data, AESUtils.hex2byte(key));
        if (data == null) {
            return null;
        }
        String result = null;
        try {
            result = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] wxDecrypt(byte[] content, byte[] key, byte[] iv) {
        AESUtils.initialize();
        try {
            Cipher cipher = Cipher.getInstance(CipherModeForWX);
            cipher.init(2, (Key)new SecretKeySpec(key, "AES"), AESUtils.generateIV(iv));
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String wxDecrypt(String content, String sessionKey, String iv) {
        String result = "";
        try {
            byte[] resultByte = AESUtils.wxDecrypt(Base64.decodeBase64((String)content), Base64.decodeBase64((String)sessionKey), Base64.decodeBase64((String)iv));
            if (null != resultByte && resultByte.length > 0) {
                result = new String(AESUtils.PKCS7Decode(resultByte));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String decrypt(String content, byte[] key) {
        try {
            Cipher cipher = Cipher.getInstance(CipherMode);
            cipher.init(2, new SecretKeySpec(key, "AES"));
            byte[] data = cipher.doFinal(AESUtils.hex2byte(content));
            return new String(data, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String byte2hex(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int n = 0; n < b.length; ++n) {
            String tmp = Integer.toHexString(b[n] & 0xFF);
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
        }
        return sb.toString().toUpperCase();
    }

    private static String byteToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String strHex = Integer.toHexString(bytes[i]);
            if (strHex.length() > 3) {
                sb.append(strHex.substring(6));
                continue;
            }
            if (strHex.length() < 2) {
                sb.append("0" + strHex);
                continue;
            }
            sb.append(strHex);
        }
        return sb.toString();
    }

    private static byte[] hex2byte(String inputString) {
        if (inputString == null || inputString.length() < 2) {
            return new byte[0];
        }
        inputString = inputString.toLowerCase();
        int l = inputString.length() / 2;
        byte[] result = new byte[l];
        for (int i = 0; i < l; ++i) {
            String tmp = inputString.substring(2 * i, 2 * i + 2);
            result[i] = (byte)(Integer.parseInt(tmp, 16) & 0xFF);
        }
        return result;
    }

    public static String getKey() {
        try {
            KeyGenerator kg = KeyGenerator.getInstance("AES");
            kg.init(128);
            SecretKey sk = kg.generateKey();
            byte[] b = sk.getEncoded();
            String s = AESUtils.byteToHexString(b);
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] PKCS7Encode(int count) {
        int amountToPad = 32 - count % 32;
        if (amountToPad == 0) {
            amountToPad = 32;
        }
        char padChr = AESUtils.PKCS7Chr(amountToPad);
        String tmp = new String();
        for (int index = 0; index < amountToPad; ++index) {
            tmp = tmp + padChr;
        }
        return tmp.getBytes(CHARSET);
    }

    public static byte[] PKCS7Decode(byte[] decrypted) {
        byte pad = decrypted[decrypted.length - 1];
        if (pad < 1 || pad > 32) {
            pad = 0;
        }
        return Arrays.copyOfRange(decrypted, 0, decrypted.length - pad);
    }

    public static char PKCS7Chr(int a) {
        byte target = (byte)(a & 0xFF);
        return (char)target;
    }
}

