/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.base.utils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;

public class BeanUtil {
    public static <DTO> List<DTO> doListToDtoList(List<?> doList, Class<DTO> dtoClass) {
        return BeanUtil.pojoListConvert(doList, dtoClass);
    }

    public static <VO> List<VO> dtoListToVoList(List<?> dtoList, Class<VO> voClass) {
        return BeanUtil.pojoListConvert(dtoList, voClass);
    }

    public static <DTO> DTO doToDto(Object doEntity, Class<DTO> clazz) {
        return BeanUtil.doToDto(doEntity, clazz, "");
    }

    public static <DTO> DTO doToDto(Object doEntity, Class<DTO> clazz, String ... ignoreProperties) {
        if (null == doEntity || null == clazz) {
            return null;
        }
        return BeanUtil.pojoConvert(doEntity, clazz, ignoreProperties);
    }

    public static <VO> VO dtoToVo(Object dtoEntity, Class<VO> voClass, String ... ignoreProperties) {
        if (null == dtoEntity || null == voClass) {
            return null;
        }
        return BeanUtil.pojoConvert(dtoEntity, voClass, ignoreProperties);
    }

    public static <T> T copy(Object source, Class<T> targetClass) {
        return BeanUtil.pojoConvert(source, targetClass, new String[0]);
    }

    private static <T> List<T> pojoListConvert(List<?> sourceList, Class<T> targetClass) {
        if (sourceList.size() == 0 || null == targetClass) {
            return Collections.emptyList();
        }
        return sourceList.stream().map(item -> BeanUtil.pojoConvert(item, targetClass, new String[0])).collect(Collectors.toList());
    }

    private static <T> T pojoConvert(Object sourceEntity, Class<T> targetClass, String ... ignoreProperties) {
        T targetInstance;
        try {
            targetInstance = targetClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException exception) {
            return null;
        }
        if (ignoreProperties.length > 0) {
            BeanUtils.copyProperties((Object)sourceEntity, targetInstance, (String[])ignoreProperties);
        } else {
            BeanUtils.copyProperties((Object)sourceEntity, targetInstance);
        }
        return targetInstance;
    }
}

