/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.base.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.lang.Strings;

public class ChildNodeUtil {
    public static <T> List<T> list2tree(List<T> list, String idName, String pidName, String pidFirstValue, String childrenName) {
        if (list == null || list.size() <= 0) {
            return list;
        }
        try {
            Map<String, List<T>> maps = ChildNodeUtil.list2pidMap(list, idName, pidName);
            List<T> treeList = maps.get(pidFirstValue);
            ChildNodeUtil.handleTree(treeList, maps, idName, childrenName);
            return treeList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static <T> void handleTree(List<T> list, Map<String, List<T>> maps, String idName, String childrenName) throws Exception {
        if (list != null && list.size() > 0) {
            for (T item : list) {
                Map<String, Field> fields = ChildNodeUtil.getAllField(item, true);
                Field idField = fields.get(idName);
                idField.setAccessible(true);
                String idValue = (String)idField.get(item);
                List<T> children = maps.get(idValue);
                if (children == null) continue;
                ChildNodeUtil.handleTree(children, maps, idName, childrenName);
                Field childrenField = fields.get(childrenName);
                childrenField.setAccessible(true);
                childrenField.set(item, children);
            }
        }
    }

    private static <T> Map<String, List<T>> list2pidMap(List<T> list, String idName, String pidName) throws Exception {
        HashMap<String, List<T>> maps = new HashMap<String, List<T>>();
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Field> fields = ChildNodeUtil.getAllField(list.get(i), true);
            Field field = fields.get(idName);
            if (field == null) {
                throw new Exception("list\u6570\u636e\u7684\u7b2c\u3010" + i + "\u3011\u6761\u6570\u636e\u6ca1\u6709\u3010" + idName + "\u3011\u5b57\u6bb5");
            }
            Field pidField = fields.get(pidName);
            if (pidField == null) {
                throw new Exception("list\u6570\u636e\u7684\u7b2c\u3010" + i + "\u3011\u6761\u6570\u636e\u6ca1\u6709\u3010" + pidName + "\u3011\u5b57\u6bb5");
            }
            pidField.setAccessible(true);
            String pidKey = (String)pidField.get(list.get(i));
            ArrayList<T> subList = (ArrayList<T>)maps.get(pidKey);
            if (subList == null) {
                subList = new ArrayList<T>();
            }
            subList.add(list.get(i));
            maps.put(pidKey, subList);
        }
        return maps;
    }

    public static <T> Map<String, Field> getAllField(T data, boolean extend) {
        Class<?> cls = data.getClass();
        ArrayList<Field> fs = new ArrayList<Field>();
        do {
            Field[] pfs = cls.getDeclaredFields();
            fs.addAll(Arrays.asList(pfs));
            cls = cls.getSuperclass();
        } while (extend && !Strings.equals((String)cls.getName(), (String)Object.class.getName()));
        HashMap<String, Field> map = new HashMap<String, Field>();
        if (fs == null) {
            return map;
        }
        fs.forEach(f -> map.put(f.getName(), (Field)f));
        return map;
    }
}

