/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.base.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Random;
import javax.imageio.ImageIO;
import top.xtcoder.jdcbase.base.utils.FileUtils;

public class QrCodeUtils {
    private static final String CHARSET = "utf-8";
    public static final String FORMAT = "JPG";
    private static final int QRCODE_SIZE = 500;
    private static final int LOGO_WIDTH = 60;
    private static final int LOGO_HEIGHT = 60;

    public static BufferedImage createImage(String content, String logoPath, boolean needCompress) throws Exception {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, CHARSET);
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, 500, 500, hints);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        if (logoPath == null || "".equals(logoPath)) {
            return image;
        }
        QrCodeUtils.insertImage(image, logoPath, needCompress);
        return image;
    }

    private static void insertImage(BufferedImage source, String logoPath, boolean needCompress) throws IOException {
        try (InputStream inputStream = null;){
            inputStream = FileUtils.getResourceAsStream(logoPath);
            Image src = ImageIO.read(inputStream);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            if (needCompress) {
                if (width > 60) {
                    width = 60;
                }
                if (height > 60) {
                    height = 60;
                }
                Image image = src.getScaledInstance(width, height, 4);
                BufferedImage tag = new BufferedImage(width, height, 1);
                Graphics g = tag.getGraphics();
                g.drawImage(image, 0, 0, null);
                g.dispose();
                src = image;
            }
            Graphics2D graph = source.createGraphics();
            int x = (500 - width) / 2;
            int y = (500 - height) / 2;
            graph.drawImage(src, x, y, width, height, null);
            RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, width, 6.0f, 6.0f);
            graph.setStroke(new BasicStroke(3.0f));
            graph.draw(shape);
            graph.dispose();
        }
    }

    public static String encode(String content, String logoPath, String destPath, boolean needCompress) throws Exception {
        BufferedImage image = QrCodeUtils.createImage(content, logoPath, needCompress);
        QrCodeUtils.mkdirs(destPath);
        String fileName = new Random().nextInt(99999999) + "." + FORMAT.toLowerCase();
        ImageIO.write((RenderedImage)image, FORMAT, new File(destPath + "/" + fileName));
        return fileName;
    }

    public static String encode(String content, String logoPath, String destPath, String fileName, boolean needCompress) throws Exception {
        BufferedImage image = QrCodeUtils.createImage(content, logoPath, needCompress);
        QrCodeUtils.mkdirs(destPath);
        fileName = fileName.substring(0, fileName.indexOf(".") > 0 ? fileName.indexOf(".") : fileName.length()) + "." + FORMAT.toLowerCase();
        ImageIO.write((RenderedImage)image, FORMAT, new File(destPath + "/" + fileName));
        return fileName;
    }

    public static void mkdirs(String destPath) {
        File file = new File(destPath);
        if (!file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
    }

    public static String encode(String content, String logoPath, String destPath) throws Exception {
        return QrCodeUtils.encode(content, logoPath, destPath, false);
    }

    public static String encode(String content, String destPath, boolean needCompress) throws Exception {
        return QrCodeUtils.encode(content, null, destPath, needCompress);
    }

    public static String encode(String content, String destPath) throws Exception {
        return QrCodeUtils.encode(content, null, destPath, false);
    }

    public static void encode(String content, String logoPath, OutputStream output, boolean needCompress) throws Exception {
        BufferedImage image = QrCodeUtils.createImage(content, logoPath, needCompress);
        ImageIO.write((RenderedImage)image, FORMAT, output);
    }

    public static void encode(String content, OutputStream output) throws Exception {
        QrCodeUtils.encode(content, null, output, false);
    }
}

