/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.base.utils;

import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomUtil {
    private static Logger logger = LoggerFactory.getLogger(RandomUtil.class);
    private final long id;
    private final long epoch = 1524291141010L;
    private final long workerIdBits = 10L;
    private final long maxWorkerId;
    private long sequence;
    private final long sequenceBits = 12L;
    private final long workerIdShift;
    private final long timestampLeftShift;
    private final long sequenceMask;
    private long lastTimestamp;
    private static RandomUtil flowIdWorker = new RandomUtil(1L);

    public static String getUUID() {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        return uuid;
    }

    public static String getTenNumber() {
        int COUNT = 10;
        Random random = new Random();
        int num = random.nextInt(1000000000);
        String value = String.valueOf(num);
        String tenNum = "";
        if (value.length() < 10) {
            int len = 10 - value.length();
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < len; ++i) {
                sb.append("0");
            }
            tenNum = sb + value;
        } else {
            tenNum = value;
        }
        return tenNum;
    }

    public static long getId() {
        long millis = System.currentTimeMillis();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int end2 = ((Random)random).nextInt(99);
        String str = millis + String.format("%02d", end2);
        long id = new Long(str);
        return id;
    }

    public static String randomString(int strLength) {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < strLength; ++i) {
            ret.append(((Random)rnd).nextInt(10));
        }
        return ret.toString();
    }

    private RandomUtil(long id) {
        this.getClass();
        this.maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << 10;
        this.sequence = 0L;
        this.workerIdShift = this.sequenceBits = 12L;
        this.timestampLeftShift = this.sequenceBits + this.workerIdBits;
        this.getClass();
        this.sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << 12;
        this.lastTimestamp = -1L;
        if (id > this.maxWorkerId || id < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", this.maxWorkerId));
        }
        this.id = id;
    }

    public synchronized long nextId() {
        long timestamp = RandomUtil.timeGen();
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        if (timestamp < this.lastTimestamp) {
            logger.error(String.format("clock moved backwards.Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
            return -1L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.epoch << (int)this.timestampLeftShift | this.id << (int)this.workerIdShift | this.sequence;
    }

    public static RandomUtil getFlowIdInstance() {
        return flowIdWorker;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = RandomUtil.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = RandomUtil.timeGen();
        }
        return timestamp;
    }

    private static long timeGen() {
        return System.currentTimeMillis();
    }

    public static long getSystemId() {
        return RandomUtil.getFlowIdInstance().nextId();
    }

    public static String getOrderId() {
        return RandomUtil.getFlowIdInstance().nextId() + RandomUtil.randomString(6) + "";
    }

    public static void main(String[] args) {
        System.out.println("id====" + RandomUtil.getOrderId());
        System.out.println("\u5b57\u7b26\u4e32===" + RandomUtil.randomString(10));
    }
}

