/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.base.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;

public class SimilarityUtil {
    public static float hamming(String a, String b) {
        if (a == null || b == null) {
            return 0.0f;
        }
        if (a.length() != b.length()) {
            return 0.0f;
        }
        int disCount = 0;
        for (int i = 0; i < a.length(); ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            ++disCount;
        }
        return (float)disCount / (float)a.length();
    }

    public static float cos(String a, String b) {
        if (a == null || b == null) {
            return 0.0f;
        }
        Set aChar = a.chars().boxed().collect(Collectors.toSet());
        Set bChar = b.chars().boxed().collect(Collectors.toSet());
        HashMap<Integer, Integer> aMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> bMap = new HashMap<Integer, Integer>();
        for (Integer a1 : aChar) {
            aMap.put(a1, aMap.getOrDefault(a1, 0) + 1);
        }
        for (Integer b1 : bChar) {
            bMap.put(b1, bMap.getOrDefault(b1, 0) + 1);
        }
        SetUtils.SetView union = SetUtils.union(aChar, bChar);
        int[] aVec = new int[union.size()];
        int[] bVec = new int[union.size()];
        ArrayList collect = new ArrayList(union);
        for (int i = 0; i < collect.size(); ++i) {
            aVec[i] = aMap.getOrDefault(collect.get(i), 0);
            bVec[i] = bMap.getOrDefault(collect.get(i), 0);
        }
        int p1 = 0;
        for (int i = 0; i < aVec.length; ++i) {
            p1 += aVec[i] * bVec[i];
        }
        float p2 = 0.0f;
        for (int i : aVec) {
            p2 += (float)(i * i);
        }
        p2 = (float)Math.sqrt(p2);
        float p3 = 0.0f;
        for (int i : bVec) {
            p3 += (float)(i * i);
        }
        p3 = (float)Math.sqrt(p3);
        return (float)p1 / (p2 * p3);
    }

    public static float Levenshtein(String a, String b) {
        if (a == null && b == null) {
            return 1.0f;
        }
        if (a == null || b == null) {
            return 0.0f;
        }
        int editDistance = SimilarityUtil.editDis(a, b);
        return 1.0f - (float)editDistance / (float)Math.max(a.length(), b.length());
    }

    private static int editDis(String a, String b) {
        int aLen = a.length();
        int bLen = b.length();
        if (aLen == 0) {
            return aLen;
        }
        if (bLen == 0) {
            return bLen;
        }
        int[][] v = new int[aLen + 1][bLen + 1];
        for (int i = 0; i <= aLen; ++i) {
            for (int j = 0; j <= bLen; ++j) {
                v[i][j] = i == 0 ? j : (j == 0 ? i : (a.charAt(i - 1) == b.charAt(j - 1) ? v[i - 1][j - 1] : 1 + Math.min(v[i - 1][j - 1], Math.min(v[i][j - 1], v[i - 1][j]))));
            }
        }
        return v[aLen][bLen];
    }

    public static float jaccard(String a, String b) {
        Set bChar;
        if (a == null && b == null) {
            return 1.0f;
        }
        if (a == null || b == null) {
            return 0.0f;
        }
        Set aChar = a.chars().boxed().collect(Collectors.toSet());
        int intersection = SetUtils.intersection(aChar, bChar = b.chars().boxed().collect(Collectors.toSet())).size();
        if (intersection == 0) {
            return 0.0f;
        }
        int union = SetUtils.union(aChar, bChar).size();
        return (float)intersection / (float)union;
    }

    public static float SorensenDice(String a, String b) {
        Set bChars;
        if (a == null && b == null) {
            return 1.0f;
        }
        if (a == null || b == null) {
            return 0.0f;
        }
        Set aChars = a.chars().boxed().collect(Collectors.toSet());
        int intersect = SetUtils.intersection(aChars, bChars = b.chars().boxed().collect(Collectors.toSet())).size();
        if (intersect == 0) {
            return 0.0f;
        }
        int aSize = aChars.size();
        int bSize = bChars.size();
        return 2.0f * (float)intersect / (float)(aSize + bSize);
    }

    public static float simCalc(int a, String s1, String s2) {
        float sim = 0.0f;
        sim = a == 0 ? SimilarityUtil.cos(s1, s2) : (a == 1 ? SimilarityUtil.hamming(s1, s2) : (a == 2 ? SimilarityUtil.jaccard(s1, s2) : (a == 3 ? SimilarityUtil.Levenshtein(s1, s2) : (a == 4 ? SimilarityUtil.SorensenDice(s1, s2) : SimilarityUtil.cos(s1, s2)))));
        return sim;
    }

    public static void main(String[] args) {
        String oldText = "2019\u5e745\u670815\u65e5- ";
        String newText = "ong\u5e745\u670815\u65e5";
        System.out.println(SimilarityUtil.cos(oldText, newText));
        System.out.println(SimilarityUtil.Levenshtein(oldText, newText));
        System.out.println(SimilarityUtil.jaccard(oldText, newText));
        System.out.println(SimilarityUtil.SorensenDice(oldText, newText));
    }
}

