/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.rbac.auth;

import cn.dev33.satoken.stp.StpInterface;
import cn.hutool.core.collection.ListUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.beetl.sql.core.SQLManager;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import top.xtcoder.jdcbase.base.common.Funs;
import top.xtcoder.jdcbase.base.core.UserType;
import top.xtcoder.jdcbase.rbac.entity.Role;

@Component
public class StpInterfaceImpl
implements StpInterface {
    @Autowired
    private SQLManager sqlManager;

    public List<String> getPermissionList(Object loginId, String loginType) {
        int type = Funs.getLoginType();
        String id = Funs.getLoginId();
        if (type == 1000) {
            List<String> perms = this.handleAdminPerm(id);
            return perms;
        }
        return ListUtil.of((Object[])new String[]{UserType.getPermName((int)type)});
    }

    public List<String> getRoleList(Object loginId, String loginType) {
        int type = Funs.getLoginType();
        String id = Funs.getLoginId();
        if (type == 1000) {
            List<String> roles = this.handleAdminRole(id);
            return roles;
        }
        return ListUtil.of((Object[])new String[]{UserType.getRoleName((int)type)});
    }

    private List<String> handleAdminPerm(String adminid) {
        ArrayList<String> perms = new ArrayList<String>();
        perms.add("PrRbacAdminPerm");
        NutMap paras = NutMap.NEW();
        paras.addv("adminid", (Object)adminid);
        List list = this.sqlManager.select("prrbac.account.queryUserPerm", NutMap.class, (Map)paras);
        if (list != null) {
            list.forEach(item -> {
                String code = item.getString("code", "");
                perms.add(code);
                perms.addAll(this.handleHasBtns((NutMap)item));
            });
        }
        return perms;
    }

    private List<String> handleHasBtns(NutMap item) {
        String code = item.getString("code");
        ArrayList<String> perms = new ArrayList<String>();
        String hasBtns = item.getString("hasBtns");
        if (Strings.isNotBlank((CharSequence)hasBtns)) {
            String[] hasBtnsArr;
            for (String btn : hasBtnsArr = hasBtns.substring(1, hasBtns.length() - 1).split(",")) {
                if (!Strings.isNotBlank((CharSequence)btn)) continue;
                btn = btn.trim();
                btn = btn.substring(1, btn.length() - 1);
                perms.add(code + ":" + btn);
            }
        }
        return perms;
    }

    private List<String> handleAdminRole(String adminid) {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("PrRbacAdminRole");
        NutMap paras = NutMap.NEW();
        paras.addv("adminid", (Object)adminid);
        List list = this.sqlManager.select("prrbac.account.queryUserRole", Role.class, (Map)paras);
        if (list != null) {
            list.forEach(item -> {
                if (Strings.isNotBlank((CharSequence)item.getCode())) {
                    roles.add(item.getCode());
                }
            });
        }
        return roles;
    }
}

