/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.rbac.config;

import cn.hutool.core.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.lang.random.R;
import org.nutz.trans.Atom;
import org.nutz.trans.Trans;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import top.xtcoder.jdcbase.base.common.Funs;
import top.xtcoder.jdcbase.base.core.CreateOp;
import top.xtcoder.jdcbase.base.core.StateType;
import top.xtcoder.jdcbase.base.core.UserLoginOpType;
import top.xtcoder.jdcbase.base.entity.adaptor.PermMeta;
import top.xtcoder.jdcbase.rbac.entity.AdminInfo;
import top.xtcoder.jdcbase.rbac.entity.AdminRole;
import top.xtcoder.jdcbase.rbac.entity.Permission;
import top.xtcoder.jdcbase.rbac.entity.Role;
import top.xtcoder.jdcbase.rbac.entity.RolePermission;

@Component
public class PbRbacConfig {
    @Autowired
    private Dao dao;

    @PostConstruct
    public void init() {
        int count = this.dao.count(Permission.class, null);
        if (count <= 0) {
            this.initPermission();
        }
        if ((count = this.dao.count(Role.class, null)) <= 0) {
            this.initRole();
        }
        if ((count = this.dao.count(AdminInfo.class, null)) <= 0) {
            this.initAdmin();
        }
    }

    private void initPermission() {
        ArrayList<Permission> perms = new ArrayList<Permission>();
        Permission permHome = this.createPermission("0", "home", "\u9996\u9875", "adminHome", "pages/home/AdminHome", "bank", 0, null);
        perms.add(permHome);
        Permission permConfig = this.createPermission("0", "configManager", "\u5168\u5c40\u914d\u7f6e", "configManager", "", "setting", 1, null);
        perms.add(permConfig);
        perms.add(this.createPermission(permConfig.getId(), "configTypeManager", "\u914d\u7f6e\u5206\u7c7b\u7ba1\u7406", "configTypeManager", "pages/config/type/list", "", 0, CollectionUtil.newArrayList((Object[])new String[]{"\u6dfb\u52a0", "\u7f16\u8f91", "\u5220\u9664", "\u67e5\u8be2"})));
        perms.add(this.createPermission(permConfig.getId(), "configManager", "\u914d\u7f6e\u7ba1\u7406", "configManager", "pages/config/list", "", 1, CollectionUtil.newArrayList((Object[])new String[]{"\u6dfb\u52a0", "\u7f16\u8f91", "\u5220\u9664", "\u67e5\u8be2"})));
        Permission permSystem = this.createPermission("0", "systemManager", "\u7cfb\u7edf\u7ba1\u7406", "sysManager", "", "setting", 100, null);
        perms.add(permSystem);
        perms.add(this.createPermission(permSystem.getId(), "menuManager", "\u83dc\u5355\u7ba1\u7406", "permList", "pages/sys/Menu", "", 0, CollectionUtil.newArrayList((Object[])new String[]{"\u6dfb\u52a0", "\u7f16\u8f91", "\u5220\u9664", "\u67e5\u8be2"})));
        perms.add(this.createPermission(permSystem.getId(), "roleManager", "\u89d2\u8272\u7ba1\u7406", "roleList", "pages/sys/Role", "", 1, CollectionUtil.newArrayList((Object[])new String[]{"\u6dfb\u52a0", "\u7f16\u8f91", "\u5220\u9664", "\u6388\u6743", "\u67e5\u8be2"})));
        perms.add(this.createPermission(permSystem.getId(), "adminManager", "\u7ba1\u7406\u5458\u7ba1\u7406", "adminManager", "pages/sys/Admin", "", 2, CollectionUtil.newArrayList((Object[])new String[]{"\u6dfb\u52a0", "\u7f16\u8f91", "\u5220\u9664", "\u5173\u8054\u89d2\u8272", "\u67e5\u8be2"})));
        this.dao.insert(perms);
    }

    private void initRole() {
        Role role = new Role();
        role.init();
        role.setCreateId(CreateOp.Default.value());
        role.setCode("admin");
        role.setName("\u7ba1\u7406\u5458");
        role.setPow(999);
        role.setLevel(1);
        role.setState(StateType.ENABLE.value());
        ArrayList<RolePermission> rps = new ArrayList<RolePermission>();
        List perms = this.dao.query(Permission.class, null);
        for (Permission perm : perms) {
            RolePermission rp = new RolePermission();
            rp.init();
            rp.setRoleid(role.getId());
            rp.setPermid(perm.getId());
            rp.setHasBtns(perm.getBtns());
            rps.add(rp);
        }
        Trans.exec((Atom[])new Atom[]{() -> {
            this.dao.insert((Object)role);
            this.dao.insert((Object)rps);
        }});
    }

    private void initAdmin() {
        AdminInfo adminInfo = new AdminInfo();
        adminInfo.init();
        adminInfo.setAccount("admin");
        adminInfo.setSalt(R.captchaChar((int)6));
        adminInfo.setPassword(Funs.pwdEncry((String)Funs.sm3((String)"123456"), (String)adminInfo.getSalt()));
        adminInfo.setUsername("\u8d85\u7ea7\u7ba1\u7406\u5458");
        adminInfo.setState(UserLoginOpType.Normal.value());
        Role role = (Role)((Object)this.dao.fetch(Role.class, (Condition)Cnd.where((String)"code", (String)"=", (Object)"admin")));
        AdminRole ar = new AdminRole();
        ar.init();
        ar.setAdminid(adminInfo.getId());
        ar.setRoleid(role.getId());
        Trans.exec((Atom[])new Atom[]{() -> {
            this.dao.insert((Object)adminInfo);
            this.dao.insert((Object)ar);
        }});
    }

    private Permission createPermission(String pid, String code, String name, String router, String component, String icon, int sort, List<String> btns) {
        Permission perm = new Permission();
        perm.init();
        perm.setName(name);
        perm.setCode(code);
        perm.setComponentStr(component);
        perm.setCreateId(CreateOp.Default.value());
        perm.setHidden(false);
        perm.setLevel(1);
        PermMeta meta = new PermMeta();
        meta.setIcon(icon);
        meta.setBreadcrumb(true);
        meta.setNoKeepAlive(true);
        meta.setInvisible(false);
        meta.setIsdisable(false);
        perm.setMeta(meta);
        perm.setNeedAuth(true);
        perm.setRouter(router);
        perm.setPid(pid);
        perm.setSort(sort);
        perm.setState(StateType.ENABLE.value());
        perm.setBtns(btns);
        return perm;
    }
}

