/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.rbac.controller;

import cn.dev33.satoken.stp.StpUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.QueryResult;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.random.R;
import org.nutz.lang.util.NutMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import top.xtcoder.jdcbase.base.common.Funs;
import top.xtcoder.jdcbase.base.core.Resp;
import top.xtcoder.jdcbase.base.redis.PrRedisKey;
import top.xtcoder.jdcbase.base.redis.RedisCache;
import top.xtcoder.jdcbase.base.vo.auth.PwdLoginVo;
import top.xtcoder.jdcbase.rbac.entity.AdminInfo;
import top.xtcoder.jdcbase.rbac.entity.AdminRole;
import top.xtcoder.jdcbase.rbac.entity.Role;
import top.xtcoder.jdcbase.rbac.params.AdminRoleRelaParam;
import top.xtcoder.jdcbase.rbac.service.PbRbacAccountService;
import top.xtcoder.jdcbase.rbac.service.PbRbacPermissionService;
import top.xtcoder.jdcbase.rbac.vo.MenuLoginResult;
import top.xtcoder.jdcbase.rbac.vo.PermVo;

@Api(tags={"\u7ba1\u7406\u5458\u6a21\u5757"})
@RestController
@RequestMapping(value={"/jdcbase/prrbac/system/admin"})
public class PrRbacAdminController {
    private static final Logger log = LoggerFactory.getLogger(PrRbacAdminController.class);
    @Autowired
    private Dao dao;
    @Autowired
    private PbRbacAccountService accountService;
    @Autowired
    private PbRbacPermissionService permissionService;
    @Autowired
    private RedisCache redisCache;
    @Value(value="${prrbac.login.checkVrcode:true}")
    private boolean checkVrcode;

    @ApiOperation(value="\u8d26\u53f7\u5bc6\u7801\u767b\u9646")
    @PostMapping(value={"/pwdLogin"})
    public Resp<MenuLoginResult> pwdLogin(@Valid @RequestBody PwdLoginVo dto, HttpServletRequest request, HttpServletResponse response) {
        if (!this.checkVrcode) {
            log.info("\u9a8c\u8bc1\u7801\u68c0\u67e5\u5173\u95ed");
        }
        String key = PrRedisKey.PB_PHOTO_VRCODE((String)Lang.getIP((HttpServletRequest)request));
        String code = (String)this.redisCache.getCacheObject(key);
        log.info("\u53d6\u4e00\u6761=>" + key + ": " + code);
        if (this.checkVrcode && !Strings.equals((String)code, (String)dto.getVrcode())) {
            log.info("code=" + code);
            log.info("dto.getCode=" + dto.getVrcode());
            return Resp.ERROR((String)"\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        try {
            MenuLoginResult loginInfo = this.accountService.pwdLogin2(AdminInfo.class, request, dto);
            response.setHeader(StpUtil.getTokenName(), StpUtil.getTokenValue());
            return Resp.OK((String)"\u767b\u9646\u6210\u529f", (Object)((Object)loginInfo));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Resp().error(e.getMessage());
        }
    }

    @ApiOperation(value="\u5173\u8054/\u53d6\u6d88\u5173\u8054\u89d2\u8272")
    @PostMapping(value={"/roleSet"})
    public Resp<String> roleSet(@Valid @RequestBody AdminRoleRelaParam urp) {
        try {
            List AdminRoles = this.dao.query(AdminRole.class, (Condition)Cnd.where((String)"adminid", (String)"=", (Object)urp.getAdminid()));
            this.dao.delete((Object)AdminRoles);
            HashSet<String> set = new HashSet<String>();
            for (String str : urp.getRoleids()) {
                if (Strings.isBlank((CharSequence)str)) continue;
                set.add(str);
            }
            if (set != null && set.size() > 0) {
                for (String s : set) {
                    AdminRole AdminRole2 = new AdminRole();
                    AdminRole2.setRoleid(s);
                    AdminRole2.setAdminid(urp.getAdminid());
                    AdminRole2.setCreatetime(new Date());
                    AdminRole2.setUpdatetime(new Date());
                    AdminRole2.setId(Funs.getId());
                    this.dao.insert((Object)AdminRole2);
                }
            }
            return Resp.OK((String)"\u64cd\u4f5c\u6210\u529f\uff01");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Resp.ERROR((String)("\u5f02\u5e38\u4fe1\u606f[" + ex.getMessage() + "]"));
        }
    }

    @ApiOperation(value="\u67e5\u770b\u7528\u6237\u7684\u89d2\u8272")
    @GetMapping(value={"/roles"})
    public Resp<List<Role>> roles(@ApiParam(value="\u7528\u6237id \u9ed8\u8ba4\u4e3a\u5f53\u524d\u7528\u6237") @RequestParam(value="userid", defaultValue="") String userid) {
        if (Strings.isBlank((CharSequence)userid)) {
            userid = StpUtil.getLoginId().toString().substring(1);
        }
        HashSet roleIds = new HashSet();
        List rps = this.dao.query(AdminRole.class, (Condition)Cnd.where((String)"isdelete", (String)"=", (Object)0).and("userid", "=", (Object)userid));
        ArrayList<String> andInStrs = new ArrayList<String>();
        andInStrs.add("");
        rps.forEach(item -> andInStrs.add(item.getRoleid()));
        List query = this.dao.query(Role.class, (Condition)Cnd.where((String)"isdelete", (String)"=", (Object)0).and("state", "=", (Object)1).and((SqlExpression)Cnd.cri().where().andInStrList("id", andInStrs)).asc("sort"));
        return Resp.OBJ_Q((Object)query);
    }

    @ApiOperation(value="\u52a0\u8f7d\u540e\u53f0\u6846\u67b6\u6570\u636e\uff0c\u5de6\u4fa7\u83dc\u5355\uff0c\u7f51\u7ad9title, logo\u7b49")
    @GetMapping(value={"/loadLayout"})
    public Resp<NutMap> loadLayout(@ApiParam(value="\u7528\u6237id \u9ed8\u8ba4\u4e3a\u5f53\u524d\u7528\u6237") @RequestParam(name="id", defaultValue="") String id) {
        NutMap permMap = this.permissionService.getPermSetByUserid(id);
        Set permIds = (Set)permMap.getAs("permIds", Set.class);
        Map permBtnMap = (Map)permMap.getAs("permBtnMap", Map.class);
        List<PermVo> permVo = this.permissionService.loadLeftMenu(permIds, permBtnMap, "0");
        return new Resp().ok("\u83b7\u53d6\u6210\u529f").data((Object)NutMap.NEW().addv("leftMenus", permVo));
    }

    @ApiOperation(value="\u767b\u5f55\u9000\u51fa")
    @GetMapping(value={"/logout"})
    public Resp<NutMap> logout() {
        String loginId = StpUtil.getLoginId().toString();
        StpUtil.logout();
        return new Resp().ok("\u6210\u529f\u9000\u51fa").data((Object)NutMap.NEW().addv("loginId", (Object)loginId));
    }

    @ApiOperation(value="\u8d26\u53f7\u4fe1\u606f")
    @GetMapping(value={"/getInfo"})
    public Resp<NutMap> getInfo() {
        String loginId = StpUtil.getLoginId().toString().substring(1);
        String loginType = StpUtil.getLoginId().toString().substring(0, 1);
        AdminInfo teacherInfo = (AdminInfo)((Object)this.dao.fetch(AdminInfo.class, (Condition)Cnd.where((String)"id", (String)"=", (Object)loginId)));
        return new Resp().ok("\u83b7\u53d6\u7ba1\u7406\u5458\u4fe1\u606f").data((Object)teacherInfo);
    }

    @ApiOperation(value="\u8d26\u53f7\u5bc6\u7801\u91cd\u8bbe")
    @GetMapping(value={"/setPwd"})
    public Resp setPwd(@ApiParam(value="\u65e7\u5bc6\u7801(\u9700md5\u52a0\u5bc6)") @RequestParam(value="oldPwd") String oldPwd, @ApiParam(value="\u65b0\u5bc6\u7801(\u9700md5\u52a0\u5bc6)") @RequestParam(value="newPwd") String newPwd) {
        String loginId = StpUtil.getLoginId().toString().substring(1);
        String loginType = StpUtil.getLoginId().toString().substring(0, 1);
        return this.accountService.setPwd(AdminInfo.class, oldPwd, newPwd, loginId);
    }

    @ApiOperation(value="\u6dfb\u52a0\u4fe1\u606f")
    @PostMapping(value={"/addOrUpdate"})
    public Resp<AdminInfo> addOrUpdate(@Valid @RequestBody AdminInfo data) {
        int c;
        if (Strings.isNotBlank((CharSequence)data.getId()) && (c = this.dao.count(AdminInfo.class, (Condition)Cnd.where((String)"isdelete", (String)"=", (Object)0).and("id", "!=", (Object)data.getId()).and("account", "=", (Object)data.getAccount()))) > 0) {
            return Resp.ERROR((String)"\u5e10\u53f7\u5df2\u5b58\u5728");
        }
        if (Strings.isNotBlank((CharSequence)data.getPassword())) {
            data.setSalt(R.captchaChar((int)6));
            data.setPassword(Funs.pwdEncry((String)data.getPassword(), (String)data.getSalt()));
        }
        data = (AdminInfo)((Object)data.insertOrUpdate(this.dao));
        return Resp.OBJ_O((Object)((Object)data));
    }

    @ApiOperation(value="\u5220\u9664\u4fe1\u606f")
    @DeleteMapping(value={"/delete"})
    public Resp delete(@Valid @RequestParam(name="id") String id) {
        AdminInfo data = (AdminInfo)((Object)this.dao.fetch(AdminInfo.class, id));
        if (data == null) {
            return Resp.ERROR((String)"\u6570\u636e\u5df2\u88ab\u5220\u9664");
        }
        if (data.isSuper()) {
            return Resp.ERROR((String)"\u8d85\u7ea7\u7ba1\u7406\u5458\uff0c\u7981\u6b62\u5220\u9664");
        }
        int num = data.deletedSoft(this.dao);
        return Resp.OBJ_O((Object)num);
    }

    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u4fe1\u606f")
    @GetMapping(value={"/byid"})
    public Resp byid(@RequestParam(name="id") String id) {
        AdminInfo data = (AdminInfo)((Object)this.dao.fetch(AdminInfo.class, id));
        return Resp.OBJ_Q((Object)((Object)data));
    }

    @ApiOperation(value="\u5217\u8868\u4fe1\u606f")
    @GetMapping(value={"/list"})
    public Resp list(@RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="20") int limit) {
        Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0);
        Pager pager = this.dao.createPager(page, limit);
        pager.setRecordCount(this.dao.count(AdminInfo.class, (Condition)cnd));
        List list = this.dao.query(AdminInfo.class, (Condition)cnd, pager);
        return Resp.OK((String)"\u67e5\u8be2\u6210\u529f", (Object)new QueryResult(list, pager));
    }
}

