/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.rbac.controller;

import cn.dev33.satoken.annotation.SaCheckLogin;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.beetl.sql.core.SQLManager;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.QueryResult;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.lang.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import top.xtcoder.jdcbase.base.core.Resp;
import top.xtcoder.jdcbase.rbac.entity.Permission;
import top.xtcoder.jdcbase.rbac.service.PbRbacPermissionService;
import top.xtcoder.jdcbase.rbac.vo.PermVo;

@SaCheckLogin
@Api(tags={"\u6743\u9650\u83dc\u5355\u6a21\u5757"})
@RestController
@RequestMapping(value={"/jdcbase/prrbac/system/permission"})
public class PrRbacPermissionController {
    @Autowired
    private SQLManager sqlManager;
    @Autowired
    private Dao dao;
    @Autowired
    private PbRbacPermissionService permissionService;

    @ApiOperation(value="\u6dfb\u52a0/\u7f16\u8f91\u6743\u9650")
    @PostMapping(value={"/addOrUpdate"})
    public Resp<Permission> addOrUpdate(@Valid @RequestBody Permission permission) {
        permission = (Permission)((Object)permission.insertOrUpdate(this.dao));
        return Resp.OBJ_O((Object)((Object)permission));
    }

    @ApiOperation(value="\u5220\u9664\u6743\u9650")
    @DeleteMapping(value={"/delete"})
    public Resp<Integer> delete(@RequestParam(value="id") String id) {
        if (Strings.isBlank((CharSequence)id)) {
            return Resp.ERROR((String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Permission perm = (Permission)((Object)this.dao.fetch(Permission.class, id));
        if (perm.getLevel() == 1) {
            return Resp.ERROR((String)"\u7279\u6b8a\u6743\u9650\uff0c\u7981\u6b62\u5220\u9664");
        }
        int count = this.dao.count(Permission.class, (Condition)Cnd.where((String)"isdelete", (String)"=", (Object)0).and("pid", "=", (Object)id));
        if (count > 0) {
            return Resp.ERROR((String)"\u5220\u9664\u5931\u8d25,\u8be5\u6743\u9650\u4e0b\u8fd8\u6709\u5b50\u6743\u9650");
        }
        int num = this.dao.delete(Permission.class, id);
        return Resp.OBJ_O((Object)num);
    }

    @ApiOperation(value="\u6743\u9650\u5217\u8868")
    @GetMapping(value={"/list"})
    public Resp<QueryResult> list(@ApiParam(value="\u6743\u9650\u540d\u5b57-\u53ea\u652f\u63012\u7ea7") @RequestParam(name="name", required=false, defaultValue="") String name, @ApiParam(value="\u6743\u9650\u7c7b\u578b: 0\u8def\u7531\u6743\u9650 1api\u63a5\u53e3\u6743\u9650 -100\u5168\u90e8 ") @RequestParam(name="type", defaultValue="-100") int type, @ApiParam(value="\u6743\u9650\u72b6\u6001\u9ed8\u8ba4\u4e3a-100, -100\u5168\u90e8 0\u7981\u7528 1\u542f\u7528") @RequestParam(name="state", defaultValue="-100") int state) {
        Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0).and("pid", "=", (Object)"0");
        if (Strings.isNotBlank((CharSequence)name)) {
            List permissionList = this.dao.query(Permission.class, (Condition)Cnd.where((String)"name", (String)"like", (Object)("%" + name + "%")));
            ArrayList inStr = new ArrayList();
            if (permissionList.size() > 0) {
                permissionList.forEach(item -> {
                    inStr.add(item.getId());
                    if (Strings.isNotBlank((CharSequence)item.getPid())) {
                        inStr.add(item.getPid());
                    }
                });
                cnd.and((SqlExpression)Cnd.cri().where().andInStrList("id", inStr));
            }
        }
        List<PermVo> vos = this.permissionService.loadPerms(cnd, null);
        return new Resp().ok("\u83b7\u53d6\u6210\u529f", vos);
    }

    @ApiOperation(value="\u8868\u5355\u4e2d\u7684\u6743\u9650\u9009\u62e9\u5217\u8868")
    @GetMapping(value={"/formPermList"})
    public Resp<List<PermVo>> formPermList(@ApiParam(value="\u7236id") @RequestParam(name="pid", defaultValue="0") String pid) {
        List<PermVo> perms = this.permissionService.loadPerms("0", null);
        return Resp.LIST_Q(perms);
    }
}

