/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.rbac.service;

import cn.hutool.core.collection.CollectionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beetl.sql.core.SQLManager;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.json.Json;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import top.xtcoder.jdcbase.base.redis.RedisCache;
import top.xtcoder.jdcbase.rbac.entity.Permission;
import top.xtcoder.jdcbase.rbac.vo.PermVo;

@Service
public class PbRbacPermissionService {
    @Autowired
    private Dao dao;
    @Autowired
    private SQLManager sqlManager;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private RedisCache redisCache;

    public List<PermVo> loadPerms(String pid, Map<String, List<String>> permBtnMap) {
        Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0).and("pid", "=", (Object)pid);
        List list = this.dao.query(Permission.class, (Condition)cnd.asc("sort"));
        if (list == null) {
            return null;
        }
        List perms = Json.fromJsonAsList(PermVo.class, (CharSequence)Json.toJson((Object)list));
        int len = perms.size();
        for (int i = 0; i < len; ++i) {
            PermVo vo = (PermVo)((Object)perms.get(i));
            if (permBtnMap != null) {
                vo.setHasBtns(permBtnMap.get(vo.getId()));
            }
            vo.setChildren(this.loadPerms(vo.getId(), permBtnMap));
            perms.set(i, vo);
        }
        return perms;
    }

    public List<PermVo> loadPerms(Cnd cnd, Map<String, List<String>> permBtnMap) {
        List list = this.dao.query(Permission.class, (Condition)cnd.asc("sort"));
        if (list == null) {
            return null;
        }
        List perms = Json.fromJsonAsList(PermVo.class, (CharSequence)Json.toJson((Object)list));
        int len = perms.size();
        for (int i = 0; i < len; ++i) {
            PermVo vo = (PermVo)((Object)perms.get(i));
            if (permBtnMap != null) {
                vo.setHasBtns(permBtnMap.get(vo.getId()));
            }
            vo.setChildren(this.loadPerms(vo.getId(), permBtnMap));
            perms.set(i, vo);
        }
        return perms;
    }

    public NutMap getPermSetByRoleid(String roleid) {
        System.out.println("roleid==" + roleid);
        NutMap para = NutMap.NEW().addv("roleid", (Object)roleid);
        List permList = this.sqlManager.select("prrbac.account.queryRolePermid", NutMap.class, (Map)para);
        HashSet permIds = new HashSet();
        HashMap permBtnMap = new HashMap();
        permList.forEach(perm -> {
            String permid = perm.getString("permid");
            permIds.add(permid);
            if (Strings.isNotBlank((CharSequence)perm.getString("hasBtns"))) {
                List existBtns;
                List hasBtns = Json.fromJsonAsList(String.class, (CharSequence)perm.getString("hasBtns"));
                if (permBtnMap.containsKey(permid) && (existBtns = (List)permBtnMap.get(permid)) != null && existBtns.size() > 0) {
                    hasBtns.addAll(existBtns);
                    hasBtns = CollectionUtil.newArrayList((Collection)CollectionUtil.newHashSet((Collection)hasBtns));
                }
                permBtnMap.put(permid, hasBtns);
            }
        });
        return NutMap.NEW().addv("permIds", permIds).addv("permBtnMap", permBtnMap);
    }

    public NutMap getPermSetByUserid(String userid) {
        NutMap para = NutMap.NEW().addv("userid", (Object)userid);
        List permList = this.sqlManager.select("prrbac.account.queryUserPermid", NutMap.class, (Map)para);
        HashSet permIds = new HashSet();
        HashMap permBtnMap = new HashMap();
        permList.forEach(perm -> {
            String permid = perm.getString("permid");
            permIds.add(permid);
            if (Strings.isNotBlank((CharSequence)perm.getString("hasBtns"))) {
                List existBtns;
                List hasBtns = Json.fromJsonAsList(String.class, (CharSequence)perm.getString("hasBtns"));
                if (permBtnMap.containsKey(permid) && (existBtns = (List)permBtnMap.get(permid)) != null && existBtns.size() > 0) {
                    hasBtns.addAll(existBtns);
                    hasBtns = CollectionUtil.newArrayList((Collection)CollectionUtil.newHashSet((Collection)hasBtns));
                }
                permBtnMap.put(permid, hasBtns);
            }
        });
        return NutMap.NEW().addv("permIds", permIds).addv("permBtnMap", permBtnMap);
    }

    public List<PermVo> loadLeftMenu(Set<String> permIds, Map<String, List<String>> permBtnMap, String pid) {
        if (permIds == null || permIds.size() <= 0) {
            return null;
        }
        Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0).and("pid", "=", (Object)pid).and("id", "in", permIds);
        List list = this.dao.query(Permission.class, (Condition)cnd.asc("sort"));
        if (list == null) {
            return null;
        }
        List perms = Json.fromJsonAsList(PermVo.class, (CharSequence)Json.toJson((Object)list));
        int len = perms.size();
        for (int i = 0; i < len; ++i) {
            PermVo vo = (PermVo)((Object)perms.get(i));
            vo.setHasBtns(permBtnMap.get(vo.getId()));
            vo.setChildren(this.loadLeftMenu(permIds, permBtnMap, vo.getId()));
            perms.set(i, vo);
        }
        return perms;
    }
}

