/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.jdcbase.rbac.controller;

import cn.dev33.satoken.annotation.SaCheckLogin;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.pager.Pager;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import top.xtcoder.jdcbase.base.common.Funs;
import top.xtcoder.jdcbase.base.core.PageRes;
import top.xtcoder.jdcbase.base.core.Resp;
import top.xtcoder.jdcbase.base.vo.auth.PermBatch;
import top.xtcoder.jdcbase.base.vo.auth.RolePermParam;
import top.xtcoder.jdcbase.rbac.entity.AdminRole;
import top.xtcoder.jdcbase.rbac.entity.Role;
import top.xtcoder.jdcbase.rbac.entity.RolePermission;
import top.xtcoder.jdcbase.rbac.service.PbRbacPermissionService;
import top.xtcoder.jdcbase.rbac.vo.PermVo;

@SaCheckLogin
@Api(tags={"\u89d2\u8272\u6a21\u5757"})
@RestController
@RequestMapping(value={"/jdcbase/prrbac/system/role"})
public class PrRbacRoleController {
    @Autowired
    private Dao dao;
    @Autowired
    private PbRbacPermissionService permissionService;
    private Map<String, Object> permBatch = new HashMap<String, Object>();

    @ApiOperation(value="\u6dfb\u52a0/\u7f16\u8f91\u89d2\u8272")
    @PostMapping(value={"/addOrUpdate"})
    public Resp<Role> addOrUpdate(@Valid @RequestBody Role role) {
        int count;
        if (Strings.isNotBlank((CharSequence)role.getId())) {
            Role dbRole = (Role)((Object)this.dao.fetch(Role.class, role.getId()));
            if (dbRole.getLevel() == 1) {
                return Resp.ERROR((String)"\u8be5\u89d2\u8272\u7b49\u7ea7\u4e3a\u7cfb\u7edf\u56fa\u5b9a\u7684\u7279\u6b8a\u89d2\u8272\uff0c\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c");
            }
        } else {
            role.setLevel(0);
        }
        if (Strings.isNotBlank((CharSequence)role.getId()) && (count = this.dao.count(Role.class, (Condition)Cnd.where((String)"code", (String)"=", (Object)role.getCode()).and("id", "!=", (Object)role.getId()))) > 0) {
            return Resp.ERROR((String)"\u8be5\u89d2\u8272\u4ee3\u7801\u5df2\u88ab\u4f7f\u7528");
        }
        String createId = Funs.getLoginId();
        role.setCreateId(createId);
        role = (Role)((Object)role.insertOrUpdate(this.dao));
        return Resp.OBJ_O((Object)((Object)role));
    }

    @ApiOperation(value="\u5220\u9664\u89d2\u8272")
    @DeleteMapping(value={"/delete"})
    public Resp<Integer> delete(@RequestParam(value="id") String id) {
        int count = this.dao.count(AdminRole.class, (Condition)Cnd.where((String)"roleid", (String)"=", (Object)id));
        if (count > 0) {
            return Resp.ERROR((String)"\u4e0d\u80fd\u5220\u9664\uff0c\u8be5\u89d2\u8272\u5df2\u88ab\u4f7f\u7528");
        }
        Role role = (Role)((Object)this.dao.fetch(Role.class, id));
        if (role.getLevel() == 1) {
            return Resp.ERROR((String)"\u8be5\u89d2\u8272\u7b49\u7ea7\u4e3a\u7cfb\u7edf\u56fa\u5b9a\u7684\u7279\u6b8a\u89d2\u8272\uff0c\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c");
        }
        int num = role.deletedHard(this.dao);
        this.dao.clear(RolePermission.class, (Condition)Cnd.where((String)"roleid", (String)"=", (Object)id));
        return Resp.OBJ_O((Object)num);
    }

    @ApiOperation(value="\u89d2\u8272\u5217\u8868")
    @GetMapping(value={"/list"})
    public Resp<PageRes<List<Role>>> list(@ApiParam(value="\u89d2\u8272\u540d\u5b57") @RequestParam(name="name", required=false, defaultValue="") String name, @ApiParam(value="\u89d2\u8272\u72b6\u6001\u9ed8\u8ba4\u4e3a-100, -100\u5168\u90e8 0\u7981\u7528 1\u542f\u7528") @RequestParam(name="state", defaultValue="-100") int state, @ApiParam(value="\u9875\u6570") @RequestParam(name="page", defaultValue="1") int page, @ApiParam(value="\u6bcf\u9875\u663e\u793a\u6761\u6570") @RequestParam(name="limit", defaultValue="10") int limit) {
        Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0);
        if (Strings.isNotBlank((CharSequence)name)) {
            cnd.and("name", "like", (Object)("%" + name + "%"));
        }
        if (state != -100) {
            cnd.and("state", "=", (Object)state);
        }
        Pager pager = this.dao.createPager(page, limit);
        pager.setRecordCount(this.dao.count(Role.class, (Condition)cnd));
        List roles = this.dao.query(Role.class, (Condition)cnd.asc("sort"), pager);
        return Resp.LIST_P((List)roles, (Pager)pager);
    }

    @ApiOperation(value="\u7ed9\u7ba1\u7406\u5458\u5206\u914d\u89d2\u8272\u7684\u8868\u5355\u89d2\u8272\u5217\u8868")
    @GetMapping(value={"/formList"})
    public Resp formList(@ApiParam(value="\u5206\u914d\u7684\u7ba1\u7406\u5458id") @RequestParam(name="id", defaultValue="") String id) {
        Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0);
        cnd.and("state", "=", (Object)1);
        List roles = this.dao.query(Role.class, (Condition)cnd.asc("sort"));
        List adminRoles = this.dao.query(AdminRole.class, (Condition)Cnd.where((String)"adminid", (String)"=", (Object)id));
        NutMap map = NutMap.NEW();
        map.addv("roles", (Object)roles);
        map.addv("adminRoles", (Object)adminRoles);
        return Resp.OBJ_Q((Object)map);
    }

    @ApiOperation(value="\u7ed9\u89d2\u8272\u6388\u6743")
    @PostMapping(value={"/authPerm"})
    public Resp<RolePermission> authPerm(@Valid @RequestBody RolePermParam rap) {
        Cnd cnd = Cnd.where((String)"roleid", (String)"=", (Object)rap.getRoleid()).and("permid", "=", (Object)rap.getPermid());
        RolePermission rp = (RolePermission)((Object)this.dao.fetch(RolePermission.class, (Condition)cnd));
        if (rp != null) {
            this.dao.delete((Object)rp);
        }
        if (rap.getIsselect()) {
            rp = new RolePermission();
            rp.setRoleid(rap.getRoleid());
            rp.setPermid(rap.getPermid());
            rp.setHasBtns(rap.getHasBtns());
            rp.insert(this.dao);
        }
        return Resp.OBJ_O((Object)((Object)rp));
    }

    @ApiOperation(value="\u7ed9\u89d2\u8272\u6279\u91cf\u6388\u6743")
    @PostMapping(value={"/authPermBatch"})
    public Resp<List<RolePermission>> authPermBatch(@Valid @RequestBody PermBatch permBatch) {
        if (Strings.isBlank((CharSequence)permBatch.getRoleid())) {
            return Resp.ERROR((String)"\u4e0d\u80fd\u5220\u9664\uff0c\u8be5\u89d2\u8272\u5df2\u88ab\u4f7f\u7528");
        }
        String roleid = permBatch.getRoleid();
        Cnd cnd = Cnd.where((String)"roleid", (String)"=", (Object)roleid);
        this.dao.clear(RolePermission.class, (Condition)cnd);
        ArrayList lists = new ArrayList();
        permBatch.getPermids().forEach((key, item) -> {
            RolePermission rolePermission = new RolePermission();
            rolePermission.setRoleid(roleid);
            rolePermission.setPermid((String)key);
            rolePermission.setHasBtns((List<String>)item);
            rolePermission.insert(this.dao);
            lists.add(rolePermission);
        });
        return Resp.LIST_O(lists);
    }

    @ApiOperation(value="\u67e5\u770b\u89d2\u8272\u4e0b\u7684\u6743\u9650")
    @GetMapping(value={"/rolePerms"})
    public Resp<NutMap> rolePerms(@ApiParam(value="\u89d2\u8272id") @RequestParam(value="roleid") String roleid) {
        NutMap permMap = this.permissionService.getPermSetByRoleid(roleid);
        Set permIds = (Set)permMap.getAs("permIds", Set.class);
        Map permBtnMap = (Map)permMap.getAs("permBtnMap", Map.class);
        List<PermVo> menus = this.permissionService.loadPerms("0", (Map<String, List<String>>)permBtnMap);
        NutMap res = NutMap.NEW().addv("menus", menus).addv("hasKeys", (Object)permIds);
        return Resp.OBJ_Q((Object)res);
    }

    @ApiOperation(value="\u7ed9\u7528\u6237\u5206\u914d\u89d2\u8272")
    @GetMapping(value={"/setUserRole"})
    public Resp<AdminRole> setUserrole(@ApiParam(value="\u7528\u6237userid") @RequestParam(value="userid") String adminid, @ApiParam(value="\u89d2\u8272id") @RequestParam(value="roleid") String roleid) {
        Cnd cnd = Cnd.where((String)"userid", (String)"=", (Object)adminid).and("roleid", "=", (Object)roleid);
        AdminRole userRole = (AdminRole)((Object)this.dao.fetch(AdminRole.class, (Condition)cnd));
        if (userRole == null) {
            userRole = new AdminRole();
            userRole.setRoleid(roleid);
            userRole.setAdminid(adminid);
            userRole.insertOrUpdate(this.dao);
        } else {
            userRole.setRoleid(roleid);
            userRole.setAdminid(adminid);
            userRole.insertOrUpdate(this.dao);
        }
        return Resp.OBJ_O((Object)((Object)userRole));
    }

    @ApiOperation(value="\u67e5\u770b\u7528\u6237\u89d2\u8272")
    @GetMapping(value={"/userRole"})
    public Resp<AdminRole> userRole(@ApiParam(value="\u767b\u5f55\u8d26\u53f7(\u5de5\u53f7/\u5b66\u53f7) \u4e3a\u7a7a\u67e5\u770b\u5168\u90e8") @RequestParam(value="account", defaultValue="") String account, @ApiParam(value="\u89d2\u8272id \u4e3a\u7a7a\u67e5\u770b\u5168\u90e8") @RequestParam(value="roleid", defaultValue="") String roleid) {
        Cnd cnd = Cnd.where((String)"1", (String)"=", (Object)1);
        if (Strings.isNotBlank((CharSequence)account)) {
            cnd = cnd.and("userid", "=", (Object)account);
        }
        if (Strings.isNotBlank((CharSequence)roleid)) {
            cnd = cnd.and("roleid", "=", (Object)roleid);
        }
        System.out.println(cnd);
        List userRoles = this.dao.query(AdminRole.class, (Condition)cnd);
        return new Resp().ok("\u83b7\u53d6\u6210\u529f", (Object)userRoles);
    }
}

