package top.xtcoder.jdcbase.rbac.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.beetl.sql.core.SQLManager;
import org.nutz.json.Json;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.dev33.satoken.stp.StpInterface;
import cn.hutool.core.collection.ListUtil;
import top.xtcoder.jdcbase.base.common.Funs;
import top.xtcoder.jdcbase.base.core.UserType;
import top.xtcoder.jdcbase.rbac.entity.Role;

@Component
public class StpInterfaceImpl implements StpInterface{
	@Autowired
	private SQLManager sqlManager;
	
	@Override
	public List<String> getPermissionList(Object loginId, String loginType) {
		//权限
		int type = Funs.getLoginType();
		String id = Funs.getLoginId();
		if(type == UserType.Admin.type) {
			List<String> perms = handleAdminPerm(id);
			return perms;
		}else{
			return ListUtil.of(UserType.getPermName(type));
		}
	}

	@Override
	public List<String> getRoleList(Object loginId, String loginType) {
		int type = Funs.getLoginType();
		String id = Funs.getLoginId();
		if(type == UserType.Admin.type) {
			List<String> roles = handleAdminRole(id);
			return roles;
		}else{
			return ListUtil.of(UserType.getRoleName(type));
		}
	}
	
	private List<String> handleAdminPerm(String adminid) {
		List<String> perms = new ArrayList<String>();
		perms.add(UserType.Admin.permName);
		NutMap paras = NutMap.NEW();
		paras.addv("adminid", adminid);
		List<NutMap> list = sqlManager.select("prrbac.account.queryUserPerm", NutMap.class, paras);
		if(list != null) {
			list.forEach(item -> {
				String code = item.getString("code", "");
				perms.add(code);
				perms.addAll(handleHasBtns(item));
			});
		}
		return perms;
	}
	
	private List<String> handleHasBtns(NutMap item) {
		String code = item.getString("code");
		List<String> perms = new ArrayList<String>();
		String hasBtns = item.getString("hasBtns");
		if(Strings.isNotBlank(hasBtns)) {
			String[] hasBtnsArr = hasBtns.substring(1, hasBtns.length() - 1).split(",");
			for(String btn : hasBtnsArr) {
				if(Strings.isNotBlank(btn)) {
					btn = btn.trim();
					btn = btn.substring(1, btn.length() - 1);
					perms.add(code + ":" + btn);
				}
			}
		}
		return perms;
	}
	
	private List<String> handleAdminRole(String adminid) {
		List<String> roles = new ArrayList<String>();
		roles.add(UserType.Admin.roleName);
		NutMap paras = NutMap.NEW();
		paras.addv("adminid", adminid);
		List<Role> list = sqlManager.select("prrbac.account.queryUserRole", Role.class, paras);
		if(list != null) {
			list.forEach(item -> {
				if(Strings.isNotBlank(item.getCode())) {
					roles.add(item.getCode());
				}
			});
		}
		return roles;
	}
}
