package top.xtcoder.jdcbase.rbac.entity;

import org.nutz.dao.entity.annotation.ColDefine;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.entity.annotation.Column;
import org.nutz.dao.entity.annotation.Comment;
import org.nutz.dao.entity.annotation.Index;
import org.nutz.dao.entity.annotation.Table;
import org.nutz.dao.entity.annotation.TableIndexes;

import com.alibaba.excel.annotation.ExcelProperty;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import top.xtcoder.jdcbase.base.entity.base.AccountInfo;

@Table("pb_admin_info")
@ApiModel("管理员基本信息")
@Comment("管理员基本信息表")
@TableIndexes({
        @Index(fields = {"account"}, unique = true)
})
public class AdminInfo extends AccountInfo {
    @Column("username")
    @ColDefine(type = ColType.TEXT)
    @Comment(value = "姓名")
    @ApiModelProperty(value = "姓名")
    @ExcelProperty("姓名")
    private String username;
    
    @Column("nickname")
    @ColDefine(type = ColType.TEXT)
    @Comment(value = "昵称")
    @ApiModelProperty(value = "昵称")
    @ExcelProperty("昵称")
    private String nickname;

    @Column("depid")
    @ColDefine(type = ColType.TEXT)
    @Comment(value = "部门id")
    @ApiModelProperty(value = "部门id")
    @ExcelProperty("部门id")
    private String depid;
    
    @Column("sex")
    @ColDefine(type = ColType.INT, width = 1)
    @Comment(value = "性别:[1男   2女]")
    @ApiModelProperty(value = "性别:[1男   2女]")
    private int sex;
    
    @Column("is_super")
    @ColDefine(type = ColType.BOOLEAN)
    @Comment(value = "是否为超级管理员： 超级管理员系统自动生成，禁止删除")
    @ApiModelProperty(value = "是否为超级管理员： 超级管理员系统自动生成，禁止删除")
    private boolean isSuper;

    @Column("email")
    @ColDefine(type = ColType.TEXT)
    @Comment(value = "电子邮件")
    @ApiModelProperty(value = "电子邮件")
    @ExcelProperty("电子邮件")
    private String email;

    @Column("portrait_url")
    @ColDefine(type = ColType.TEXT)
    @Comment(value = "头像")
    @ApiModelProperty(value = "头像")
    private String portraitUrl;

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getNickname() {
		return nickname;
	}

	public void setNickname(String nickname) {
		this.nickname = nickname;
	}

	public String getDepid() {
		return depid;
	}

	public void setDepid(String depid) {
		this.depid = depid;
	}

	public int getSex() {
		return sex;
	}

	public void setSex(int sex) {
		this.sex = sex;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getPortraitUrl() {
		return portraitUrl;
	}

	public void setPortraitUrl(String portraitUrl) {
		this.portraitUrl = portraitUrl;
	}

	public boolean isSuper() {
		return isSuper;
	}

	public void setSuper(boolean isSuper) {
		this.isSuper = isSuper;
	}
}