package top.xtcoder.jdcbase.rbac.entity;

import org.nutz.dao.entity.annotation.ColDefine;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.entity.annotation.Column;
import org.nutz.dao.entity.annotation.Comment;
import org.nutz.dao.entity.annotation.Table;

import io.swagger.annotations.ApiModel;
import top.xtcoder.jdcbase.base.entity.BaseEntity;

@Table("pb_admin_role")
@ApiModel("管理员角色")
@Comment("管理员角色")
public class AdminRole extends BaseEntity{
	@Column("roleid")
	@ColDefine(notNull=true, type=ColType.VARCHAR, width=32)
	@Comment(value="角色ID")
	private String roleid;
	
	@Column("adminid")
	@ColDefine(notNull=true, type=ColType.VARCHAR, width=32)
	@Comment(value="管理员ID")
	private String adminid;

	public String getRoleid() {
		return roleid;
	}

	public void setRoleid(String roleid) {
		this.roleid = roleid;
	}

	public String getAdminid() {
		return adminid;
	}

	public void setAdminid(String adminid) {
		this.adminid = adminid;
	}
}
