package top.xtcoder.jdcbase.rbac.entity;
import javax.validation.constraints.NotBlank;

import org.nutz.dao.entity.annotation.ColDefine;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.entity.annotation.Column;
import org.nutz.dao.entity.annotation.Comment;
import org.nutz.dao.entity.annotation.Default;
import org.nutz.dao.entity.annotation.Table;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import top.xtcoder.jdcbase.base.entity.BaseEntity;

@Table("pb_role")
@ApiModel("角色表")
@Comment("角色")
public class Role extends BaseEntity {
	
	@Column("name")
	@ColDefine(type=ColType.VARCHAR, width=50)
	@Comment(value="名称")
	@ApiModelProperty(value="名称")
	@NotBlank(message =  "名称不能为空")
	private String name;
	
	@Column("code")
	@ColDefine(type=ColType.VARCHAR, width=50)
	@Comment(value="角色代码 唯一任意字母串")
	@ApiModelProperty(value="角色代码 唯一任意字母串")
	@NotBlank(message =  "角色代码不能为空")
	private String code;
	
	@Column("create_id")
	@ColDefine(type=ColType.VARCHAR, width=32)
	@Comment(value="创建人ID")
	@ApiModelProperty(value="创建人ID")
	private String createId;
	
	@Column("sort")
	@ColDefine(type=ColType.INT, width=3)
	@Comment(value="排序")
	@ApiModelProperty(value="排序")
	private int sort;
	
	@Column("level")
	@ColDefine(type=ColType.INT, width=3)
	@Comment(value="角色级别： 0普通角色 1系统固定角色，禁止删除")
	@ApiModelProperty(value="角色级别： 0普通角色 1系统固定角色，禁止删除")
	private int level;
	
	@Column("remark")
	@ColDefine(type=ColType.VARCHAR, width=500)
	@Comment(value="备注 也就是描述")
	@ApiModelProperty(value="备注 也就是描述")
	private String remark;
	
	@Column("login_success_url")
	@ColDefine(type=ColType.TEXT)
	@Comment(value="登录成功后跳转的地址/路由")
	@ApiModelProperty(value="登录成功后跳转的地址/路由")
	private String loginSuccessUrl;
	
	@Column("type")
	@ColDefine(type=ColType.INT)
	@Comment(value="类型，根据具体系统自定义，比如0为后台角色，1为教师角色类似的")
	@ApiModelProperty(value="类型，根据具体系统自定义，比如0为后台角色，1为教师角色类似的")
	private int type;
	
	@Column("state")
	@ColDefine(type=ColType.INT, width=3)
	@Comment(value="状态 0禁用 1 启用")
	@ApiModelProperty(value="状态 0禁用 1 启用")
	private int state;
	
	

	@Column("pow")
	@ColDefine(type=ColType.INT, width=3)
	@Comment(value="角色权重 用于角色分配管理，权重大的可以操作比它权重小的角色")
	@ApiModelProperty(value="角色权重 用于角色分配管理，权重大的可以操作比它权重小的角色")
	@Default("0")
	private int pow;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getCreateId() {
		return createId;
	}

	public void setCreateId(String createId) {
		this.createId = createId;
	}

	public int getSort() {
		return sort;
	}

	public void setSort(int sort) {
		this.sort = sort;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public int getState() {
		return state;
	}

	public void setState(int state) {
		this.state = state;
	}

	public int getPow() {
		return pow;
	}

	public void setPow(int pow) {
		this.pow = pow;
	}

	public int getLevel() {
		return level;
	}

	public void setLevel(int level) {
		this.level = level;
	}

	public String getLoginSuccessUrl() {
		return loginSuccessUrl;
	}

	public void setLoginSuccessUrl(String loginSuccessUrl) {
		this.loginSuccessUrl = loginSuccessUrl;
	}

	public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
	}
}
