package top.xtcoder.jdcbase.rbac.entity;

import java.util.List;

import org.nutz.dao.entity.annotation.ColDefine;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.entity.annotation.Column;
import org.nutz.dao.entity.annotation.Comment;
import org.nutz.dao.entity.annotation.Default;
import org.nutz.dao.entity.annotation.Table;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import top.xtcoder.jdcbase.base.entity.BaseEntity;
import top.xtcoder.jdcbase.base.entity.adaptor.ListStrAdaptor;

@Table("pb_role_permission")
@Comment("角色权限")
@ApiModel("角色权限")
public class RolePermission extends BaseEntity{
	
	@Column("roleid")
	@ColDefine(notNull=true, type=ColType.VARCHAR, width=32)
	@Comment(value="角色ID")
	private String roleid;
	
	@Column("permid")
	@ColDefine(notNull=true, type=ColType.VARCHAR, width=32)
	@Comment(value="权限ID")
	private String permid;
	
	@Column("has_btns")
	@ColDefine(type=ColType.TEXT, adaptor = ListStrAdaptor.class)
	@Comment(value="该角色拥有的菜单按钮")
	@ApiModelProperty("该角色拥有的菜单按钮")
	private List<String> hasBtns;
	
	public String getRoleid() {
		return roleid;
	}
	public void setRoleid(String roleid) {
		this.roleid = roleid;
	}
	public String getPermid() {
		return permid;
	}
	public void setPermid(String permid) {
		this.permid = permid;
	}
	public List<String> getHasBtns() {
		return hasBtns;
	}
	public void setHasBtns(List<String> hasBtns) {
		this.hasBtns = hasBtns;
	}
}
