package top.xtcoder.jdcbase.rbac.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.beetl.sql.core.SQLManager;
import org.nutz.dao.Cnd;
import org.nutz.dao.Dao;
import org.nutz.dao.util.cri.SqlExpressionGroup;
import org.nutz.json.Json;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import cn.hutool.core.collection.CollectionUtil;
import top.xtcoder.jdcbase.base.redis.RedisCache;
import top.xtcoder.jdcbase.rbac.entity.Permission;
import top.xtcoder.jdcbase.rbac.vo.PermVo;

@Service
public class PbRbacPermissionService {
	@Autowired
	private Dao dao;
	
	@Autowired
	private SQLManager sqlManager;
	
	@Autowired
	private RedisTemplate<String, Object> redisTemplate;
	
	@Autowired
	private RedisCache redisCache;
	
	/**
	 * 加载权限数据
	 * @param pid
	 * @return
	 */
	public List<PermVo> loadPerms(String pid,
								  Map<String, List<String>> permBtnMap){
		Cnd cnd = Cnd.where("isdelete", "=", 0)
			.and("pid",  "=", pid);
		List<Permission> list = dao.query(Permission.class, cnd.asc("sort"));
		if(list == null) {
			return null;
		}
		List<PermVo> perms = Json.fromJsonAsList(PermVo.class, Json.toJson(list));
		for(int i = 0, len = perms.size(); i < len; i ++) {
			PermVo vo = perms.get(i);
			if(permBtnMap != null) {
				vo.setHasBtns(permBtnMap.get(vo.getId()));
			}
			vo.setChildren(loadPerms(vo.getId(), permBtnMap));
			perms.set(i, vo);
		}
		return perms;
	}

	public List<PermVo> loadPerms(Cnd cnd,
								  Map<String, List<String>> permBtnMap){
		List<Permission> list = dao.query(Permission.class, cnd.asc("sort"));
		if(list == null) {
			return null;
		}
		List<PermVo> perms = Json.fromJsonAsList(PermVo.class, Json.toJson(list));
		for(int i = 0, len = perms.size(); i < len; i ++) {
			PermVo vo = perms.get(i);
			if(permBtnMap != null) {
				vo.setHasBtns(permBtnMap.get(vo.getId()));
			}
			vo.setChildren(loadPerms(vo.getId(), permBtnMap));
			perms.set(i, vo);
		}
		return perms;
	}
	/**
	 * 根据角色id获取权限授权的权限
	 * @param roleid
	 * @return { 
	 * 		permIds: 权限菜单的IDs, 
	 * 		permBtnMap: 权限菜单的按钮
	 * }
	 */
	public NutMap getPermSetByRoleid(String roleid){
		System.out.println("roleid=="+roleid);
		NutMap para = NutMap.NEW().addv("roleid", roleid);
		List<NutMap> permList = sqlManager.select("prrbac.account.queryRolePermid", NutMap.class, para);
		Set<String> permIds = new HashSet();
		Map<String, List<String>> permBtnMap = new HashMap<>();
		permList.forEach(perm -> {
			String permid = perm.getString("permid");
			permIds.add(permid);
			
			if(Strings.isNotBlank(perm.getString("hasBtns"))) {
				List<String> hasBtns = Json.fromJsonAsList(String.class,  perm.getString("hasBtns"));
				if(permBtnMap.containsKey(permid)) {
					List<String> existBtns = permBtnMap.get(permid);
					if(existBtns != null && existBtns.size() > 0) {
						hasBtns.addAll(existBtns);
						hasBtns = CollectionUtil.newArrayList(CollectionUtil.newHashSet(hasBtns));
					}
				}
				permBtnMap.put(permid, hasBtns);
			}
		});
		return NutMap.NEW()
			.addv("permIds", permIds)
			.addv("permBtnMap", permBtnMap);
	}
	
	/**
	 * 获取用户可用的权限id和btns
	 * @param userid
	 * @return { 
	 * 		permIds: 权限菜单的IDs, 
	 * 		permBtnMap: 权限菜单的按钮
	 * }
	 */
	public NutMap getPermSetByUserid(int type, String userid){
		NutMap para = NutMap.NEW()
				.addv("userid", userid);
		List<NutMap> permList = sqlManager.select("prrbac.account.queryUserPermid", NutMap.class, para);
		Set<String> permIds = new HashSet();
		Map<String, List<String>> permBtnMap = new HashMap<>();
		permList.forEach(perm -> {
			String permid = perm.getString("permid");
			permIds.add(permid);
			
			if(Strings.isNotBlank(perm.getString("hasBtns"))) {
				List<String> hasBtns = Json.fromJsonAsList(String.class,  perm.getString("hasBtns"));
				if(permBtnMap.containsKey(permid)) {
					List<String> existBtns = permBtnMap.get(permid);
					if(existBtns != null && existBtns.size() > 0) {
						hasBtns.addAll(existBtns);
						hasBtns = CollectionUtil.newArrayList(CollectionUtil.newHashSet(hasBtns));
					}
				}
				permBtnMap.put(permid, hasBtns);
			}
		});
		return NutMap.NEW()
			.addv("permIds", permIds)
			.addv("permBtnMap", permBtnMap);
	}
	
	/**
	 * 加载左侧菜单
	 * @param pid
	 * @param permSet 拥有的权限集合
	 * @return
	 */
	public List<PermVo> loadLeftMenu(
			Set<String> permIds,
			Map<String, List<String>> permBtnMap,
			String pid){
		if(permIds == null || permIds.size() <= 0) {
			return null;
		}
		
		Cnd cnd = Cnd.where("isdelete", "=", 0)
			.and("pid",  "=", pid)
			.and("state",  "=", 1)
			.and("id", "in", permIds);
		
		List<Permission> list = dao.query(Permission.class, cnd.asc("sort"));
		if(list == null) {
			return null;
		}
		List<PermVo> perms = Json.fromJsonAsList(PermVo.class, Json.toJson(list));
		for(int i = 0, len = perms.size(); i < len; i ++) {
			PermVo vo = perms.get(i);
			
			vo.setHasBtns(permBtnMap.get(vo.getId()));
			vo.setChildren(loadLeftMenu(permIds, permBtnMap, vo.getId()));
			perms.set(i, vo);
		}
		return perms;
	}
}