package top.xtcoder.jdcbase.rbac.utils;

import org.nutz.dao.Dao;

import top.xtcoder.jdcbase.rbac.entity.Role;

/**
 * 角色工具
 * @author xiangtao
 *
 */
public class RoleUtil {
	/**
	 * 生成角色
	 * @param dao 数据库操作DAO实体
	 * @param code 角色代码
	 * @param name 角色名称
	 * @param level 角色级别
	 * @param pow 角色权重 用于角色分配管理，权重大的可以分配比它权重小的角色
	 */
	public static void genSysRole(Dao dao, 
			String code, 
			String name, 
			int level,
			int pow) {
		Role role = new Role();
		role.init();
		role.setId(code);
		role.setCode(code);
		role.setName(name);
		role.setState(1);
		role.setLevel(level);
		role.setRemark("系统自动生成角色");
		role.setSort(0);
		role.setPow(pow);
		role.insert(dao);
	}
}
