/*
 * Decompiled with CFR 0.152.
 */
package top.yqingyu.httpserver.compoment;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicHeaderValueFormatter;
import org.apache.hc.core5.http.message.BasicHeaderValueParser;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.TextUtils;
import top.yqingyu.common.utils.YamlUtil;

public class ContentType
implements Serializable {
    private static final long serialVersionUID = -7768694718232371896L;
    private String adviceStatusCode;
    private static final String CHARSET = "charset";
    public static final ContentType APPLICATION_ATOM_XML = ContentType.create("application/atom+xml", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_FORM_URLENCODED = ContentType.create("application/x-www-form-urlencoded", StandardCharsets.ISO_8859_1);
    public static final ContentType APPLICATION_JSON = ContentType.create("application/json", StandardCharsets.UTF_8);
    public static final ContentType TEXT_MARKDOWN = ContentType.create("text/markdown", StandardCharsets.UTF_8);
    public static final ContentType TEXT_XML = ContentType.create("text/xml", StandardCharsets.UTF_8);
    public static final ContentType TEXT_HTML = ContentType.create("text/html", StandardCharsets.UTF_8);
    public static final ContentType TEXT_CSS = ContentType.create("text/css", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_JS = ContentType.create("application/javascript", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_PDF = ContentType.create("application/pdf", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_XML = ContentType.create("application/xml", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_OCTET_STREAM = ContentType.create("application/octet-stream", (Charset)null);
    public static final ContentType IMAGE_BMP = ContentType.create("image/bmp");
    public static final ContentType IMAGE_GIF = ContentType.create("image/gif");
    public static final ContentType IMAGE_JPEG = ContentType.create("image/jpeg");
    public static final ContentType IMAGE_PNG = ContentType.create("image/png");
    public static final ContentType IMAGE_X_ICON = ContentType.create("image/x-icon");
    public static final ContentType IMAGE_SVG = ContentType.create("image/svg+xml");
    public static final ContentType IMAGE_TIFF = ContentType.create("image/tiff");
    public static final ContentType IMAGE_WEBP = ContentType.create("image/webp");
    public static final ContentType VIDEO_MP4 = ContentType.create("video/mp4");
    public static final ContentType VIDEO_MPEG4 = ContentType.create("video/mpeg4");
    public static final ContentType VIDEO_WMV = ContentType.create("video/x-ms-wmv");
    public static final ContentType VIDEO_AVI = ContentType.create("video/avi");
    public static final ContentType VIDEO_WEBM = ContentType.create("video/webm");
    public static final ContentType AUDIO_MP3 = ContentType.create("audio/mp3");
    public static final ContentType MULTIPART_FORM_DATA = ContentType.create("multipart/form-data", StandardCharsets.ISO_8859_1);
    public static final ContentType MULTIPART_MIXED = ContentType.create("multipart/mixed", StandardCharsets.ISO_8859_1);
    public static final ContentType MULTIPART_RELATED = ContentType.create("multipart/related", StandardCharsets.ISO_8859_1);
    public static final ContentType TEXT_PLAIN = ContentType.create("text/plain", StandardCharsets.UTF_8);
    public static final ContentType TEXT_EVENT_STREAM = ContentType.create("text/event-stream", StandardCharsets.UTF_8);
    public static final ContentType WILDCARD = ContentType.create("*/*", (Charset)null);
    private static final NameValuePair[] EMPTY_NAME_VALUE_PAIR_ARRAY = new NameValuePair[0];
    public static final ContentType DEFAULT_TEXT = TEXT_PLAIN;
    public static final ContentType DEFAULT_BINARY = APPLICATION_OCTET_STREAM;
    private final String mimeType;
    private final Charset charset;
    private final NameValuePair[] params;

    public String getAdviceStatusCode() {
        return this.adviceStatusCode;
    }

    public ContentType setAdviceStatusCode(String adviceStatusCode) {
        this.adviceStatusCode = adviceStatusCode;
        return this;
    }

    ContentType(String mimeType, Charset charset) {
        this.mimeType = mimeType;
        this.charset = charset;
        this.params = null;
    }

    ContentType(String mimeType, Charset charset, NameValuePair[] params) {
        this.mimeType = mimeType;
        this.charset = charset;
        this.params = params;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getParameter(String name) {
        Args.notEmpty((CharSequence)name, (String)"Parameter name");
        if (this.params == null) {
            return null;
        }
        for (NameValuePair param : this.params) {
            if (!param.getName().equalsIgnoreCase(name)) continue;
            return param.getValue();
        }
        return null;
    }

    public String toString() {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.append(this.mimeType);
        if (this.params != null) {
            buf.append("; ");
            BasicHeaderValueFormatter.INSTANCE.formatParameters(buf, this.params, false);
        } else if (this.charset != null) {
            buf.append("; charset=");
            buf.append(this.charset.name());
        }
        return buf.toString();
    }

    private static boolean valid(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != '\"' && ch != ',' && ch != ';') continue;
            return false;
        }
        return true;
    }

    public static ContentType create(String mimeType, Charset charset) {
        String normalizedMimeType = ((String)Args.notBlank((CharSequence)mimeType, (String)"MIME type")).toLowerCase(Locale.ROOT);
        Args.check((boolean)ContentType.valid(normalizedMimeType), (String)"MIME type may not contain reserved characters");
        return new ContentType(normalizedMimeType, charset);
    }

    public static ContentType create(String mimeType) {
        return ContentType.create(mimeType, (Charset)null);
    }

    public static ContentType create(String mimeType, String charset) throws UnsupportedCharsetException {
        return ContentType.create(mimeType, !TextUtils.isBlank((CharSequence)charset) ? Charset.forName(charset) : null);
    }

    private static ContentType create(HeaderElement helem, boolean strict) {
        String mimeType = helem.getName();
        if (TextUtils.isBlank((CharSequence)mimeType)) {
            return null;
        }
        return ContentType.create(helem.getName(), helem.getParameters(), strict);
    }

    private static ContentType create(String mimeType, NameValuePair[] params, boolean strict) {
        Charset charset = null;
        if (params != null) {
            for (NameValuePair param : params) {
                if (!param.getName().equalsIgnoreCase(CHARSET)) continue;
                String s = param.getValue();
                if (TextUtils.isBlank((CharSequence)s)) break;
                try {
                    charset = Charset.forName(s);
                    break;
                }
                catch (UnsupportedCharsetException ex) {
                    if (!strict) break;
                    throw ex;
                }
            }
        }
        return new ContentType(mimeType, charset, params != null && params.length > 0 ? params : null);
    }

    public static ContentType parseContentType(String resourceUrl) {
        String[] s = YamlUtil.isWindows() ? resourceUrl.split("\\\\") : resourceUrl.split("/");
        String fileName = s[s.length - 1];
        String[] extendName = fileName.split("[.]");
        if (extendName.length == 1) {
            return TEXT_HTML;
        }
        String code = "304";
        return switch (extendName[extendName.length - 1]) {
            case "js" -> APPLICATION_JS.setAdviceStatusCode(code);
            case "css" -> TEXT_CSS.setAdviceStatusCode(code);
            case "png" -> IMAGE_PNG.setAdviceStatusCode(code);
            case "jpg", "jpeg" -> IMAGE_JPEG.setAdviceStatusCode(code);
            case "gif" -> IMAGE_GIF.setAdviceStatusCode(code);
            case "ico" -> IMAGE_X_ICON.setAdviceStatusCode(code);
            case "html", "htm" -> TEXT_HTML.setAdviceStatusCode(code);
            case "pdf" -> APPLICATION_PDF;
            case "md" -> TEXT_MARKDOWN;
            case "webp" -> IMAGE_WEBP;
            case "txt", "java", "yml", "yaml", "xml", "properties" -> TEXT_PLAIN;
            case "m4a", "m4v", "mp4" -> VIDEO_MP4;
            case "doc", "docx", "xlsx", "xls", "ppt", "pptx", "exe", "apk", "msi", "rpm", "zip", "rar", "7z", "gz", "mkv", "iso", "srt", "ass", "torrent" -> APPLICATION_OCTET_STREAM;
            case "mp3" -> AUDIO_MP3;
            case "avi" -> VIDEO_AVI;
            case "webm" -> VIDEO_WEBM;
            case "wmv" -> VIDEO_WMV;
            default -> TEXT_HTML;
        };
    }

    public static ContentType create(String mimeType, NameValuePair ... params) throws UnsupportedCharsetException {
        String type = ((String)Args.notBlank((CharSequence)mimeType, (String)"MIME type")).toLowerCase(Locale.ROOT);
        Args.check((boolean)ContentType.valid(type), (String)"MIME type may not contain reserved characters");
        return ContentType.create(mimeType, params, true);
    }

    public static ContentType parse(CharSequence s) throws UnsupportedCharsetException {
        return ContentType.parse(s, true);
    }

    public static ContentType parseLenient(CharSequence s) throws UnsupportedCharsetException {
        return ContentType.parse(s, false);
    }

    private static ContentType parse(CharSequence s, boolean strict) throws UnsupportedCharsetException {
        if (TextUtils.isBlank((CharSequence)s)) {
            return null;
        }
        ParserCursor cursor = new ParserCursor(0, s.length());
        HeaderElement[] elements = BasicHeaderValueParser.INSTANCE.parseElements(s, cursor);
        if (elements.length > 0) {
            return ContentType.create(elements[0], strict);
        }
        return null;
    }

    public ContentType withCharset(Charset charset) {
        return ContentType.create(this.getMimeType(), charset);
    }

    public ContentType withCharset(String charset) {
        return ContentType.create(this.getMimeType(), charset);
    }

    public ContentType withParameters(NameValuePair ... params) throws UnsupportedCharsetException {
        if (params.length == 0) {
            return this;
        }
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        if (this.params != null) {
            for (NameValuePair param : this.params) {
                paramMap.put(param.getName(), param.getValue());
            }
        }
        for (NameValuePair param : params) {
            paramMap.put(param.getName(), param.getValue());
        }
        ArrayList<BasicNameValuePair> newParams = new ArrayList<BasicNameValuePair>(paramMap.size() + 1);
        if (this.charset != null && !paramMap.containsKey(CHARSET)) {
            newParams.add(new BasicNameValuePair(CHARSET, this.charset.name()));
        }
        for (Map.Entry entry : paramMap.entrySet()) {
            newParams.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
        }
        return ContentType.create(this.getMimeType(), newParams.toArray(EMPTY_NAME_VALUE_PAIR_ARRAY), true);
    }

    public boolean isSameMimeType(ContentType contentType) {
        return contentType != null && this.mimeType.equalsIgnoreCase(contentType.getMimeType());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentType)) {
            return false;
        }
        ContentType c = (ContentType)obj;
        return this.toString().equals(c.toString());
    }
}

