/*
 * Decompiled with CFR 0.152.
 */
package top.yqingyu.httpserver.compoment;

public class Cookie {
    private final String name;
    private String value;
    private int maxAge = -1;
    private int version = 0;
    private String comment;
    private String domain;
    private String path;
    private boolean secure = false;
    private boolean httpOnly = false;

    public Cookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String toSetString() {
        StringBuilder sb = new StringBuilder();
        sb.append("set-cookie: ");
        sb.append(this.name).append("=").append(this.value == null ? "" : this.value);
        if (this.version != 0) {
            sb.append("; ").append("Version").append("=").append(this.version);
        }
        if (this.comment != null) {
            sb.append("; ").append("Comment").append("=").append(this.comment);
        }
        if (this.path != null) {
            sb.append("; ").append("Path").append("=").append(this.path);
        }
        if (this.domain != null) {
            sb.append("; ").append("Domain").append("=").append(this.domain);
        }
        sb.append("; ").append("Max-Age").append("=").append(this.maxAge);
        if (this.secure) {
            sb.append("; ").append("Secure");
        }
        if (this.httpOnly) {
            sb.append(";").append("HttpOnly");
        }
        return sb.append("\r\n").toString();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }
}

