/*
 * Decompiled with CFR 0.152.
 */
package top.yqingyu.httpserver.compoment;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.alibaba.fastjson2.JSON;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.yqingyu.common.nio;
import top.yqingyu.common.utils.ArrayUtil;
import top.yqingyu.common.utils.IoUtil;
import top.yqingyu.common.utils.StringUtil;
import top.yqingyu.httpserver.compoment.ContentType;
import top.yqingyu.httpserver.compoment.HttpAction;
import top.yqingyu.httpserver.compoment.HttpEventEntity;
import top.yqingyu.httpserver.compoment.HttpMethod;
import top.yqingyu.httpserver.compoment.LocationMapping;
import top.yqingyu.httpserver.compoment.MultipartFile;
import top.yqingyu.httpserver.compoment.Request;
import top.yqingyu.httpserver.compoment.Response;

class DoRequest
implements Callable<Object> {
    private final LinkedBlockingQueue<Object> QUEUE;
    private final SocketChannel socketChannel;
    static long DEFAULT_BUF_LENGTH;
    static long MAX_BODY_SIZE;
    static long MAX_HEADER_SIZE;
    static boolean ALLOW_UPDATE;
    private static final Logger log;

    DoRequest(SocketChannel socketChannel, LinkedBlockingQueue<Object> QUEUE) {
        this.socketChannel = socketChannel;
        this.QUEUE = QUEUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        LocalDateTime now = LocalDateTime.now();
        HttpAction httpAction = null;
        try {
            httpAction = this.parseRequest();
            Request request = null;
            Response response = null;
            if (httpAction instanceof Request) {
                request = (Request)httpAction;
            } else if (httpAction instanceof Response) {
                response = (Response)httpAction;
            }
            this.createResponse(request, response, false);
        }
        catch (nio.RebuildSelectorException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            log.debug(JSON.toJSONString((Object)httpAction));
            log.debug("{}\u51fa cost {} MICROS", (Object)this.socketChannel.hashCode(), (Object)LocalDateTimeUtil.between((LocalDateTime)now, (LocalDateTime)LocalDateTime.now(), (ChronoUnit)ChronoUnit.MICROS));
        }
        return null;
    }

    private void createResponse(Request request, Response response, boolean notEnd) throws InterruptedException {
        HttpEventEntity httpEventEntity = new HttpEventEntity(this.socketChannel, notEnd);
        httpEventEntity.setRequest(request);
        httpEventEntity.setResponse(response);
        this.QUEUE.put(httpEventEntity);
    }

    private HttpAction parseRequest() throws Exception {
        byte[] all = new byte[]{};
        AtomicInteger enumerator = new AtomicInteger();
        Request request = new Request();
        InetSocketAddress remoteAddress = (InetSocketAddress)this.socketChannel.getRemoteAddress();
        request.setInetSocketAddress(remoteAddress);
        request.setHost(remoteAddress.getHostString());
        boolean flag = false;
        do {
            int currentStep = enumerator.getAndIncrement();
            byte[] temp = new byte[]{};
            try {
                temp = IoUtil.readBytes2((SocketChannel)this.socketChannel, (int)((int)DEFAULT_BUF_LENGTH));
            }
            catch (IOException e) {
                this.socketChannel.close();
            }
            int currentLength = temp.length;
            if (currentStep == 0 && (long)temp.length < DEFAULT_BUF_LENGTH && currentLength != 0) {
                ArrayList Info$header$body = ArrayUtil.splitByTarget((byte[])temp, (byte[])ArrayUtil.RN_RN);
                DoRequest.assembleHeader(request, (byte[])Info$header$body.remove(0), this.socketChannel);
                byte[] body = ArrayUtil.EMPTY_BYTE_ARRAY;
                for (byte[] bytes : Info$header$body) {
                    body = ArrayUtil.addAll((byte[])body, (byte[])bytes);
                }
                request.setBody(body);
                request.setParseEnd();
                break;
            }
            all = ArrayUtil.addAll((byte[])all, (byte[])temp);
            if (!flag) {
                if ((long)all.length > MAX_HEADER_SIZE) {
                    return Response.$400_BAD_REQUEST.putHeaderDate(ZonedDateTime.now()).setAssemble(true);
                }
                ArrayList bytes = ArrayUtil.splitByTarget((byte[])all, (byte[])ArrayUtil.RN_RN);
                if (bytes.size() != 0) {
                    flag = true;
                    DoRequest.assembleHeader(request, (byte[])bytes.get(0), this.socketChannel);
                    if (bytes.size() == 1 && StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)request.getHeader().getString("Content-Length"))) {
                        Response response = Response.$100_CONTINUE.putHeaderDate(ZonedDateTime.now());
                        this.createResponse(request, response, true);
                    }
                }
            }
            if (HttpMethod.GET.equals((Object)request.getMethod())) {
                request.setParseEnd();
                return request;
            }
            if (!flag) continue;
            long contentLength = request.getHeader().getLongValue("Content-Length", -1L);
            if (contentLength > MAX_BODY_SIZE || (long)all.length > MAX_BODY_SIZE) {
                return Response.$413_ENTITY_LARGE.putHeaderDate(ZonedDateTime.now()).setAssemble(true);
            }
            if ((long)currentLength >= DEFAULT_BUF_LENGTH && all.length != currentLength) continue;
            int idx = ArrayUtil.firstIndexOfTarget((byte[])all, (byte[])ArrayUtil.RN_RN);
            int efIdx = idx + ArrayUtil.RN_RN.length;
            if (idx == -1) {
                return Response.$400_BAD_REQUEST.putHeaderDate(ZonedDateTime.now()).setAssemble(true);
            }
            if (efIdx == all.length) {
                request.setParseEnd();
                continue;
            }
            int currentContentLength = all.length - efIdx;
            String header = request.getHeader("Content-Type");
            ContentType parse = ContentType.parse(header);
            if (ContentType.MULTIPART_FORM_DATA.isSameMimeType(parse) && ALLOW_UPDATE) {
                if (!LocationMapping.MULTIPART_BEAN_RESOURCE_MAPPING.containsKey(request.getUrl().split("[?]")[0])) {
                    this.socketChannel.shutdownInput();
                    return Response.$401_BAD_REQUEST.putHeaderDate(ZonedDateTime.now()).setAssemble(true);
                }
                DoRequest.fileUpload(request, this.socketChannel, parse, all, efIdx, currentContentLength, contentLength);
                continue;
            }
            long ll = contentLength - (long)currentContentLength;
            if (contentLength == -1L) continue;
            temp = IoUtil.readBytes2((SocketChannel)this.socketChannel, (int)((int)ll));
            byte[] body = new byte[(int)contentLength];
            System.arraycopy(all, efIdx, body, 0, currentContentLength);
            System.arraycopy(temp, 0, body, currentContentLength, (int)ll);
            request.setBody(body);
            request.setParseEnd();
        } while (!request.isParseEnd() && all.length != 0);
        return request;
    }

    static void assembleHeader(Request request, byte[] header, SocketChannel socketChannel) throws Exception {
        ArrayList info$header = ArrayUtil.splitByTarget((byte[])header, (byte[])ArrayUtil.RN);
        ArrayList info = ArrayUtil.splitByTarget((byte[])((byte[])info$header.remove(0)), (byte[])ArrayUtil.SPACE);
        if (info.size() < 3) {
            socketChannel.close();
            throw new nio.RebuildSelectorException("\u6d88\u606f\u89e3\u6790\u5f02\u5e38");
        }
        request.setMethod((byte[])info.get(0));
        request.setUrl((byte[])info.get(1));
        request.setHttpVersion((byte[])info.get(2));
        int i = StringUtils.indexOf((CharSequence)request.getUrl(), (int)63);
        if (i != -1) {
            String substring = request.getUrl().substring(i + 1);
            String[] split = substring.split("&");
            for (int j = 0; j < split.length; ++j) {
                String[] urlParamKV = split[j].split("=");
                if (urlParamKV.length == 2) {
                    request.putUrlParam(urlParamKV[0], urlParamKV[1]);
                    continue;
                }
                request.putUrlParam("NoKey_" + j, split[j]);
            }
        }
        for (byte[] bytes : info$header) {
            ArrayList headerName_value = ArrayUtil.splitByTarget((byte[])bytes, (byte[])ArrayUtil.COLON_SPACE);
            request.putHeader((byte[])headerName_value.get(0), headerName_value.size() == 2 ? (byte[])headerName_value.get(1) : null);
        }
    }

    static void fileUpload(Request request, SocketChannel socketChannel, ContentType parse, byte[] all, int efIdx, int currentContentLength, long contentLength) throws IOException {
        String boundary = "--" + parse.getParameter("boundary") + "\r\n";
        byte[] boundaryBytes = boundary.getBytes();
        byte[] temp = ArrayUtils.subarray((byte[])all, (int)efIdx, (int)all.length);
        Stack<MultipartFile> multipartFileStack = new Stack<MultipartFile>();
        while ((long)currentContentLength < contentLength) {
            ArrayList boundarys = ArrayUtil.splitByTarget((byte[])temp, (byte[])boundaryBytes);
            if (boundarys.size() > 0 || multipartFileStack.size() > 0) {
                for (int i = 0; i < boundarys.size(); ++i) {
                    byte[] multiHeaderBytes;
                    ArrayList multiHeader;
                    if (i == 0 && multipartFileStack.size() > 0) {
                        ((MultipartFile)multipartFileStack.peek()).write((byte[])boundarys.get(0));
                        continue;
                    }
                    ArrayList bytes = ArrayUtil.splitByTarget((byte[])((byte[])boundarys.get(i)), (byte[])ArrayUtil.RN_RN);
                    if (bytes.size() <= 0 || (multiHeader = ArrayUtil.splitByTarget((byte[])(multiHeaderBytes = (byte[])bytes.get(0)), (byte[])ArrayUtil.RN)).size() != 2) continue;
                    String Content_Disposition = new String((byte[])multiHeader.get(0), StandardCharsets.UTF_8);
                    String[] Content_Dispositions = Content_Disposition.split("filename=\"");
                    String fileName = StringUtil.removeEnd((String)Content_Dispositions[1], (String)"\"");
                    MultipartFile multipartFile = new MultipartFile(fileName, "/tmp");
                    multipartFileStack.push(multipartFile);
                    if (bytes.size() != 2) continue;
                    ((MultipartFile)multipartFileStack.peek()).write((byte[])bytes.get(1));
                }
            }
            temp = IoUtil.readBytes2((SocketChannel)socketChannel, (int)((int)DEFAULT_BUF_LENGTH * 2));
            currentContentLength += temp.length;
        }
        request.setMultipartFile(((MultipartFile)multipartFileStack.pop()).endWrite());
        request.setParseEnd();
    }

    static void assembleMultipartFileHeader() {
    }

    static {
        ALLOW_UPDATE = true;
        log = LoggerFactory.getLogger(DoRequest.class);
    }
}

