/*
 * Decompiled with CFR 0.152.
 */
package top.yqingyu.httpserver.compoment;

import cn.hutool.core.date.LocalDateTimeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.yqingyu.common.qydata.ConcurrentDataMap;
import top.yqingyu.common.utils.GzipUtil;
import top.yqingyu.common.utils.IoUtil;
import top.yqingyu.httpserver.compoment.ContentType;
import top.yqingyu.httpserver.compoment.Cookie;
import top.yqingyu.httpserver.compoment.HttpEventEntity;
import top.yqingyu.httpserver.compoment.HttpVersion;
import top.yqingyu.httpserver.compoment.LocationMapping;
import top.yqingyu.httpserver.compoment.Request;
import top.yqingyu.httpserver.compoment.Response;
import top.yqingyu.httpserver.compoment.Session;

class DoResponse
implements Callable<Object> {
    private final LinkedBlockingQueue<Object> QUEUE;
    private final Selector selector;
    static long DEFAULT_SEND_BUF_LENGTH;
    static boolean FILE_COMPRESS_ON;
    static ArrayList<ContentType> UN_DO_COMPRESS_FILE;
    static long MAX_SINGLE_FILE_COMPRESS_SIZE;
    static boolean CACHE_POOL_ON;
    static long MAX_FILE_CACHE_SIZE;
    static long SESSION_TIME_OUT;
    private final AtomicLong CurrentFileCacheSize = new AtomicLong();
    private static final ConcurrentDataMap<String, byte[]> FILE_BYTE_CACHE;
    private static final Logger log;

    public DoResponse(LinkedBlockingQueue<Object> QUEUE, Selector selector) {
        this.QUEUE = QUEUE;
        this.selector = selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        SocketChannel socketChannel = null;
        LocalDateTime now = LocalDateTime.now();
        try {
            HttpEventEntity httpEventEntity;
            do {
                httpEventEntity = (HttpEventEntity)this.QUEUE.take();
                socketChannel = httpEventEntity.getSocketChannel();
                Request request = httpEventEntity.getRequest();
                Response response = httpEventEntity.getResponse();
                if (response == null) {
                    response = new Response();
                }
                if (request == null) {
                    request = new Request();
                }
                AtomicReference<Response> resp = new AtomicReference<Response>();
                resp.set(response);
                response.setHttpVersion(HttpVersion.V_1_1);
                response.putHeaderDate(ZonedDateTime.now());
                this.initResponse(request, resp);
                if (FILE_COMPRESS_ON && !UN_DO_COMPRESS_FILE.contains(resp.get().gainHeaderContentType())) {
                    this.compress(request, resp);
                }
                this.doResponse(resp, socketChannel);
            } while (httpEventEntity.isNotEnd());
            socketChannel.register(this.selector, 1);
            log.debug("{} cost {} MICROS", (Object)socketChannel.hashCode(), (Object)LocalDateTimeUtil.between((LocalDateTime)now, (LocalDateTime)LocalDateTime.now(), (ChronoUnit)ChronoUnit.MICROS));
        }
        catch (NullPointerException e) {
            socketChannel.shutdownInput();
            socketChannel.shutdownOutput();
            socketChannel.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            socketChannel.shutdownInput();
            socketChannel.shutdownOutput();
            socketChannel.close();
        }
        return null;
    }

    void initResponse(Request request, AtomicReference<Response> resp) {
        Response response = resp.get();
        if (!response.isAssemble()) {
            LocationMapping.fileResourceMapping(request, response);
        }
        if (!response.isAssemble()) {
            Session session;
            String sessionID = request.getCookie("sessionVersionID");
            if (Session.SESSION_CONTAINER.containsKey((Object)sessionID)) {
                session = (Session)Session.SESSION_CONTAINER.get((Object)sessionID);
            } else {
                session = new Session();
                Session.SESSION_CONTAINER.put((Object)session.getSessionVersionID(), (Object)session);
            }
            request.setSession(session);
            LocationMapping.beanResourceMapping(request, response);
            if (response.isAssemble() && request.getSession().isNewInstance()) {
                session.setNewInstance(false);
                Cookie cookie = new Cookie("sessionVersionID", session.getSessionVersionID());
                cookie.setMaxAge((int)SESSION_TIME_OUT);
                response.addCookie(cookie);
            }
        }
        if (!response.isAssemble()) {
            resp.setRelease(Response.$404_NOT_FOUND.putHeaderDate(ZonedDateTime.now()));
        }
    }

    private void compress(Request request, AtomicReference<Response> resp) throws IOException {
        Response response = resp.get();
        String url = request.getUrl();
        ContentType requestCtTyp = ContentType.parse(request.getHeader("Content-Type"));
        Charset charset = requestCtTyp != null ? (requestCtTyp.getCharset() == null ? StandardCharsets.UTF_8 : requestCtTyp.getCharset()) : StandardCharsets.UTF_8;
        if ((!"304|100".contains(response.getStatue_code()) || response.getStrBody() != null ^ response.gainFileBody() == null) && request.canCompress()) {
            String strBody = response.getStrBody();
            if (StringUtils.isNotBlank((CharSequence)strBody)) {
                byte[] bytes = GzipUtil.$2CompressBytes((String)strBody, (Charset)charset);
                ByteBuffer buffer = ByteBuffer.allocateDirect(bytes.length);
                buffer.put(bytes);
                response.setCompress_body(buffer);
                response.putHeaderContentLength(bytes.length).putHeaderCompress();
            } else if (FILE_BYTE_CACHE.containsKey((Object)url)) {
                byte[] bytes = (byte[])FILE_BYTE_CACHE.get((Object)url);
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(bytes.length);
                byteBuffer.put(bytes);
                response.setCompress_body(byteBuffer);
                response.putHeaderContentLength(byteBuffer.limit()).putHeaderCompress();
            } else {
                long length;
                File file = response.getFile_body();
                if (file != null && (length = file.length()) < MAX_SINGLE_FILE_COMPRESS_SIZE && this.CurrentFileCacheSize.get() < MAX_FILE_CACHE_SIZE) {
                    byte[] bytes = GzipUtil.$2CompressBytes((File)response.getFile_body());
                    ByteBuffer buffer = ByteBuffer.allocateDirect(bytes.length);
                    buffer.put(bytes);
                    if (CACHE_POOL_ON) {
                        FILE_BYTE_CACHE.put((Object)url, (Object)bytes);
                        this.CurrentFileCacheSize.addAndGet(bytes.length);
                    }
                    response.setCompress_body(buffer);
                    response.putHeaderContentLength(bytes.length).putHeaderCompress();
                }
            }
        }
    }

    private void doResponse(AtomicReference<Response> resp, SocketChannel socketChannel) throws Exception {
        Response response = resp.get();
        ContentType type = response.gainHeaderContentType();
        byte[] bytes = type != null && type.getCharset() != null ? response.toString().getBytes(type.getCharset()) : response.toString().getBytes();
        try {
            IoUtil.writeBytes((SocketChannel)socketChannel, (byte[])bytes, (long)2000L);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            socketChannel.close();
        }
        if (!"304|100".contains(response.getStatue_code()) || response.getStrBody() != null ^ response.gainFileBody() == null) {
            byte[] buf = new byte[(int)DEFAULT_SEND_BUF_LENGTH];
            File file_body = response.getFile_body();
            if (file_body != null && !response.isCompress()) {
                FileChannel fileChannel = new FileInputStream(response.getFile_body()).getChannel();
                long l = 0L;
                long size = fileChannel.size();
                while ((l += fileChannel.transferTo(l, DEFAULT_SEND_BUF_LENGTH, socketChannel)) != size) {
                }
                fileChannel.close();
            } else {
                try {
                    IoUtil.writeBytes((SocketChannel)socketChannel, (ByteBuffer)response.gainBodyBytes(), (long)2000L);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                    socketChannel.close();
                }
            }
        }
        log.debug("Response: {}", (Object)response.toJsonString());
    }

    static {
        UN_DO_COMPRESS_FILE = new ArrayList<ContentType>(Arrays.asList(ContentType.APPLICATION_OCTET_STREAM, ContentType.IMAGE_JPEG, ContentType.IMAGE_PNG, ContentType.IMAGE_GIF, ContentType.IMAGE_WEBP, ContentType.IMAGE_BMP, ContentType.IMAGE_SVG, ContentType.IMAGE_X_ICON, ContentType.IMAGE_TIFF, ContentType.VIDEO_AVI, ContentType.VIDEO_MP4, ContentType.VIDEO_MPEG4, ContentType.VIDEO_WMV, ContentType.VIDEO_WEBM, ContentType.AUDIO_MP3));
        FILE_BYTE_CACHE = new ConcurrentDataMap();
        log = LoggerFactory.getLogger(DoResponse.class);
    }
}

