/*
 * Decompiled with CFR 0.152.
 */
package top.yqingyu.httpserver.compoment;

import cn.hutool.core.date.LocalDateTimeUtil;
import java.io.IOException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.yqingyu.common.nio;
import top.yqingyu.common.qydata.ConcurrentQyMap;
import top.yqingyu.common.qydata.DataList;
import top.yqingyu.common.qydata.DataMap;
import top.yqingyu.common.utils.UnitUtil;
import top.yqingyu.common.utils.YamlUtil;
import top.yqingyu.httpserver.compoment.DoRequest;
import top.yqingyu.httpserver.compoment.DoResponse;
import top.yqingyu.httpserver.compoment.LocationMapping;

public class HttpEventHandler
extends nio.EventHandler {
    private static final nio.OperatingRecorder<Integer> SOCKET_CHANNEL_RECORD = nio.OperatingRecorder.createNormalRecorder((Long)0x200000L);
    static final nio.OperatingRecorder<Integer> SOCKET_CHANNEL_ACK = nio.OperatingRecorder.createAckRecorder((Long)10L);
    public static int port;
    public static int handlerNumber;
    public static int perHandlerWorker;
    private static long connectTimeMax;
    private static final Logger log;

    public HttpEventHandler() throws IOException {
    }

    public HttpEventHandler(Selector selector) throws IOException {
        super(selector);
        SocketChannelMonitor monitor = new SocketChannelMonitor();
        Thread th = new Thread(monitor);
        th.setName("Monitor" + Thread.currentThread().getName());
        th.setDaemon(true);
        th.start();
    }

    protected void loading() {
        DataMap yamlUtil = YamlUtil.loadYaml((String)"server-cfg", (YamlUtil.LoadType)YamlUtil.LoadType.BOTH).getCfgData();
        DataMap cfg = yamlUtil.getNotNUllData("server-cfg.yml");
        if (cfg.size() == 0) {
            cfg = yamlUtil.getNotNUllData("server-cfg.template.yml");
        }
        DataMap server = cfg.getNotNUllData("server");
        port = server.getIntValue("port", 4732);
        handlerNumber = server.getIntValue("handler-num", 4);
        perHandlerWorker = server.getIntValue("per-worker-num", 4);
        Long workerKeepLiveTime = server.$2MILLS("worker-keep-live-time", UnitUtil.$2MILLS((String)"2H"));
        connectTimeMax = server.$2MILLS("connect-time-max", UnitUtil.$2MILLS((String)"15S"));
        boolean open_resource = server.getBooleanValue("open-resource", true);
        boolean open_controller = server.getBooleanValue("open-controller", true);
        if (open_resource) {
            DataList pathList = server.getDataList("local-resource-path");
            if (pathList == null || pathList.size() == 0) {
                String path = System.getProperty("user.dir");
                LocationMapping.loadingFileResource(path);
            } else {
                for (int i = 0; i < pathList.size(); ++i) {
                    LocationMapping.loadingFileResource(pathList.getString(i));
                }
            }
        }
        if (open_controller) {
            DataList scan_packages = server.getDataList("controller-package");
            if (scan_packages == null || scan_packages.size() == 0) {
                LocationMapping.loadingBeanResource("top.yqingyu.httpserver.web.controller");
            } else {
                for (int i = 0; i < scan_packages.size(); ++i) {
                    LocationMapping.loadingBeanResource(scan_packages.getString(i));
                }
            }
        }
        DataMap transfer = cfg.getNotNUllData("transfer");
        DataMap request = transfer.getNotNUllData("request");
        DoRequest.DEFAULT_BUF_LENGTH = request.$2B("parse-buffer-size", UnitUtil.$2B((String)"1KB"));
        DoRequest.MAX_HEADER_SIZE = request.$2B("max-header-size", UnitUtil.$2B((String)"64KB"));
        DoRequest.MAX_BODY_SIZE = request.$2B("max-body-size", UnitUtil.$2B((String)"128MB"));
        DataMap response = transfer.getNotNUllData("response");
        DoResponse.DEFAULT_SEND_BUF_LENGTH = response.$2B("send-buf-size", UnitUtil.$2B((String)"2MB"));
        DataMap file_compress = cfg.getNotNUllData("file-compress");
        DoResponse.FILE_COMPRESS_ON = file_compress.getBoolean("open", Boolean.valueOf(true));
        DoResponse.MAX_SINGLE_FILE_COMPRESS_SIZE = file_compress.$2B("max-single-file-compress-size", UnitUtil.$2B((String)"128MB"));
        DataMap compressPool = file_compress.getNotNUllData("compress-cache-pool");
        DoResponse.MAX_FILE_CACHE_SIZE = compressPool.$2B("max-file-cache-size", UnitUtil.$2B((String)"0.5GB"));
        DoResponse.CACHE_POOL_ON = compressPool.getBoolean("open", Boolean.valueOf(true));
        DataMap session = cfg.getNotNUllData("session");
        DoResponse.SESSION_TIME_OUT = session.$2S("session-timeout", UnitUtil.$2S((String)"7DAY"));
    }

    public void read(Selector selector, SocketChannel socketChannel) throws Exception {
        socketChannel.register(selector, 4);
        int i = socketChannel.hashCode();
        ((ConcurrentQyMap)this.SOCKET_CHANNELS.get((Object)i)).put((Object)"LocalDateTime", (Object)LocalDateTime.now());
        DoRequest doRequest = new DoRequest(socketChannel, this.QUEUE);
        doRequest.call();
        DoResponse doResponse = new DoResponse(this.QUEUE, selector);
        doResponse.call();
    }

    public void write(Selector selector, SocketChannel socketChannel) throws Exception {
        try {
            SOCKET_CHANNEL_RECORD.add2((Object)socketChannel.hashCode());
        }
        catch (nio.RebuildSelectorException e) {
            SOCKET_CHANNEL_RECORD.remove((Object)socketChannel.hashCode());
            socketChannel.close();
        }
    }

    public void assess(Selector selector, SocketChannel socketChannel) throws Exception {
    }

    static {
        log = LoggerFactory.getLogger(HttpEventHandler.class);
    }

    class SocketChannelMonitor
    implements Runnable {
        SocketChannelMonitor() {
        }

        @Override
        public void run() {
            while (true) {
                LocalDateTime a = LocalDateTime.now();
                HttpEventHandler.this.SOCKET_CHANNELS.forEach((i, s) -> {
                    try {
                        LocalDateTime b = (LocalDateTime)s.get((Object)"LocalDateTime", LocalDateTime.class);
                        SocketChannel socketChannel = (SocketChannel)s.get((Object)"SocketChannel", SocketChannel.class);
                        long between = LocalDateTimeUtil.between((LocalDateTime)b, (LocalDateTime)a, (ChronoUnit)ChronoUnit.MILLIS);
                        if (between > connectTimeMax && !socketChannel.isConnectionPending()) {
                            HttpEventHandler.this.SOCKET_CHANNELS.remove(i);
                            socketChannel.close();
                        }
                    }
                    catch (Exception e) {
                        log.error("\u65ad\u94fe\u5f02\u5e38", (Throwable)e);
                    }
                });
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    log.error("\u7ebf\u7a0b\u5f02\u5e38", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

