/*
 * Decompiled with CFR 0.152.
 */
package top.yqingyu.httpserver.compoment;

import cn.hutool.core.lang.UUID;
import com.alibaba.fastjson2.JSON;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.yqingyu.common.asm.impl.MethodParamGetter;
import top.yqingyu.common.qydata.DataMap;
import top.yqingyu.common.utils.ClazzUtil;
import top.yqingyu.common.utils.StringUtil;
import top.yqingyu.common.utils.YamlUtil;
import top.yqingyu.httpserver.annotation.QyController;
import top.yqingyu.httpserver.compoment.Bean;
import top.yqingyu.httpserver.compoment.ContentType;
import top.yqingyu.httpserver.compoment.HttpMethod;
import top.yqingyu.httpserver.compoment.MultipartFile;
import top.yqingyu.httpserver.compoment.Request;
import top.yqingyu.httpserver.compoment.Response;
import top.yqingyu.httpserver.exception.HttpException;

public class LocationMapping {
    private static final Logger log = LoggerFactory.getLogger(LocationMapping.class);
    public static final ConcurrentHashMap<String, String> FILE_RESOURCE_MAPPING = new ConcurrentHashMap();
    static final ConcurrentHashMap<String, Bean> BEAN_RESOURCE_MAPPING = new ConcurrentHashMap();
    static final ConcurrentHashMap<String, Bean> MULTIPART_BEAN_RESOURCE_MAPPING = new ConcurrentHashMap();
    static final ConcurrentHashMap<String, String> FILE_CACHING = new ConcurrentHashMap();
    static final String FORM = "{\"body\"}";
    static final String[] FILE_SUFFIX = new String[]{".html", "index.html", "index.htm"};

    static void loadingFileResource(String rootPath) {
        HashMap mapping = YamlUtil.getFilePathMapping((String)rootPath);
        FILE_RESOURCE_MAPPING.putAll(mapping);
        log.debug("loading  {} resource mapping", (Object)rootPath);
    }

    static void loadingBeanResource(String packageName) {
        List classes = ClazzUtil.getClassListByAnnotation((String)packageName, QyController.class);
        for (Class aClass : classes) {
            QyController annotation = aClass.getAnnotation(QyController.class);
            String parentPath = annotation.path();
            Object instance = null;
            Method[] methods = aClass.getDeclaredMethods();
            Constructor<?>[] aClassConstructors = aClass.getConstructors();
            for (Constructor<?> constructor : aClassConstructors) {
                Parameter[] parameters = constructor.getParameters();
                if (parameters.length != 0) continue;
                try {
                    instance = constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    log.error("bean mapping error constructor error ", (Throwable)e);
                }
            }
            for (Executable executable : methods) {
                String path;
                QyController methodAnnotation;
                if (executable.trySetAccessible()) {
                    ((Method)executable).setAccessible(true);
                }
                if ((methodAnnotation = ((Method)executable).getAnnotation(QyController.class)) == null) continue;
                Bean bean = new Bean();
                Object methodPath = methodAnnotation.path();
                HttpMethod[] httpMethods = methodAnnotation.method();
                bean.setType(aClass);
                bean.setObj(instance);
                bean.setHttpMethods(httpMethods);
                bean.setMethod((Method)executable);
                String[] parameterNames = MethodParamGetter.doGetParameterNames((Executable)executable);
                bean.setMethodParamName(parameterNames);
                Class<?>[] parameterTypes = ((Method)executable).getParameterTypes();
                String[] parameterTypeName = new String[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameterTypeName[i] = parameterTypes[i].getName();
                }
                bean.setMethodParamType(parameterTypeName);
                if (((String)methodPath).indexOf("/") != 0) {
                    methodPath = "/" + (String)methodPath;
                }
                if ((path = parentPath + (String)methodPath).indexOf("/") != 0) {
                    path = "/" + path;
                }
                BEAN_RESOURCE_MAPPING.put(path, bean);
                if (parameterNames != null && Arrays.asList(parameterTypeName).contains(MultipartFile.class.getName())) {
                    MULTIPART_BEAN_RESOURCE_MAPPING.put(path, bean);
                }
                log.debug("add bean mapping {}  > {}", (Object)path, (Object)bean);
            }
        }
    }

    static void fileResourceMapping(Request request, Response response) {
        String url = request.getUrl();
        String[] urls = url.split("[?]");
        url = urls[0];
        String s = FILE_RESOURCE_MAPPING.get(url);
        String[] fillUrl = LocationMapping.fillUrl(url, s, response);
        url = fillUrl[0];
        s = fillUrl[1];
        if (StringUtils.isNotBlank((CharSequence)s)) {
            String eTagValue;
            File file = new File(s);
            ContentType contentType = ContentType.parseContentType(s);
            String stateCode = "200";
            Object eTag = request.getHeader("If-None-Match");
            if (StringUtil.equalsNull((CharSequence)eTag, (CharSequence)(eTagValue = FILE_CACHING.get(url)))) {
                stateCode = "304";
                response.putHeader("ETag", (String)eTag);
            } else if (StringUtils.isNotBlank((CharSequence)eTagValue)) {
                response.putHeader("ETag", eTagValue);
            } else {
                eTag = "W/\"" + UUID.randomUUID() + "\"";
                response.putHeader("ETag", (String)eTag);
                FILE_CACHING.put(url, (String)eTag);
            }
            response.putHeaderContentType(contentType).putHeaderAcceptRanges().putHeaderCROS().setStatue_code(stateCode);
            if (ContentType.VIDEO_MP4.equals(contentType)) {
                response.putHeaderContentRanges();
            }
            response.setFile_body(file);
            response.setAssemble(true);
        }
    }

    static String[] fillUrl(String url, String s, Response response) {
        for (String fileSuffix : FILE_SUFFIX) {
            if (StringUtil.isNotBlank((CharSequence)s)) {
                return new String[]{url, s};
            }
            if (StringUtils.isBlank((CharSequence)s) && StringUtil.isNotBlank((CharSequence)(s = FILE_RESOURCE_MAPPING.get((String)url + fileSuffix)))) {
                url = (String)url + fileSuffix;
            }
            if (!StringUtils.isBlank((CharSequence)s) || !StringUtils.isNotBlank((CharSequence)(s = FILE_RESOURCE_MAPPING.get((String)url + "/" + fileSuffix)))) continue;
            if (((String)(url = (String)url + "/" + fileSuffix)).indexOf("/") != 0) {
                url = "/" + (String)url;
            }
            response.setStatue_code("301").putHeaderRedirect((String)url);
        }
        return new String[]{url, s};
    }

    static void beanResourceMapping(Request request, Response response) {
        block29: {
            String url = request.getUrl();
            String[] urls = url.split("[?]");
            url = urls[0];
            Bean bean = BEAN_RESOURCE_MAPPING.get(url);
            try {
                Object methodReturn;
                if (bean == null) break block29;
                ContentType requestCtTyp = ContentType.parse(request.getHeader("Content-Type"));
                LocationMapping.matchHttpMethod(bean, request);
                Object invokeObj = bean.getObj();
                Method invokeMethod = bean.getMethod();
                Parameter[] parameters = invokeMethod.getParameters();
                Object[] args = new Object[parameters.length];
                String[] paramName = bean.getMethodParamName();
                DataMap urlParam = request.getUrlParam();
                if (HttpMethod.GET.equals((Object)request.getMethod())) {
                    if (parameters.length >= 1) {
                        for (i = 0; i < parameters.length; ++i) {
                            Type paramType = parameters[i].getParameterizedType();
                            String typeName = paramType.getTypeName();
                            int finalI = i;
                            if (Request.class.getName().equals(typeName)) {
                                args[i] = request;
                                continue;
                            }
                            if (Response.class.getName().equals(typeName)) {
                                args[i] = response;
                                continue;
                            }
                            if (parameters.length == 1 && urlParam.size() == 1) {
                                Set keySet = urlParam.keySet();
                                Iterator iterator = keySet.iterator();
                                args[i] = urlParam.get((String)iterator.next());
                                continue;
                            }
                            urlParam.forEach((k, v) -> {
                                if (paramName[finalI].equals(k)) {
                                    args[finalI] = v;
                                } else if (paramName[finalI].equalsIgnoreCase((String)k)) {
                                    args[finalI] = v;
                                }
                            });
                        }
                    }
                } else if (HttpMethod.POST.equals((Object)request.getMethod()) && ContentType.APPLICATION_FORM_URLENCODED.isSameMimeType(requestCtTyp)) {
                    if (parameters.length >= 1) {
                        for (i = 0; i < parameters.length; ++i) {
                            Type paramType = parameters[i].getParameterizedType();
                            String typeName = paramType.getTypeName();
                            if (Request.class.getName().equals(typeName)) {
                                args[i] = request;
                                continue;
                            }
                            if (Response.class.getName().equals(typeName)) {
                                args[i] = request;
                                continue;
                            }
                            if (ClazzUtil.canValueof((Type)paramType)) {
                                args[i] = new String(request.gainBody(), requestCtTyp.getCharset() == null ? StandardCharsets.UTF_8 : requestCtTyp.getCharset());
                                continue;
                            }
                            String body = new String(request.gainBody(), requestCtTyp.getCharset() == null ? StandardCharsets.UTF_8 : requestCtTyp.getCharset());
                            body = body.replaceAll("&", "\",\"").replaceAll("=", "\":\"");
                            body = URLDecoder.decode(body, requestCtTyp.getCharset() == null ? StandardCharsets.UTF_8 : requestCtTyp.getCharset());
                            body = FORM.replace("body", body);
                            args[i] = JSON.parseObject((String)body, (Type)paramType);
                        }
                    }
                } else if (HttpMethod.POST.equals((Object)request.getMethod()) && parameters.length >= 1) {
                    for (i = 0; i < parameters.length; ++i) {
                        byte[] body;
                        Type paramType = parameters[i].getParameterizedType();
                        String typeName = paramType.getTypeName();
                        if (Request.class.getName().equals(typeName)) {
                            args[i] = request;
                            continue;
                        }
                        if (Response.class.getName().equals(typeName)) {
                            args[i] = request;
                            continue;
                        }
                        if (StringUtils.isNotBlank((CharSequence)urlParam.getString(paramName[i])) && ClazzUtil.canValueof((Type)paramType)) {
                            args[i] = urlParam.getString(paramName[i]);
                            continue;
                        }
                        if (MultipartFile.class.getName().equals(typeName)) {
                            args[i] = request.getMultipartFile();
                            continue;
                        }
                        if (ClazzUtil.canValueof((Type)paramType)) {
                            body = request.gainBody();
                            if (body == null) {
                                args[i] = null;
                                continue;
                            }
                            args[i] = new String(body, requestCtTyp.getCharset() == null ? StandardCharsets.UTF_8 : requestCtTyp.getCharset());
                            continue;
                        }
                        body = request.gainBody();
                        args[i] = body == null ? null : JSON.parseObject((byte[])request.gainBody(), (Type)paramType);
                    }
                }
                if (null != (methodReturn = invokeMethod.invoke(invokeObj, args))) {
                    if (ClazzUtil.canValueof(methodReturn.getClass())) {
                        response.setString_body((String)methodReturn).putHeaderContentType(ContentType.TEXT_HTML);
                    } else {
                        response.setString_body(JSON.toJSONString((Object)methodReturn)).putHeaderContentType(ContentType.APPLICATION_JSON);
                    }
                } else {
                    response.putHeaderContentLength(0L);
                }
                response.setStatue_code("200").putHeaderAcceptRanges().setAssemble(true);
            }
            catch (HttpException.MethodNotSupposedException e) {
                response.setString_body("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u652f\u6301").setStatue_code("400").putHeaderContentType(ContentType.TEXT_PLAIN).putHeaderDate(ZonedDateTime.now()).setAssemble(true);
            }
            catch (Exception e) {
                response.setString_body("\u545c\u545c\uff0c\u4eba\u5bb6\u574f\u6389\u4e86").setStatue_code("500").putHeaderContentType(ContentType.TEXT_PLAIN).putHeaderDate(ZonedDateTime.now()).setAssemble(true);
                log.error("", (Throwable)e);
            }
        }
    }

    static void matchHttpMethod(Bean bean, Request request) throws HttpException.MethodNotSupposedException {
        HttpMethod[] httpMethods = bean.getHttpMethods();
        HttpMethod method = request.getMethod();
        boolean $throws = true;
        for (HttpMethod httpMethod : httpMethods) {
            if (!method.equals((Object)httpMethod)) continue;
            $throws = false;
            break;
        }
        if ($throws) {
            throw new HttpException.MethodNotSupposedException("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u652f\u6301\uff01");
        }
    }
}

