/*
 * Decompiled with CFR 0.152.
 */
package top.yqingyu.httpserver.compoment;

import cn.hutool.core.lang.UUID;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

public class MultipartFile {
    private String fileName;
    private String originFileName = UUID.randomUUID().toString();
    private final File file;
    private FileChannel fileChannel;
    private FileInputStream fileInputStream;
    private FileOutputStream fileOutputStream;

    public MultipartFile(String fileName, String path) throws IOException {
        this.fileName = fileName;
        path = (String)path + "/";
        String[] split = fileName.split("[.]");
        if (split.length >= 2) {
            this.originFileName = this.originFileName + split[split.length - 1];
        }
        this.file = new File((String)path + this.originFileName);
        if (this.file.createNewFile()) {
            this.fileOutputStream = new FileOutputStream(this.file);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    public FileChannel getInputChannel() throws FileNotFoundException {
        return new FileInputStream(this.file).getChannel();
    }

    public void transferTo(String filePath) throws IOException {
        try (FileChannel channel = new FileOutputStream(filePath).getChannel();
             FileChannel channel0 = this.getInputChannel();){
            long l = 0L;
            long size = channel0.size();
            while ((l += channel0.transferTo(l, 2048L, channel)) != size) {
            }
        }
    }

    public void saveAs(String filePath) throws IOException {
        this.transferTo(filePath);
    }

    void write(byte[] bytes) throws IOException {
        this.fileOutputStream.write(bytes);
    }

    MultipartFile endWrite() throws IOException {
        this.fileOutputStream.close();
        return this;
    }
}

