/*
 * Decompiled with CFR 0.152.
 */
package top.yqingyu.httpserver.compoment;

import com.alibaba.fastjson2.JSON;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import top.yqingyu.common.qydata.DataMap;
import top.yqingyu.httpserver.compoment.HttpAction;
import top.yqingyu.httpserver.compoment.HttpMethod;
import top.yqingyu.httpserver.compoment.HttpVersion;
import top.yqingyu.httpserver.compoment.MultipartFile;
import top.yqingyu.httpserver.compoment.Session;

public class Request
implements HttpAction {
    private HttpMethod method;
    private HttpVersion httpVersion;
    private String url;
    private String host;
    private InetSocketAddress inetSocketAddress;
    private final DataMap urlParam = new DataMap();
    private final DataMap header = new DataMap();
    private final DataMap cookie = new DataMap();
    private Session session;
    private MultipartFile multipartFile;
    private byte[] body;
    private boolean parseEnd = false;

    void setParseEnd() {
        this.parseEnd = true;
    }

    void setMethod(byte[] method) {
        this.method = HttpMethod.getMethod(new String(method, StandardCharsets.UTF_8));
    }

    void setMethod(HttpMethod method) {
        this.method = method;
    }

    void setHttpVersion(HttpVersion httpVersion) {
        this.httpVersion = httpVersion;
    }

    void setHttpVersion(byte[] httpVersion) {
        this.httpVersion = HttpVersion.getVersion(new String(httpVersion, StandardCharsets.UTF_8));
    }

    void setUrl(String url) {
        this.url = url;
    }

    void setUrl(byte[] url) {
        this.url = URLDecoder.decode(new String(url, StandardCharsets.UTF_8), StandardCharsets.UTF_8);
    }

    void putHeader(String key, Object obj) {
        this.header.put(key, obj);
    }

    void putUrlParam(String key, Object obj) {
        this.urlParam.put(key, obj);
    }

    void setBody(byte[] body) {
        this.body = body;
    }

    void setSession(Session session) {
        this.session = session;
    }

    void putHeader(byte[] key, byte[] obj) {
        String vStr;
        String keyStr = new String(key, StandardCharsets.UTF_8);
        String string = vStr = obj == null ? "" : new String(obj, StandardCharsets.UTF_8);
        if ("Cookie".equals(keyStr)) {
            String[] cookies;
            for (String coo : cookies = vStr.split("; ")) {
                String[] split = coo.split("=");
                if ("sessionVersionID".equals(split[0]) && Session.SESSION_CONTAINER.containsKey((Object)split[1])) {
                    this.session = (Session)Session.SESSION_CONTAINER.get((Object)split[0]);
                }
                this.cookie.put(split[0], (Object)split[1]);
            }
        } else {
            this.header.put(keyStr, (Object)vStr);
        }
    }

    byte[] getBody() {
        return null;
    }

    byte[] gainBody() {
        return this.body;
    }

    DataMap getCookie() {
        return this.cookie;
    }

    boolean canCompress() {
        String string = this.header.getString("Accept-Encoding", "");
        return string.toUpperCase().contains("GZIP");
    }

    MultipartFile getMultipartFile() {
        return this.multipartFile;
    }

    void setMultipartFile(MultipartFile multipartFile) {
        this.multipartFile = multipartFile;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    public String getUrl() {
        return this.url;
    }

    public DataMap getHeader() {
        return this.header;
    }

    public String getHeader(String head) {
        return this.header.getString(head);
    }

    public String getCookie(String cook) {
        return this.cookie.getString(cook);
    }

    public Session getSession() {
        return this.session;
    }

    public DataMap getUrlParam() {
        return this.urlParam;
    }

    public String getUrlParam(String key) {
        return this.urlParam.getString(key);
    }

    public boolean isParseEnd() {
        return this.parseEnd;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.inetSocketAddress;
    }

    public void setInetSocketAddress(InetSocketAddress inetSocketAddress) {
        this.inetSocketAddress = inetSocketAddress;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }
}

